/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Locale;
import javax.media.j3d.IndexedTriangleArray;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import main.Segment;
import main.YaDiV;
import main.seggen.dm.surface.DMSurface;
import main.seggen.dm.surface.DMSurfaceWriter;
import main.seggen.dm.surface.loader.ITALoader;
import misc.linkedsurface.LinkedTriaSurface;
import threads.RSThread;

public class GeometryExport {
    public static String TYPE_STL_BINARY = "STL Binary";
    public static String TYPE_STL_ASCII = "STL ASCII";
    public static String TYPE_JANUS = "Janus";
    public static String TYPE_YDM_SURFACE = "YDM Surface";
    public static String[] TYPES = new String[]{TYPE_STL_BINARY, TYPE_STL_ASCII, TYPE_JANUS, TYPE_YDM_SURFACE};

    public static final void export_indexed_tria_data(final Segment[] segs, final String file_name, final String format, final Shape3D[] mcs, final Shape3D[] mc_closings, final Transform3D trans, final boolean export_normals) {
        RSThread t = new RSThread(null, true, false){

            @Override
            public void my_run() {
                if (format.equals(TYPE_JANUS)) {
                    GeometryExport.write_indexed_tria_to_janus_file(segs, file_name, mcs, mc_closings, trans, export_normals, this);
                } else if (format.equals(TYPE_STL_ASCII)) {
                    GeometryExport.write_indexed_tria_to_asc_stl_file(segs, file_name, mcs, mc_closings, trans, export_normals, this);
                } else if (format.equals(TYPE_STL_BINARY)) {
                    GeometryExport.write_indexed_tria_to_bin_stl_file(segs, file_name, mcs, mc_closings, trans, export_normals, this);
                } else if (format.equals(TYPE_YDM_SURFACE)) {
                    GeometryExport.write_indexed_tria_to_ydm_file(segs, file_name, mcs, mc_closings, trans, export_normals, this);
                } else {
                    YaDiV.report(YaDiV.ReportType.REPORT_ERROR, "unknown export format");
                }
            }
        };
        t.start();
    }

    private static final void write_stl_asc_trias(IndexedTriangleArray ita, Transform3D trans, BufferedWriter out, String ln, RSThread monitor) throws IOException {
        Point3f p0 = new Point3f();
        Point3f p1 = new Point3f();
        Point3f p2 = new Point3f();
        Vector3f n = new Vector3f();
        Vector3f n2 = new Vector3f();
        Vector3f n3 = new Vector3f();
        if (ita != null && ita.getIndexCount() > 0) {
            NumberFormat nf = NumberFormat.getInstance(Locale.US);
            nf.setGroupingUsed(false);
            nf.setMinimumFractionDigits(0);
            nf.setMaximumFractionDigits(20);
            int i = 0;
            while (i < ita.getIndexCount()) {
                ita.getCoordinate(ita.getCoordinateIndex(i + 0), p0);
                ita.getCoordinate(ita.getCoordinateIndex(i + 1), p1);
                ita.getCoordinate(ita.getCoordinateIndex(i + 2), p2);
                if (trans != null) {
                    trans.transform(p0);
                    trans.transform(p1);
                    trans.transform(p2);
                }
                ita.getNormal(ita.getCoordinateIndex(i + 0), n);
                ita.getNormal(ita.getCoordinateIndex(i + 1), n2);
                ita.getNormal(ita.getCoordinateIndex(i + 2), n3);
                n.add((Tuple3f)n2);
                n.add((Tuple3f)n3);
                n.normalize();
                out.write(" facet normal " + nf.format(n.x) + " " + nf.format(n.y) + " " + nf.format(n.z) + ln);
                out.write("  outer loop" + ln);
                out.write("   vertex " + nf.format(p0.x) + " " + nf.format(p0.y) + " " + nf.format(p0.z) + ln);
                out.write("   vertex " + nf.format(p1.x) + " " + nf.format(p1.y) + " " + nf.format(p1.z) + ln);
                out.write("   vertex " + nf.format(p2.x) + " " + nf.format(p2.y) + " " + nf.format(p2.z) + ln);
                out.write("  endloop" + ln);
                out.write(" endfacet" + ln);
                if (monitor != null) {
                    monitor.inc_progress_value(1);
                }
                i += 3;
            }
        }
    }

    private static final void write_stl_bin_trias(IndexedTriangleArray ita, Transform3D trans, FileOutputStream fos, RSThread monitor) throws IOException {
        Point3f p0 = new Point3f();
        Point3f p1 = new Point3f();
        Point3f p2 = new Point3f();
        Vector3f n = new Vector3f();
        Vector3f n2 = new Vector3f();
        Vector3f n3 = new Vector3f();
        byte[] buf = new byte[50];
        if (ita != null && ita.getIndexCount() > 0) {
            int i = 0;
            while (i < ita.getIndexCount()) {
                ita.getCoordinate(ita.getCoordinateIndex(i + 0), p0);
                ita.getCoordinate(ita.getCoordinateIndex(i + 1), p1);
                ita.getCoordinate(ita.getCoordinateIndex(i + 2), p2);
                if (trans != null) {
                    trans.transform(p0);
                    trans.transform(p1);
                    trans.transform(p2);
                }
                ita.getNormal(ita.getCoordinateIndex(i + 0), n);
                ita.getNormal(ita.getCoordinateIndex(i + 1), n2);
                ita.getNormal(ita.getCoordinateIndex(i + 2), n3);
                n.add((Tuple3f)n2);
                n.add((Tuple3f)n3);
                n.normalize();
                GeometryExport.write_stl_float(n.x, buf, 0);
                GeometryExport.write_stl_float(n.y, buf, 4);
                GeometryExport.write_stl_float(n.z, buf, 8);
                GeometryExport.write_stl_float(p0.x, buf, 12);
                GeometryExport.write_stl_float(p0.y, buf, 16);
                GeometryExport.write_stl_float(p0.z, buf, 20);
                GeometryExport.write_stl_float(p1.x, buf, 24);
                GeometryExport.write_stl_float(p1.y, buf, 28);
                GeometryExport.write_stl_float(p1.z, buf, 32);
                GeometryExport.write_stl_float(p2.x, buf, 36);
                GeometryExport.write_stl_float(p2.y, buf, 40);
                GeometryExport.write_stl_float(p2.z, buf, 44);
                fos.write(buf);
                if (monitor != null) {
                    monitor.inc_progress_value(1);
                }
                i += 3;
            }
        }
    }

    private static final void write_stl_int(FileOutputStream fos, int a) throws IOException {
        byte[] buf = new byte[4];
        buf[3] = (byte)(a >>> 24);
        buf[2] = (byte)(a >> 16 & 0xFF);
        buf[1] = (byte)(a >> 8 & 0xFF);
        buf[0] = (byte)(a & 0xFF);
        fos.write(buf);
    }

    private static final void write_stl_float(float f, byte[] buf, int idx) {
        int a = Float.floatToRawIntBits(f);
        buf[idx + 3] = (byte)(a >>> 24);
        buf[idx + 2] = (byte)(a >> 16 & 0xFF);
        buf[idx + 1] = (byte)(a >> 8 & 0xFF);
        buf[idx + 0] = (byte)(a & 0xFF);
    }

    public static final void write_indexed_tria_to_bin_stl_file(Segment[] segs, String file_name, Shape3D[] mcs, Shape3D[] mc_closings, Transform3D trans, boolean export_normals, RSThread monitor) {
        IndexedTriangleArray ita_closing;
        IndexedTriangleArray ita_mc;
        int i;
        if (monitor != null) {
            int progress_max = 0;
            i = 0;
            while (i < segs.length) {
                ita_mc = (IndexedTriangleArray)mcs[i].getGeometry();
                progress_max += ita_mc.getIndexCount() / 3;
                if (mc_closings[i] != null && (ita_closing = (IndexedTriangleArray)mc_closings[i].getGeometry()) != null) {
                    progress_max += ita_closing.getIndexCount() / 3;
                }
                ++i;
            }
            monitor.init_progress_measure("writing STL BIN file", 0, progress_max, 0);
        }
        try {
            FileOutputStream fos = new FileOutputStream(file_name);
            fos.write(new byte[80]);
            i = 0;
            while (i < segs.length) {
                ita_mc = (IndexedTriangleArray)mcs[i].getGeometry();
                ita_closing = (IndexedTriangleArray)mc_closings[i].getGeometry();
                int num_trias = 0;
                if (ita_mc != null) {
                    num_trias = ita_mc.getIndexCount();
                }
                if (ita_closing != null) {
                    num_trias += ita_closing.getIndexCount();
                }
                GeometryExport.write_stl_int(fos, num_trias / 3);
                GeometryExport.write_stl_bin_trias(ita_mc, trans, fos, monitor);
                GeometryExport.write_stl_bin_trias(ita_closing, trans, fos, monitor);
                ++i;
            }
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static final void write_indexed_tria_to_asc_stl_file(Segment[] segs, String file_name, Shape3D[] mcs, Shape3D[] mc_closings, Transform3D trans, boolean export_normals, RSThread monitor) {
        if (monitor != null) {
            int progress_max = 0;
            int i = 0;
            while (i < segs.length) {
                IndexedTriangleArray ita_mc = (IndexedTriangleArray)mcs[i].getGeometry();
                progress_max += ita_mc.getIndexCount() / 3;
                if (mc_closings[i] != null) {
                    IndexedTriangleArray ita_closing = (IndexedTriangleArray)mc_closings[i].getGeometry();
                    progress_max += ita_closing.getIndexCount() / 3;
                }
                ++i;
            }
            monitor.init_progress_measure("writing STL ASC file", 0, progress_max, 0);
        }
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(file_name));
            String ln = "\n";
            int i = 0;
            while (i < segs.length) {
                IndexedTriangleArray ita_mc = (IndexedTriangleArray)mcs[i].getGeometry();
                IndexedTriangleArray ita_closing = (IndexedTriangleArray)mc_closings[i].getGeometry();
                out.write("solid " + segs[i].get_name() + ln);
                GeometryExport.write_stl_asc_trias(ita_mc, trans, out, ln, monitor);
                GeometryExport.write_stl_asc_trias(ita_closing, trans, out, ln, monitor);
                out.write("endsolid " + segs[i].get_name() + ln);
                ++i;
            }
            out.close();
        }
        catch (IOException ex) {
            System.err.println("Unhandeld excepction in GeometryTools::export_mc_surface: " + ex);
        }
    }

    public static final void write_indexed_tria_to_janus_file(Segment[] segs, String file_name, Shape3D[] mcs, Shape3D[] mc_closings, Transform3D trans, boolean export_normals, RSThread monitor) {
        try {
            IndexedTriangleArray ita;
            BufferedWriter out = new BufferedWriter(new FileWriter(file_name));
            String ln = "\n";
            Point3f p3f = new Point3f();
            Vector3f v3f = new Vector3f();
            if (monitor != null) {
                int progress_max = 0;
                int i = 0;
                while (i < mcs.length) {
                    ita = (IndexedTriangleArray)mcs[i].getGeometry();
                    progress_max += ita.getVertexCount();
                    progress_max += ita.getIndexCount() / 3;
                    if (export_normals) {
                        progress_max += ita.getVertexCount();
                    }
                    ++i;
                }
                monitor.init_progress_measure("writing janus file", 0, progress_max, 0);
            }
            int i = 0;
            while (i < segs.length) {
                int j;
                Segment seg = segs[i];
                Color color = new Color(seg.get_color());
                double r = (double)color.getRed() / 255.0;
                double g = (double)color.getGreen() / 255.0;
                double b = (double)color.getBlue() / 255.0;
                out.write("<TYPE> TriaSurf" + ln);
                out.write("<IDENTIFIER> " + seg.get_name() + ln);
                out.write("<BEGIN>" + ln);
                out.write("Material: RGB: (" + r + ", " + g + ", " + b + ")" + ln);
                ita = (IndexedTriangleArray)mcs[i].getGeometry();
                out.write("Vertices: {" + ln);
                if (ita.getVertexCount() > 0) {
                    j = 0;
                    while (j < ita.getVertexCount() - 1) {
                        ita.getCoordinate(j, p3f);
                        if (trans != null) {
                            trans.transform(p3f);
                        }
                        out.write(p3f + " ; " + ln);
                        if (monitor != null) {
                            monitor.inc_progress_value(1);
                        }
                        ++j;
                    }
                    ita.getCoordinate(ita.getVertexCount() - 1, p3f);
                    if (trans != null) {
                        trans.transform(p3f);
                    }
                    out.write(p3f + ln);
                    if (monitor != null) {
                        monitor.inc_progress_value(1);
                    }
                }
                out.write("}" + ln);
                if (export_normals) {
                    out.write("Normals: {\n");
                    if (ita.getVertexCount() > 0) {
                        j = 0;
                        while (j < ita.getVertexCount() - 1) {
                            ita.getNormal(j, v3f);
                            out.write(v3f + "; " + ln);
                            if (monitor != null) {
                                monitor.inc_progress_value(1);
                            }
                            ++j;
                        }
                        ita.getNormal(ita.getVertexCount() - 1, v3f);
                        out.write(v3f + ln);
                        if (monitor != null) {
                            monitor.inc_progress_value(1);
                        }
                    }
                    out.write("}\n");
                } else {
                    out.write("Normals: auto" + ln);
                }
                out.write("Triangles: {\n");
                if (ita.getIndexCount() > 0) {
                    i = 0;
                    while (i < ita.getIndexCount() - 3) {
                        out.write("(" + ita.getCoordinateIndex(i + 0) + ", ");
                        out.write(ita.getCoordinateIndex(i + 1) + ", ");
                        out.write(ita.getCoordinateIndex(i + 2) + ") ;" + ln);
                        if (monitor != null) {
                            monitor.inc_progress_value(1);
                        }
                        i += 3;
                    }
                    out.write("(" + ita.getCoordinateIndex(i + 0) + ", ");
                    out.write(ita.getCoordinateIndex(i + 1) + ", ");
                    out.write(ita.getCoordinateIndex(i + 2) + ")" + ln);
                    if (monitor != null) {
                        monitor.inc_progress_value(1);
                    }
                }
                out.write("}" + ln);
                out.write("<END>" + ln);
                ++i;
            }
            out.close();
        }
        catch (IOException ex) {
            System.err.println("Unhandeld excepction in GeometryTools::export_mc_surface: " + ex);
        }
    }

    public static final void write_indexed_tria_to_ydm_file(Segment[] segs, String file_name, Shape3D[] mcs, Shape3D[] mc_closings, Transform3D trans, boolean export_normals, RSThread monitor) {
        try {
            DMSurface dms = ITALoader.loadIndexedTriangleArray((IndexedTriangleArray)mcs[0].getGeometry());
            if (mc_closings.length > 0 && (IndexedTriangleArray)mc_closings[0].getGeometry() != null) {
                IndexedTriangleArray ita = (IndexedTriangleArray)mc_closings[0].getGeometry();
                LinkedTriaSurface.LinkedVert[] idx_vert = new LinkedTriaSurface.LinkedVert[ita.getVertexCount()];
                int i = 0;
                while (i < idx_vert.length) {
                    Point3d coord = new Point3d();
                    ita.getCoordinate(i, coord);
                    idx_vert[i] = dms.add_vert(coord);
                    ++i;
                }
                int[] coord_idx = new int[ita.getIndexCount()];
                ita.getCoordinateIndices(0, coord_idx);
                int i2 = 0;
                while (i2 < coord_idx.length / 3) {
                    LinkedTriaSurface.LinkedVert a = idx_vert[coord_idx[i2 * 3]];
                    LinkedTriaSurface.LinkedVert b = idx_vert[coord_idx[i2 * 3 + 1]];
                    LinkedTriaSurface.LinkedVert c = idx_vert[coord_idx[i2 * 3 + 2]];
                    dms.add_face(a, b, c);
                    ++i2;
                }
            }
            DMSurfaceWriter dmsw = trans != null ? new DMSurfaceWriter(dms, new File(file_name), trans) : new DMSurfaceWriter(dms, new File(file_name));
            dmsw.write_data();
        }
        catch (IOException ex) {
            System.err.println("Unhandeld excepction in GeometryTools::export_mc_surface: " + ex);
        }
    }
}

