/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import javax.media.j3d.IndexedTriangleArray;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import misc.linkedsurface.LTSImportInfo;
import misc.linkedsurface.LinkedTriaSurface;
import misc.stl.STLFileReader;
import threads.RSThread;

public class GeometryImport {
    public static IndexedTriangleArray read_indexed_tria_from_janus_file(String filename) {
        try {
            BufferedReader in = new BufferedReader(new FileReader(filename));
            return GeometryImport.read_indexed_tria_from_janus_buffered_reader(in);
        }
        catch (IOException e) {
            System.err.println("Unhandeld IOExcepction in GeometryImport::read_indexed_tria_from_janus_file " + e);
            return null;
        }
    }

    public static IndexedTriangleArray read_indexed_tria_from_janus_input_stream(InputStream is) {
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        return GeometryImport.read_indexed_tria_from_janus_buffered_reader(in);
    }

    public static IndexedTriangleArray read_indexed_tria_from_janus_buffered_reader(BufferedReader in) {
        String sd;
        String s;
        ArrayList<Integer> trias;
        ArrayList<Point3f> norms;
        ArrayList<Point3f> verts;
        block21: {
            block20: {
                Point3f point;
                float[] pointVal;
                float d3;
                float d2;
                float d1;
                block19: {
                    block18: {
                        block17: {
                            block16: {
                                block15: {
                                    verts = new ArrayList<Point3f>();
                                    norms = new ArrayList<Point3f>();
                                    trias = new ArrayList<Integer>();
                                    s = in.readLine();
                                    if (s.equalsIgnoreCase("<TYPE> TriaSurf")) break block15;
                                    System.err.println("<TYPE> TriaSurf not found");
                                    return null;
                                }
                                s = in.readLine();
                                if (s.contains("<IDENTIFIER>")) break block16;
                                System.err.println("<BEGIN> not found");
                                return null;
                            }
                            s = in.readLine();
                            if (s.contains("<BEGIN>")) break block17;
                            System.err.println("<BEGIN> not found");
                            return null;
                        }
                        s = in.readLine();
                        if (s.contains("Material:")) break block18;
                        System.err.println("Material not found");
                        return null;
                    }
                    s = in.readLine();
                    if (s.contains("Vertices: {")) break block19;
                    System.err.println("Vertices not found");
                    return null;
                }
                s = in.readLine();
                while (!s.matches("}")) {
                    s = s.substring(1);
                    sd = s.substring(0, s.indexOf(","));
                    d1 = Float.parseFloat(sd);
                    s = s.substring(s.indexOf(",") + 1);
                    sd = s.substring(0, s.indexOf(","));
                    d2 = Float.parseFloat(sd);
                    s = s.substring(s.indexOf(",") + 1);
                    sd = s.substring(0, s.indexOf(")"));
                    d3 = Float.parseFloat(sd);
                    pointVal = new float[]{d1, d2, d3};
                    point = new Point3f(pointVal);
                    verts.add(point);
                    s = in.readLine();
                }
                s = in.readLine();
                if (s.equals("Normals: auto")) break block20;
                s = in.readLine();
                while (!s.matches("}")) {
                    s = s.substring(1);
                    sd = s.substring(0, s.indexOf(","));
                    d1 = Float.parseFloat(sd);
                    s = s.substring(s.indexOf(",") + 1);
                    sd = s.substring(0, s.indexOf(","));
                    d2 = Float.parseFloat(sd);
                    s = s.substring(s.indexOf(",") + 1);
                    sd = s.substring(0, s.indexOf(")"));
                    d3 = Float.parseFloat(sd);
                    pointVal = new float[]{d1, d2, d3};
                    point = new Vector3f(pointVal);
                    norms.add(point);
                    s = in.readLine();
                }
                if (verts.size() == norms.size()) break block20;
                System.err.println("Loading from Janusfile failed, _vertices.size() != _normals.size()");
                return null;
            }
            s = in.readLine();
            if (s.equals("Triangles: {")) break block21;
            System.err.println("Triangles not found");
            return null;
        }
        try {
            IndexedTriangleArray ita;
            s = in.readLine();
            while (!s.matches("}")) {
                s = s.substring(1);
                sd = s.substring(0, s.indexOf(","));
                trias.add(Integer.parseInt(sd));
                s = s.substring(s.indexOf(",") + 2);
                sd = s.substring(0, s.indexOf(","));
                trias.add(Integer.parseInt(sd));
                s = s.substring(s.indexOf(",") + 2);
                sd = s.substring(0, s.indexOf(")"));
                trias.add(Integer.parseInt(sd));
                s = in.readLine();
            }
            int[] tria_idx_array = new int[trias.size()];
            int c = 0;
            while (c < trias.size()) {
                tria_idx_array[c] = (Integer)trias.get(c);
                ++c;
            }
            if (norms.size() > 0) {
                ita = new IndexedTriangleArray(verts.size(), 3, trias.size());
                ita.setNormals(0, norms.toArray(new Vector3f[0]));
                ita.setCoordinates(0, verts.toArray(new Point3f[0]));
                ita.setCoordinateIndices(0, tria_idx_array);
                ita.setNormalIndices(0, tria_idx_array);
            } else {
                ita = new IndexedTriangleArray(verts.size(), 1, trias.size());
                ita.setCoordinates(0, verts.toArray(new Point3f[0]));
                ita.setCoordinateIndices(0, tria_idx_array);
            }
            return ita;
        }
        catch (IOException e) {
            System.err.println("Unhandeld IOExcepction in GeometryImport::read_indexed_tria_from_janus_file " + e);
            return null;
        }
    }

    public static void read_linked_tria_from_stl_file(String filename, Vector<LinkedTriaSurface> lts_vector, Vector<LTSImportInfo> import_info_vector, RSThread parent_thread) {
        lts_vector.clear();
        try {
            STLFileReader reader = new STLFileReader(new File(filename));
            int num_of_objects = reader.getNumOfObjects();
            int[] num_of_facets = reader.getNumOfFacets();
            String[] names = reader.getObjectNames();
            if (num_of_facets.length != num_of_objects || names.length != num_of_objects) {
                return;
            }
            int total_num_of_facets = 0;
            int i = 0;
            while (i < num_of_facets.length) {
                total_num_of_facets += num_of_facets[i];
                ++i;
            }
            if (parent_thread != null) {
                parent_thread.init_progress_measure("reading LTS ...", 0, total_num_of_facets, 0);
            }
            i = 0;
            while (i < num_of_objects) {
                lts_vector.add(new LinkedTriaSurface());
                if (import_info_vector != null) {
                    import_info_vector.add(new LTSImportInfo());
                }
                ++i;
            }
            LTSImportInfo import_info = null;
            int i2 = 0;
            while (i2 < num_of_objects) {
                if (import_info_vector != null) {
                    import_info = import_info_vector.get(i2);
                    import_info.number_of_original_faces = num_of_facets[i2];
                    import_info.number_of_triangles_defined_twice = 0;
                }
                LinkedTriaSurface lts = new LinkedTriaSurface();
                double[] normal = new double[3];
                double[][] vertice = new double[3][3];
                int j = 0;
                while (j < num_of_facets[i2]) {
                    boolean ok = reader.getNextFacet(normal, vertice);
                    if (ok) {
                        LinkedTriaSurface.LinkedVert[] lv = new LinkedTriaSurface.LinkedVert[3];
                        int k = 0;
                        while (k < 3) {
                            Point3d p = new Point3d(vertice[k][0], vertice[k][1], vertice[k][2]);
                            lv[k] = lts.add_vert(p);
                            ++k;
                        }
                        int old = lts._flist.size();
                        lts.add_face(lv[0], lv[1], lv[2]);
                        if (import_info != null && lts._flist.size() == old) {
                            ++import_info.number_of_triangles_defined_twice;
                        }
                    }
                    if (parent_thread != null) {
                        parent_thread.inc_progress_value(1);
                    }
                    ++j;
                }
                lts_vector.set(i2, lts);
                ++i2;
            }
        }
        catch (InterruptedIOException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static IndexedTriangleArray[] read_indexed_tria_from_stl_file(String filename, RSThread parent_thread) throws InterruptedIOException, FileNotFoundException, IOException {
        IndexedTriangleArray[] itas = null;
        STLFileReader reader = new STLFileReader(new File(filename));
        int num_of_objects = reader.getNumOfObjects();
        int[] num_of_facets = reader.getNumOfFacets();
        String[] names = reader.getObjectNames();
        if (num_of_facets.length != num_of_objects || names.length != num_of_objects) {
            return itas;
        }
        int total_num_of_facets = 0;
        int i = 0;
        while (i < num_of_facets.length) {
            total_num_of_facets += num_of_facets[i];
            ++i;
        }
        if (parent_thread != null) {
            parent_thread.init_progress_measure("reading ITA ...", 0, total_num_of_facets, 0);
        }
        itas = new IndexedTriangleArray[num_of_objects];
        i = 0;
        while (i < num_of_objects) {
            HashMap<Point3f, Integer> vert_map = new HashMap<Point3f, Integer>();
            ArrayList<Point3f> verts = new ArrayList<Point3f>();
            ArrayList<Integer> trias = new ArrayList<Integer>();
            double[] normal = new double[3];
            double[][] vertice = new double[3][3];
            int j = 0;
            while (j < num_of_facets[i]) {
                boolean ok = reader.getNextFacet(normal, vertice);
                if (ok) {
                    int k = 0;
                    while (k < 3) {
                        Point3f p = new Point3f((float)vertice[k][0], (float)vertice[k][1], (float)vertice[k][2]);
                        if (!vert_map.containsKey(p)) {
                            vert_map.put(p, new Integer(verts.size()));
                            verts.add(p);
                        }
                        trias.add((Integer)vert_map.get(p));
                        ++k;
                    }
                }
                if (parent_thread != null) {
                    parent_thread.inc_progress_value(1);
                }
                ++j;
            }
            int[] tria_idx_array = new int[trias.size()];
            int c = 0;
            while (c < trias.size()) {
                tria_idx_array[c] = (Integer)trias.get(c);
                ++c;
            }
            IndexedTriangleArray ita = new IndexedTriangleArray(verts.size(), 3, trias.size());
            ita.setCoordinates(0, verts.toArray(new Point3f[0]));
            ita.setCoordinateIndices(0, tria_idx_array);
            itas[i] = ita;
            ++i;
        }
        return itas;
    }
}

