/*
 * Decompiled with CFR 0.152.
 */
package misc;

import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class GeometryTools {
    private static final double det(Tuple3d a, Tuple3d b, Tuple3d n) {
        return a.x * b.y * n.z + a.y * b.z * n.x + a.z * b.x * n.y - a.z * b.y * n.x - a.x * b.z * n.y - a.y * b.x * n.z;
    }

    private static final Tuple3d sub(Tuple3d a, Tuple3d b) {
        Vector3d result = new Vector3d();
        result.sub(a, b);
        return result;
    }

    public static final double calc_tria_point_dist_square(Point3d a, Point3d b, Point3d c, Point3d p) {
        double dis_sqr;
        Vector3d vec_n = new Vector3d();
        Point3d lotfuss = new Point3d();
        Vector3d delta_ab = new Vector3d(GeometryTools.sub((Tuple3d)a, (Tuple3d)b));
        Vector3d detla_ac = new Vector3d(GeometryTools.sub((Tuple3d)a, (Tuple3d)c));
        Vector3d delta_pa = new Vector3d(GeometryTools.sub((Tuple3d)p, (Tuple3d)a));
        vec_n.cross(delta_ab, detla_ac);
        vec_n.normalize();
        double dot_product = vec_n.dot(delta_pa);
        Vector3d scaled_n = new Vector3d(vec_n);
        scaled_n.scale(dot_product);
        lotfuss.sub((Tuple3d)p, (Tuple3d)scaled_n);
        double ba1 = GeometryTools.det(GeometryTools.sub((Tuple3d)b, (Tuple3d)lotfuss), GeometryTools.sub((Tuple3d)c, (Tuple3d)lotfuss), (Tuple3d)vec_n);
        double ba2 = GeometryTools.det(GeometryTools.sub((Tuple3d)c, (Tuple3d)lotfuss), GeometryTools.sub((Tuple3d)a, (Tuple3d)lotfuss), (Tuple3d)vec_n);
        double ba3 = GeometryTools.det(GeometryTools.sub((Tuple3d)a, (Tuple3d)lotfuss), GeometryTools.sub((Tuple3d)b, (Tuple3d)lotfuss), (Tuple3d)vec_n);
        if (dot_product > 0.0) {
            vec_n.scale(-1.0);
        }
        if (ba1 >= 0.0 && ba2 >= 0.0 && ba3 >= 0.0) {
            dis_sqr = dot_product * dot_product;
        } else {
            dis_sqr = Double.MAX_VALUE;
            Vector3d delta_pc = new Vector3d(GeometryTools.sub((Tuple3d)p, (Tuple3d)c));
            Vector3d delta_ba = new Vector3d(GeometryTools.sub((Tuple3d)b, (Tuple3d)a));
            Vector3d delta_ca = new Vector3d(GeometryTools.sub((Tuple3d)c, (Tuple3d)a));
            Vector3d delta_bc = new Vector3d(GeometryTools.sub((Tuple3d)b, (Tuple3d)c));
            double l1 = delta_pa.dot(delta_ba) * (1.0 / delta_ba.dot(delta_ba));
            double l2 = delta_pa.dot(delta_ca) * (1.0 / delta_ca.dot(delta_ca));
            double l3 = delta_pc.dot(delta_bc) * (1.0 / delta_bc.dot(delta_bc));
            if (l1 <= 0.0 && l2 <= 0.0) {
                dis_sqr = ((Vector3d)GeometryTools.sub((Tuple3d)a, (Tuple3d)p)).lengthSquared();
            } else if (l1 >= 1.0 && l3 >= 1.0) {
                dis_sqr = ((Vector3d)GeometryTools.sub((Tuple3d)b, (Tuple3d)p)).lengthSquared();
            } else if (l2 >= 1.0 && l3 <= 0.0) {
                dis_sqr = ((Vector3d)GeometryTools.sub((Tuple3d)c, (Tuple3d)p)).lengthSquared();
            } else {
                Vector3d tmp;
                if (l1 > 0.0 && l1 < 1.0) {
                    lotfuss = new Point3d((Tuple3d)delta_ba);
                    lotfuss.scale(l1);
                    lotfuss.add((Tuple3d)a);
                    tmp = new Vector3d(GeometryTools.sub((Tuple3d)lotfuss, (Tuple3d)p));
                    dis_sqr = tmp.lengthSquared();
                }
                if (l2 > 0.0 && l2 < 1.0) {
                    lotfuss = new Point3d((Tuple3d)delta_ca);
                    lotfuss.scale(l2);
                    lotfuss.add((Tuple3d)a);
                    tmp = new Vector3d(GeometryTools.sub((Tuple3d)lotfuss, (Tuple3d)p));
                    dis_sqr = tmp.lengthSquared();
                }
                if (l3 > 0.0 && l3 < 1.0) {
                    lotfuss = new Point3d((Tuple3d)delta_bc);
                    lotfuss.scale(l3);
                    lotfuss.add((Tuple3d)c);
                    tmp = new Vector3d(GeometryTools.sub((Tuple3d)lotfuss, (Tuple3d)p));
                    dis_sqr = tmp.lengthSquared();
                }
            }
        }
        return dis_sqr;
    }

    public static final double calc_edge_point_dist_square(Point3d a, Point3d b, Point3d p) {
        Vector3d v = new Vector3d((Tuple3d)b);
        v.sub((Tuple3d)a);
        Vector3d w = new Vector3d((Tuple3d)p);
        w.sub((Tuple3d)a);
        double c1 = w.dot(v);
        if (c1 <= 0.0) {
            Vector3d ret = new Vector3d((Tuple3d)p);
            ret.sub((Tuple3d)a);
            return ret.lengthSquared();
        }
        double c2 = v.dot(v);
        if (c2 <= c1) {
            Vector3d ret = new Vector3d((Tuple3d)p);
            ret.sub((Tuple3d)b);
            return ret.lengthSquared();
        }
        double s = c1 / c2;
        Point3d pb = new Point3d((Tuple3d)v);
        pb.scale(s);
        pb.add((Tuple3d)a);
        Vector3d ret = new Vector3d((Tuple3d)p);
        ret.sub((Tuple3d)pb);
        return ret.lengthSquared();
    }

    public static void calc_bb(Point3d[] pts, Point3d bb_min, Point3d bb_max) {
        if (pts.length == 0) {
            return;
        }
        bb_min.set((Tuple3d)pts[0]);
        bb_max.set((Tuple3d)pts[0]);
        int i = 1;
        while (i < pts.length) {
            if (bb_min.x > pts[i].x) {
                bb_min.x = pts[i].x;
            }
            if (bb_min.y > pts[i].y) {
                bb_min.y = pts[i].y;
            }
            if (bb_min.z > pts[i].z) {
                bb_min.z = pts[i].z;
            }
            if (bb_max.x < pts[i].x) {
                bb_max.x = pts[i].x;
            }
            if (bb_max.y < pts[i].y) {
                bb_max.y = pts[i].y;
            }
            if (bb_max.z < pts[i].z) {
                bb_max.z = pts[i].z;
            }
            ++i;
        }
    }
}

