/*
 * Decompiled with CFR 0.152.
 */
package misc;

import javax.media.j3d.Transform3D;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import misc.GeometryTools;
import org.junit.Assert;
import org.junit.Test;

public class GeometryToolsTest {
    @Test
    public void testCalcTriaPointDist() {
        Point3d a = new Point3d(0.0, 0.0, 0.0);
        Point3d b = new Point3d(0.0, 1.0, 0.0);
        Point3d c = new Point3d(1.0, 1.0, 0.0);
        Point3d p1 = new Point3d(0.25, 0.25, 1.0);
        double d1 = 1.0;
        Point3d p2 = new Point3d(0.25, 0.25, -1.0);
        double d2 = 1.0;
        Point3d p3 = new Point3d(-1.0, -1.0, 0.0);
        double d3 = Math.sqrt(2.0);
        double delta = 0.01;
        Assert.assertEquals((double)d1, (double)Math.sqrt(GeometryTools.calc_tria_point_dist_square(a, b, c, p1)), (double)delta);
        Assert.assertEquals((double)d2, (double)Math.sqrt(GeometryTools.calc_tria_point_dist_square(a, b, c, p2)), (double)delta);
        Assert.assertEquals((double)d3, (double)Math.sqrt(GeometryTools.calc_tria_point_dist_square(a, b, c, p3)), (double)delta);
        Transform3D t3d_move = new Transform3D();
        t3d_move.setTranslation(new Vector3d(1.0, 5.0, 3.0));
        Transform3D t3d_rot = new Transform3D();
        t3d_rot.setRotation(new AxisAngle4d(3.0, 3.0, 3.0, 0.7853981633974483));
        Transform3D t3d = new Transform3D(t3d_rot);
        t3d_rot.mul(t3d_move);
        t3d.transform(a);
        t3d.transform(b);
        t3d.transform(c);
        t3d.transform(p1);
        t3d.transform(p2);
        t3d.transform(p3);
        Assert.assertEquals((double)d1, (double)Math.sqrt(GeometryTools.calc_tria_point_dist_square(a, b, c, p1)), (double)delta);
        Assert.assertEquals((double)d2, (double)Math.sqrt(GeometryTools.calc_tria_point_dist_square(a, b, c, p2)), (double)delta);
        Assert.assertEquals((double)d3, (double)Math.sqrt(GeometryTools.calc_tria_point_dist_square(a, b, c, p3)), (double)delta);
    }

    @Test
    public void testEdgePointDist() {
        Point3d a = new Point3d(0.0, 0.0, 0.0);
        Point3d b = new Point3d(1.0, 1.0, 0.0);
        Point3d p1 = new Point3d(0.0, 1.0, 0.0);
        double d1 = Math.sqrt(0.5);
        Point3d p2 = new Point3d(1.0, 0.0, 0.0);
        double d2 = Math.sqrt(0.5);
        Point3d p3 = new Point3d(-1.0, -1.0, 0.0);
        double d3 = Math.sqrt(2.0);
        double delta = 0.01;
        Assert.assertEquals((double)d1, (double)Math.sqrt(GeometryTools.calc_edge_point_dist_square(a, b, p1)), (double)delta);
        Assert.assertEquals((double)d2, (double)Math.sqrt(GeometryTools.calc_edge_point_dist_square(a, b, p2)), (double)delta);
        Assert.assertEquals((double)d3, (double)Math.sqrt(GeometryTools.calc_edge_point_dist_square(a, b, p3)), (double)delta);
        Transform3D t3d_move = new Transform3D();
        t3d_move.setTranslation(new Vector3d(1.0, 5.0, 3.0));
        Transform3D t3d_rot = new Transform3D();
        t3d_rot.setRotation(new AxisAngle4d(3.0, 3.0, 3.0, 0.7853981633974483));
        Transform3D t3d = new Transform3D(t3d_rot);
        t3d_rot.mul(t3d_move);
        t3d.transform(a);
        t3d.transform(b);
        t3d.transform(p1);
        t3d.transform(p2);
        t3d.transform(p3);
        Assert.assertEquals((double)d1, (double)Math.sqrt(GeometryTools.calc_edge_point_dist_square(a, b, p1)), (double)delta);
        Assert.assertEquals((double)d2, (double)Math.sqrt(GeometryTools.calc_edge_point_dist_square(a, b, p2)), (double)delta);
        Assert.assertEquals((double)d3, (double)Math.sqrt(GeometryTools.calc_edge_point_dist_square(a, b, p3)), (double)delta);
    }
}

