/*
 * Decompiled with CFR 0.152.
 */
package misc;

import javax.media.j3d.IndexedTriangleArray;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import misc.GeometryImport;
import misc.linkedsurface.LinkedTriaSurface;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LinkedTriaSurfaceTest {
    LinkedTriaSurface _lts_sphere;
    LinkedTriaSurface _lts_torus;
    int _sphere_tria_num;
    int _torus_tria_num;
    int _sphere_vert_num;
    int _torus_vert_num;

    private void init_lts_from_ita(LinkedTriaSurface lts, IndexedTriangleArray ita) {
        Point3f p0 = new Point3f();
        Point3f p1 = new Point3f();
        Point3f p2 = new Point3f();
        int i = 0;
        while (i < ita.getIndexCount() / 3) {
            ita.getCoordinate(ita.getCoordinateIndex(i * 3 + 0), p0);
            ita.getCoordinate(ita.getCoordinateIndex(i * 3 + 1), p1);
            ita.getCoordinate(ita.getCoordinateIndex(i * 3 + 2), p2);
            LinkedTriaSurface.LinkedVert v0 = lts.add_vert(new Point3d(p0));
            LinkedTriaSurface.LinkedVert v1 = lts.add_vert(new Point3d(p1));
            LinkedTriaSurface.LinkedVert v2 = lts.add_vert(new Point3d(p2));
            lts.add_face(v0, v1, v2);
            ++i;
        }
    }

    @Before
    public void init() {
        this._lts_sphere = new LinkedTriaSurface();
        this._lts_torus = new LinkedTriaSurface();
        IndexedTriangleArray ita = null;
        ita = GeometryImport.read_indexed_tria_from_janus_file("test_resources/sphere.dat");
        this._sphere_tria_num = ita.getIndexCount() / 3;
        this._sphere_vert_num = ita.getVertexCount();
        this.init_lts_from_ita(this._lts_sphere, ita);
        ita = GeometryImport.read_indexed_tria_from_janus_file("test_resources/torus.dat");
        this._torus_tria_num = ita.getIndexCount() / 3;
        this._torus_vert_num = ita.getVertexCount();
        this.init_lts_from_ita(this._lts_torus, ita);
    }

    @Test
    public void test_basic_methods() {
        LinkedTriaSurface lts = new LinkedTriaSurface();
        LinkedTriaSurface.LinkedVert v0 = lts.add_vert(new Point3d(0.0, 0.0, 0.0));
        LinkedTriaSurface.LinkedVert v1 = lts.add_vert(new Point3d(1.0, 0.0, 0.0));
        LinkedTriaSurface.LinkedVert v2 = lts.add_vert(new Point3d(0.0, 1.0, 0.0));
        LinkedTriaSurface.LinkedTria tria = lts.add_face(v0, v1, v2);
        Assert.assertEquals((String)"tria normal", (Object)new Vector3d(0.0, 0.0, 1.0), (Object)tria.calc_normal());
        Assert.assertEquals((String)"tria area", (double)0.5, (double)tria.calc_area(), (double)0.0);
        Assert.assertEquals((String)"length ab", (double)1.0, (double)tria._ab.length(), (double)0.0);
        Assert.assertEquals((String)"length bc", (double)Math.sqrt(2.0), (double)tria._bc.length(), (double)0.0);
        Assert.assertEquals((String)"length ac", (double)1.0, (double)tria._ca.length(), (double)0.0);
    }

    @Test
    public void test_basic_correctness() {
        Assert.assertEquals((String)"sphere tria num", (long)this._sphere_tria_num, (long)this._lts_sphere._flist.size());
        Assert.assertEquals((String)"sphere vert num", (long)this._sphere_vert_num, (long)this._lts_sphere._vlist.size());
        Assert.assertEquals((String)"sphere epc", (long)2L, (long)this._lts_sphere.calculate_epc());
        Assert.assertTrue((String)"sphere closed", (boolean)this._lts_sphere.is_closed());
        Assert.assertEquals((String)"torus tria num", (long)this._torus_tria_num, (long)this._lts_torus._flist.size());
        Assert.assertEquals((String)"torus vert num", (long)this._torus_vert_num, (long)this._lts_torus._vlist.size());
        Assert.assertEquals((String)"torus epc", (long)0L, (long)this._lts_torus.calculate_epc());
        Assert.assertTrue((String)"torus closed", (boolean)this._lts_torus.is_closed());
    }
}

