/*
 * Decompiled with CFR 0.152.
 */
package misc;

import javax.vecmath.Point3f;
import misc.MarchingTriangle;

public final class MarchingTable {
    public static int[][] _lookup_old;
    public static int[][] _lookup_new;
    private static int[][] _lookup;
    public static Point3f[] _v;
    private static int[] _hnext;
    private static int[] _vnext;

    static {
        _hnext = new int[20];
        _vnext = new int[20];
        _v = new Point3f[20];
        MarchingTable._v[0] = new Point3f(0.5f, 0.0f, 0.0f);
        MarchingTable._v[1] = new Point3f(1.0f, 0.0f, 0.5f);
        MarchingTable._v[2] = new Point3f(0.5f, 0.0f, 1.0f);
        MarchingTable._v[3] = new Point3f(0.0f, 0.0f, 0.5f);
        MarchingTable._v[4] = new Point3f(0.0f, 0.5f, 0.0f);
        MarchingTable._v[5] = new Point3f(1.0f, 0.5f, 0.0f);
        MarchingTable._v[6] = new Point3f(1.0f, 0.5f, 1.0f);
        MarchingTable._v[7] = new Point3f(0.0f, 0.5f, 1.0f);
        MarchingTable._v[8] = new Point3f(0.5f, 1.0f, 0.0f);
        MarchingTable._v[9] = new Point3f(1.0f, 1.0f, 0.5f);
        MarchingTable._v[10] = new Point3f(0.5f, 1.0f, 1.0f);
        MarchingTable._v[11] = new Point3f(0.0f, 1.0f, 0.5f);
        MarchingTable._v[12] = new Point3f(0.0f, 0.0f, 0.0f);
        MarchingTable._v[13] = new Point3f(1.0f, 0.0f, 0.0f);
        MarchingTable._v[14] = new Point3f(1.0f, 0.0f, 1.0f);
        MarchingTable._v[15] = new Point3f(0.0f, 0.0f, 1.0f);
        MarchingTable._v[16] = new Point3f(0.0f, 1.0f, 0.0f);
        MarchingTable._v[17] = new Point3f(1.0f, 1.0f, 0.0f);
        MarchingTable._v[18] = new Point3f(1.0f, 1.0f, 1.0f);
        MarchingTable._v[19] = new Point3f(0.0f, 1.0f, 1.0f);
        MarchingTable._hnext[0] = 1;
        MarchingTable._hnext[1] = 2;
        MarchingTable._hnext[2] = 3;
        MarchingTable._hnext[3] = 0;
        MarchingTable._hnext[4] = 5;
        MarchingTable._hnext[5] = 6;
        MarchingTable._hnext[6] = 7;
        MarchingTable._hnext[7] = 4;
        MarchingTable._hnext[8] = 9;
        MarchingTable._hnext[9] = 10;
        MarchingTable._hnext[10] = 11;
        MarchingTable._hnext[11] = 8;
        MarchingTable._hnext[12] = 13;
        MarchingTable._hnext[13] = 14;
        MarchingTable._hnext[14] = 15;
        MarchingTable._hnext[15] = 12;
        MarchingTable._hnext[16] = 17;
        MarchingTable._hnext[17] = 18;
        MarchingTable._hnext[18] = 19;
        MarchingTable._hnext[19] = 16;
        MarchingTable._vnext[0] = 8;
        MarchingTable._vnext[1] = 5;
        MarchingTable._vnext[2] = 0;
        MarchingTable._vnext[3] = 4;
        MarchingTable._vnext[4] = 11;
        MarchingTable._vnext[5] = 9;
        MarchingTable._vnext[6] = 1;
        MarchingTable._vnext[7] = 3;
        MarchingTable._vnext[8] = 10;
        MarchingTable._vnext[9] = 6;
        MarchingTable._vnext[10] = 2;
        MarchingTable._vnext[11] = 7;
        MarchingTable._vnext[12] = 16;
        MarchingTable._vnext[13] = 17;
        MarchingTable._vnext[14] = 13;
        MarchingTable._vnext[15] = 12;
        MarchingTable._vnext[16] = 19;
        MarchingTable._vnext[17] = 18;
        MarchingTable._vnext[18] = 14;
        MarchingTable._vnext[19] = 15;
        MarchingTable.build();
    }

    private static final int get_lookup_pos(String v_str) {
        int pos = 0;
        int i = 7;
        while (i >= 0) {
            if (v_str.charAt(i) == '1') {
                pos |= 1 << i;
            }
            --i;
        }
        return pos &= 0xFF;
    }

    private static final void set_lookup(int pos, MarchingTriangle[] trias) {
        MarchingTable._lookup[pos] = new int[trias.length * 3];
        int k = 0;
        while (k < trias.length) {
            MarchingTable._lookup[pos][k * 3 + 0] = trias[k]._vi[0];
            MarchingTable._lookup[pos][k * 3 + 1] = trias[k]._vi[1];
            MarchingTable._lookup[pos][k * 3 + 2] = trias[k]._vi[2];
            ++k;
        }
    }

    private static final int[] str_to_points(String v_str) {
        int sum = 0;
        int pos = 0;
        int i = 7;
        while (i >= 0) {
            if (v_str.charAt(i) == '1') {
                ++sum;
            }
            --i;
        }
        int[] points = new int[sum];
        i = 7;
        while (i >= 0) {
            if (v_str.charAt(i) == '1') {
                points[pos] = 19 - i;
                ++pos;
            }
            --i;
        }
        return points;
    }

    private static final String points_to_str(int[] points) {
        String v_str = new String();
        int j = 7;
        while (j >= 0) {
            int i = 0;
            while (i < points.length) {
                if (points[i] == 19 - j) break;
                ++i;
            }
            v_str = i == points.length ? String.valueOf(v_str) + "0" : String.valueOf(v_str) + "1";
            --j;
        }
        return v_str;
    }

    private static final void h_rot(int[] points, MarchingTriangle[] trias) {
        int i = 0;
        while (i < points.length) {
            points[i] = _hnext[points[i]];
            ++i;
        }
        i = 0;
        while (i < trias.length) {
            trias[i]._vi[0] = _hnext[trias[i]._vi[0]];
            trias[i]._vi[1] = _hnext[trias[i]._vi[1]];
            trias[i]._vi[2] = _hnext[trias[i]._vi[2]];
            ++i;
        }
    }

    public static final void v_rot(int[] points, MarchingTriangle[] trias) {
        int i = 0;
        while (i < points.length) {
            points[i] = _vnext[points[i]];
            ++i;
        }
        i = 0;
        while (i < trias.length) {
            trias[i]._vi[0] = _vnext[trias[i]._vi[0]];
            trias[i]._vi[1] = _vnext[trias[i]._vi[1]];
            trias[i]._vi[2] = _vnext[trias[i]._vi[2]];
            ++i;
        }
    }

    public static final void roll_dice(StringBuffer v_str_orig, MarchingTriangle[] trias_orig) {
        int pos;
        int verti;
        MarchingTriangle[] trias = new MarchingTriangle[trias_orig.length];
        int k = 0;
        while (k < trias.length) {
            trias[k] = new MarchingTriangle(trias_orig[k]._vi[0], trias_orig[k]._vi[2], trias_orig[k]._vi[1]);
            ++k;
        }
        String v_str = new String(v_str_orig);
        int[] v_points = MarchingTable.str_to_points(v_str);
        int hori = 0;
        while (hori < 4) {
            verti = 0;
            while (verti < 4) {
                v_str = MarchingTable.points_to_str(v_points);
                pos = MarchingTable.get_lookup_pos(v_str);
                if (_lookup[pos].length == 0) {
                    MarchingTable.set_lookup(pos, trias);
                }
                MarchingTable.v_rot(v_points, trias);
                ++verti;
            }
            MarchingTable.h_rot(v_points, trias);
            ++hori;
        }
        MarchingTable.h_rot(v_points, trias);
        MarchingTable.v_rot(v_points, trias);
        hori = 0;
        while (hori < 4) {
            verti = 0;
            while (verti < 4) {
                v_str = MarchingTable.points_to_str(v_points);
                pos = MarchingTable.get_lookup_pos(v_str);
                if (_lookup[pos].length == 0) {
                    MarchingTable.set_lookup(pos, trias);
                }
                MarchingTable.v_rot(v_points, trias);
                ++verti;
            }
            MarchingTable.h_rot(v_points, trias);
            ++hori;
        }
    }

    private static final MarchingTriangle[] invert_trias(MarchingTriangle[] trias) {
        MarchingTriangle[] inv_trias = new MarchingTriangle[trias.length];
        int k = 0;
        while (k < trias.length) {
            int a = trias[k]._vi[0];
            int b = trias[k]._vi[1];
            int c = trias[k]._vi[2];
            inv_trias[k] = new MarchingTriangle(b, a, c);
            ++k;
        }
        return inv_trias;
    }

    public static final StringBuffer get_case_str(int mc_case) {
        switch (mc_case) {
            case 1: {
                return new StringBuffer("00000001");
            }
            case 2: {
                return new StringBuffer("00000011");
            }
            case 3: {
                return new StringBuffer("00100001");
            }
            case 4: {
                return new StringBuffer("01000001");
            }
            case 5: {
                return new StringBuffer("00001110");
            }
            case 6: {
                return new StringBuffer("01000011");
            }
            case 7: {
                return new StringBuffer("01010010");
            }
            case 8: {
                return new StringBuffer("00001111");
            }
            case 9: {
                return new StringBuffer("10001101");
            }
            case 10: {
                return new StringBuffer("01010101");
            }
            case 11: {
                return new StringBuffer("01001101");
            }
            case 12: {
                return new StringBuffer("00011110");
            }
            case 13: {
                return new StringBuffer("10100101");
            }
            case 14: {
                return new StringBuffer("10001110");
            }
        }
        return null;
    }

    public static final StringBuffer get_inv_case_str(int mc_case) {
        StringBuffer str = MarchingTable.get_case_str(mc_case);
        StringBuffer inv_str = new StringBuffer(str);
        int i = 0;
        while (i < str.length()) {
            if (str.charAt(i) == '0') {
                inv_str.setCharAt(i, '1');
            } else {
                inv_str.setCharAt(i, '0');
            }
            ++i;
        }
        return inv_str;
    }

    private static final MarchingTriangle[] get_case_trias(int mc_case) {
        MarchingTriangle[] trias = null;
        switch (mc_case) {
            case 1: {
                trias = new MarchingTriangle[]{new MarchingTriangle(0, 3, 4)};
                break;
            }
            case 2: {
                trias = new MarchingTriangle[]{new MarchingTriangle(5, 3, 4), new MarchingTriangle(3, 5, 1)};
                break;
            }
            case 3: {
                trias = new MarchingTriangle[]{new MarchingTriangle(0, 3, 4), new MarchingTriangle(8, 9, 5)};
                break;
            }
            case 4: {
                trias = new MarchingTriangle[]{new MarchingTriangle(0, 3, 4), new MarchingTriangle(6, 9, 10)};
                break;
            }
            case 5: {
                trias = new MarchingTriangle[]{new MarchingTriangle(0, 5, 3), new MarchingTriangle(7, 3, 5), new MarchingTriangle(5, 6, 7)};
                break;
            }
            case 6: {
                trias = new MarchingTriangle[]{new MarchingTriangle(3, 4, 5), new MarchingTriangle(5, 1, 3), new MarchingTriangle(6, 9, 10)};
                break;
            }
            case 7: {
                trias = new MarchingTriangle[]{new MarchingTriangle(0, 5, 1), new MarchingTriangle(4, 11, 8), new MarchingTriangle(9, 10, 6)};
                break;
            }
            case 8: {
                trias = new MarchingTriangle[]{new MarchingTriangle(4, 5, 6), new MarchingTriangle(6, 7, 4)};
                break;
            }
            case 9: {
                trias = new MarchingTriangle[]{new MarchingTriangle(10, 11, 4), new MarchingTriangle(4, 0, 10), new MarchingTriangle(6, 10, 0), new MarchingTriangle(0, 1, 6)};
                break;
            }
            case 10: {
                trias = new MarchingTriangle[]{new MarchingTriangle(0, 3, 8), new MarchingTriangle(11, 8, 3), new MarchingTriangle(1, 9, 2), new MarchingTriangle(10, 2, 9)};
                break;
            }
            case 11: {
                trias = new MarchingTriangle[]{new MarchingTriangle(0, 7, 4), new MarchingTriangle(7, 0, 9), new MarchingTriangle(1, 9, 0), new MarchingTriangle(9, 10, 7)};
                break;
            }
            case 12: {
                trias = new MarchingTriangle[]{new MarchingTriangle(8, 4, 11), new MarchingTriangle(0, 5, 3), new MarchingTriangle(7, 3, 5), new MarchingTriangle(5, 6, 7)};
                break;
            }
            case 13: {
                trias = new MarchingTriangle[]{new MarchingTriangle(0, 3, 4), new MarchingTriangle(5, 8, 9), new MarchingTriangle(7, 10, 11), new MarchingTriangle(2, 1, 6)};
                break;
            }
            case 14: {
                trias = new MarchingTriangle[]{new MarchingTriangle(3, 0, 11), new MarchingTriangle(6, 11, 0), new MarchingTriangle(0, 5, 6), new MarchingTriangle(11, 6, 10)};
            }
        }
        return trias;
    }

    public static final void build() {
        _lookup = new int[256][0];
        int i = 1;
        while (i < 15) {
            MarchingTable.roll_dice(MarchingTable.get_case_str(i), MarchingTable.get_case_trias(i));
            ++i;
        }
        i = 1;
        while (i < 15) {
            MarchingTable.roll_dice(MarchingTable.get_inv_case_str(i), MarchingTable.invert_trias(MarchingTable.get_case_trias(i)));
            ++i;
        }
        _lookup_old = _lookup;
        _lookup = new int[256][0];
        i = 1;
        while (i < 15) {
            MarchingTable.roll_dice(MarchingTable.get_case_str(i), MarchingTable.get_case_trias(i));
            ++i;
        }
        i = 1;
        while (i < 15) {
            switch (i) {
                case 3: {
                    MarchingTriangle[] trias = new MarchingTriangle[]{new MarchingTriangle(8, 4, 3), new MarchingTriangle(3, 9, 8), new MarchingTriangle(9, 3, 5), new MarchingTriangle(0, 5, 3)};
                    MarchingTable.roll_dice(MarchingTable.get_inv_case_str(i), trias);
                    break;
                }
                case 6: {
                    MarchingTriangle[] trias = new MarchingTriangle[]{new MarchingTriangle(3, 5, 4), new MarchingTriangle(5, 3, 9), new MarchingTriangle(10, 9, 3), new MarchingTriangle(3, 6, 10), new MarchingTriangle(6, 3, 1)};
                    MarchingTable.roll_dice(MarchingTable.get_inv_case_str(i), trias);
                    break;
                }
                case 7: {
                    MarchingTriangle[] trias = new MarchingTriangle[]{new MarchingTriangle(4, 0, 11), new MarchingTriangle(10, 11, 0), new MarchingTriangle(0, 6, 10), new MarchingTriangle(6, 0, 1), new MarchingTriangle(9, 5, 8)};
                    MarchingTable.roll_dice(MarchingTable.get_inv_case_str(i), trias);
                    break;
                }
                default: {
                    MarchingTable.roll_dice(MarchingTable.get_inv_case_str(i), MarchingTable.invert_trias(MarchingTable.get_case_trias(i)));
                }
            }
            ++i;
        }
        _lookup_new = _lookup;
    }

    private MarchingTable() {
    }
}

