/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.awt.Color;
import javax.vecmath.Color4f;
import misc.helper.Helper;

public final class MutableColor {
    private int value;

    public MutableColor() {
        this.value = 0;
    }

    public MutableColor(int rgb) {
        this.setRGB(rgb);
    }

    public MutableColor(int r, int g, int b, int a) {
        this.set(r, g, b, a);
    }

    public MutableColor(Color color) {
        this.set(color);
    }

    public MutableColor(Color4f color4f) {
        this.set(color4f);
    }

    public void setRGB(int rgb) {
        this.value = rgb;
    }

    public void set(int r, int g, int b, int a) {
        this.setRGB((a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0);
    }

    public void set(Color color) {
        this.setRGB(color.getRGB());
    }

    public void set(Color4f color4f) {
        int r = Helper.round(color4f.getX() * 255.0f);
        int g = Helper.round(color4f.getY() * 255.0f);
        int b = Helper.round(color4f.getZ() * 255.0f);
        int a = Helper.round(color4f.getW() * 255.0f);
        this.set(r, g, b, a);
    }

    public int getRGB() {
        return this.value;
    }

    public int getRed() {
        return this.getRGB() >> 16 & 0xFF;
    }

    public int getGreen() {
        return this.getRGB() >> 8 & 0xFF;
    }

    public int getBlue() {
        return this.getRGB() >> 0 & 0xFF;
    }

    public int getAlpha() {
        return this.getRGB() >> 24 & 0xFF;
    }

    public Color getAsColor() {
        return new Color(this.value, true);
    }

    public Color4f getAsColor4f() {
        Color4f return_color4f = new Color4f();
        this.get(return_color4f);
        return return_color4f;
    }

    public void get(Color4f return_color) {
        float red = (float)this.getRed() / 255.0f;
        return_color.setX(red);
        float green = (float)this.getGreen() / 255.0f;
        return_color.setY(green);
        float blue = (float)this.getBlue() / 255.0f;
        return_color.setZ(blue);
        float alpha = (float)this.getAlpha() / 255.0f;
        return_color.setW(alpha);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[r=" + this.getRed() + ",g=" + this.getGreen() + ",b=" + this.getBlue() + ",a=" + this.getAlpha() + "]";
    }
}

