/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.awt.Color;
import javax.vecmath.Color4f;
import misc.MutableColor;
import org.junit.Assert;
import org.junit.Test;

public class MutableColorTest {
    private final Color _color = new Color(1, 2, 3, 4);
    private final Color4f _color4f = new Color4f(this._color);
    private final MutableColor _mutable_color = new MutableColor(this._color);

    @Test
    public void testDefaultConstructor() {
        MutableColor mc = new MutableColor();
        Assert.assertEquals((long)0L, (long)mc.getRed());
        Assert.assertEquals((long)0L, (long)mc.getGreen());
        Assert.assertEquals((long)0L, (long)mc.getBlue());
        Assert.assertEquals((long)0L, (long)mc.getAlpha());
    }

    @Test
    public void testRGBAIntConstructor() {
        MutableColor mc = new MutableColor(this._color.getRGB());
        this.assertMutableColorEquals_color(mc);
    }

    private void assertMutableColorEquals_color(MutableColor mc) {
        Assert.assertEquals((long)this._color.getRed(), (long)mc.getRed());
        Assert.assertEquals((long)this._color.getGreen(), (long)mc.getGreen());
        Assert.assertEquals((long)this._color.getBlue(), (long)mc.getBlue());
        Assert.assertEquals((long)this._color.getAlpha(), (long)mc.getAlpha());
    }

    @Test
    public void testRGBAConstructor() {
        MutableColor mc = new MutableColor(this._color.getRed(), this._color.getGreen(), this._color.getBlue(), this._color.getAlpha());
        this.assertMutableColorEquals_color(mc);
    }

    @Test
    public void testColorConstructor() {
        MutableColor mc = new MutableColor(this._color);
        this.assertMutableColorEquals_color(mc);
    }

    @Test
    public void testColor4fConstructor() {
        MutableColor mc = new MutableColor(this._color4f);
        this.assertMutableColorEquals_color(mc);
    }

    @Test
    public void testGetAsColor() {
        Assert.assertEquals((Object)this._color, (Object)this._mutable_color.getAsColor());
    }

    @Test
    public void testGetAsColor4f() {
        Assert.assertEquals((Object)this._color4f, (Object)this._mutable_color.getAsColor4f());
    }

    @Test
    public void testGetWithColor4fArgument() {
        Color4f color4f = new Color4f();
        this._mutable_color.get(color4f);
        Assert.assertEquals((Object)this._color4f, (Object)color4f);
    }

    @Test
    public void testGetRed() {
        Assert.assertEquals((long)this._color.getRed(), (long)this._mutable_color.getRed());
    }

    @Test
    public void testGetGreen() {
        Assert.assertEquals((long)this._color.getGreen(), (long)this._mutable_color.getGreen());
    }

    @Test
    public void testGetBlue() {
        Assert.assertEquals((long)this._color.getBlue(), (long)this._mutable_color.getBlue());
    }

    @Test
    public void testGetAlpha() {
        Assert.assertEquals((long)this._color.getAlpha(), (long)this._mutable_color.getAlpha());
    }

    @Test
    public void testGetRGBA() {
        Assert.assertEquals((long)this._color.getRGB(), (long)this._mutable_color.getRGB());
    }

    @Test
    public void testSetRGBA() {
        MutableColor mc = new MutableColor();
        mc.set(this._color.getRed(), this._color.getGreen(), this._color.getBlue(), this._color.getAlpha());
        this.assertMutableColorEquals_color(mc);
    }

    @Test
    public void testSetRGBAInt() {
        MutableColor mc = new MutableColor();
        mc.setRGB(this._color.getRGB());
        this.assertMutableColorEquals_color(mc);
    }

    @Test
    public void testSetColor() {
        MutableColor mc = new MutableColor();
        mc.set(this._color);
        this.assertMutableColorEquals_color(mc);
    }

    @Test
    public void testSetColor4f() {
        MutableColor mc = new MutableColor();
        mc.set(this._color4f);
        this.assertMutableColorEquals_color(mc);
    }
}

