/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.util.LinkedList;
import java.util.ListIterator;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;

public final class OctTree {
    private OctNode _root;
    final OctNode _outside = new OctNode();
    private final LinkedList<OctPoint> _points;
    private final int NODE_MAX;

    public OctTree() {
        this._root = new OctNode();
        this._points = new LinkedList();
        this.NODE_MAX = 100;
    }

    public void set_bbmin(Point3f v) {
        this._root._bbmin = v;
        this._root.calc_center();
    }

    public void set_bbmax(Point3f v) {
        this._root._bbmax = v;
        this._root.calc_center();
    }

    public void add(Point3f v) {
        this.add(v, null);
    }

    public void add(Point3f v, Object data) {
        OctPoint p = new OctPoint(v, data);
        this._points.add(p);
        this.add(p);
    }

    public void add(OctPoint p) {
        OctNode node = this.find_node(p._v, this._root);
        node.add(p);
        if (node._points.size() == this.NODE_MAX) {
            if (node == this._outside) {
                this.recalculate();
            } else {
                this.split_node(node);
            }
        }
    }

    public OctPoint find(Point3f v) {
        OctNode node = this.find_node(v, this._root);
        return node.find(v);
    }

    private void recalculate() {
        Point3f bbmin = this._root._bbmin;
        Point3f bbmax = this._root._bbmax;
        this._outside.calc_bb();
        if (this._outside._bbmin.x < bbmin.x) {
            bbmin.x = this._outside._bbmin.x;
        }
        if (this._outside._bbmin.y < bbmin.y) {
            bbmin.y = this._outside._bbmin.y;
        }
        if (this._outside._bbmin.z < bbmin.z) {
            bbmin.z = this._outside._bbmin.z;
        }
        if (this._outside._bbmax.x > bbmax.x) {
            bbmax.x = this._outside._bbmax.x;
        }
        if (this._outside._bbmax.y > bbmax.y) {
            bbmax.y = this._outside._bbmax.y;
        }
        if (this._outside._bbmax.z > bbmax.z) {
            bbmax.z = this._outside._bbmax.z;
        }
        this._root = new OctNode();
        this._root._bbmin = bbmin;
        this._root._bbmax = bbmax;
        this._root.calc_center();
        ListIterator li = this._points.listIterator();
        do {
            OctPoint p = (OctPoint)li.next();
            this.add(p);
        } while (li.hasNext());
        this._outside._points.clear();
    }

    private void split_node(OctNode node) {
        node._next = new OctNode[8];
        int i = 0;
        while (i < 8) {
            node._next[i] = new OctNode(node);
            if (i < 4) {
                node._next[i]._bbmin.x = node._bbmin.x;
                node._next[i]._bbmax.x = node._bbcenter.x;
            } else {
                node._next[i]._bbmin.x = node._bbcenter.x;
                node._next[i]._bbmax.x = node._bbmax.x;
            }
            if (i == 0 || i == 1 || i == 4 || i == 5) {
                node._next[i]._bbmin.y = node._bbmin.y;
                node._next[i]._bbmax.y = node._bbcenter.y;
            } else {
                node._next[i]._bbmin.y = node._bbcenter.y;
                node._next[i]._bbmax.y = node._bbmax.y;
            }
            if (i % 2 == 0) {
                node._next[i]._bbmin.z = node._bbmin.z;
                node._next[i]._bbmax.z = node._bbcenter.z;
            } else {
                node._next[i]._bbmin.z = node._bbcenter.z;
                node._next[i]._bbmax.z = node._bbmax.z;
            }
            node._next[i].calc_center();
            ++i;
        }
        node._leaf = false;
        ListIterator li = node._points.listIterator();
        do {
            OctPoint p = (OctPoint)li.next();
            OctNode new_node = this.find_node(p._v, node);
            new_node.add(p);
        } while (li.hasNext());
        node._points.clear();
    }

    private OctNode find_node(Point3f v, OctNode start) {
        OctNode node;
        if (v.x < this._root._bbmin.x || v.y < this._root._bbmin.y || v.z < this._root._bbmin.z || v.x > this._root._bbmax.x || v.y > this._root._bbmax.y || v.z > this._root._bbmax.z) {
            node = this._outside;
        } else {
            node = start;
            while (!node._leaf) {
                int node_index = 0;
                if (v.x >= node._bbcenter.x) {
                    node_index = 4;
                }
                if (v.y >= node._bbcenter.y) {
                    node_index += 2;
                }
                if (v.z >= node._bbcenter.z) {
                    ++node_index;
                }
                node = node._next[node_index];
            }
        }
        return node;
    }

    public int size() {
        return this._points.size();
    }

    public boolean containsVector(Point3f v) {
        OctNode node = this.find_node(v, this._root);
        return node.find(v) != null;
    }

    public class OctNode {
        public OctNode[] _next;
        public OctNode _parent;
        public LinkedList<OctPoint> _points;
        public Point3f _bbmin;
        public Point3f _bbmax;
        public Point3f _bbcenter;
        public boolean _leaf;

        public OctNode() {
            this(null);
        }

        public OctNode(OctNode parent) {
            this._parent = parent;
            this._points = new LinkedList();
            this._bbmin = new Point3f(-1.0f, -1.0f, -1.0f);
            this._bbmax = new Point3f(1.0f, 1.0f, 1.0f);
            this._bbcenter = new Point3f(0.0f, 0.0f, 0.0f);
            this._leaf = true;
            this._next = null;
        }

        public void add(OctPoint p) {
            this._points.add(p);
        }

        public OctPoint find(Point3f v) {
            if (this._points.size() > 0) {
                ListIterator li = this._points.listIterator();
                do {
                    OctPoint p = (OctPoint)li.next();
                    if (p._v != v) continue;
                    return p;
                } while (li.hasNext());
            }
            return null;
        }

        public void calc_bb() {
            if (this._points.size() > 0) {
                ListIterator li = this._points.listIterator();
                Point3f v = ((OctPoint)li.next())._v;
                this._bbmin = new Point3f(v);
                this._bbmax = new Point3f(v);
                while (li.hasNext()) {
                    v = ((OctPoint)li.next())._v;
                    if (v.x < this._bbmin.x) {
                        this._bbmin.x = v.x;
                    }
                    if (v.y < this._bbmin.y) {
                        this._bbmin.y = v.y;
                    }
                    if (v.z < this._bbmin.z) {
                        this._bbmin.z = v.z;
                    }
                    if (v.x > this._bbmax.x) {
                        this._bbmax.x = v.x;
                    }
                    if (v.y > this._bbmax.y) {
                        this._bbmax.y = v.y;
                    }
                    if (!(v.z > this._bbmax.z)) continue;
                    this._bbmax.z = v.z;
                }
                this.calc_center();
            }
        }

        public void calc_center() {
            ((OctTree)OctTree.this)._root._bbcenter = new Point3f(((OctTree)OctTree.this)._root._bbmax);
            ((OctTree)OctTree.this)._root._bbcenter.sub((Tuple3f)((OctTree)OctTree.this)._root._bbmin);
            ((OctTree)OctTree.this)._root._bbcenter.scale(0.5f);
            ((OctTree)OctTree.this)._root._bbcenter.add((Tuple3f)((OctTree)OctTree.this)._root._bbmin);
        }
    }

    public class OctPoint {
        public Point3f _v;
        public Object _data;

        public OctPoint() {
            this._v = null;
            this._data = null;
        }

        public OctPoint(Point3f v) {
            this._v = v;
            this._data = null;
        }

        public OctPoint(Point3f v, Object data) {
            this._v = v;
            this._data = data;
        }
    }
}

