/*
 * Decompiled with CFR 0.152.
 */
package misc;

public final class VoxelColorTable {
    private static double PI_2 = 1.5707963267948966;
    private static double SPEC = Math.PI * 2 - PI_2 / 2.0;
    public int[] _colors;

    public VoxelColorTable(int dim) {
        this._colors = new int[dim];
    }

    public final void init_roi_func(int min, int max, VoxelColorMode color_mode) {
        block3: {
            block2: {
                if (color_mode != VoxelColorMode.GREY) break block2;
                int i = 0;
                while (i < this._colors.length) {
                    this._colors[i] = this.create_grey_color(i, min, max);
                    ++i;
                }
                break block3;
            }
            if (color_mode != VoxelColorMode.PSEUDO) break block3;
            int i = 0;
            while (i < this._colors.length) {
                this._colors[i] = this.create_pseudo_color(i, min, max);
                ++i;
            }
        }
    }

    private final int create_pseudo_color(int pos, int min, int max) {
        int alpha = pos < min ? 0 : (pos >= max ? 255 : (pos - min << 8) / (max - min));
        pos = pos < min ? min : (pos > max ? max : (pos -= min));
        double red = Math.sin(SPEC / (double)(max - min) * (double)pos - Math.PI);
        red = (red + 1.0) / 2.0;
        red = red >= 0.0 ? (double)((int)(255.0 * red)) : 0.0;
        double green = Math.sin(SPEC / (double)(max - min) * (double)pos - PI_2);
        green = (green + 1.0) / 2.0;
        green = green >= 0.0 ? (double)((int)(255.0 * green)) : 0.0;
        double blue = Math.sin(SPEC / (double)(max - min) * (double)pos);
        blue = (blue + 1.0) / 2.0;
        blue = blue >= 0.0 ? (double)((int)(255.0 * blue)) : 0.0;
        int r = (int)Math.round(red);
        int g = (int)Math.round(green);
        int b = (int)Math.round(blue);
        return alpha << 24 | r << 16 | g << 8 | b;
    }

    private final int create_grey_color(int pos, int min, int max) {
        int grey = pos < min ? 0 : (pos >= max ? 255 : (int)(255.0 * (double)(pos - min) / (double)(max - min)));
        return grey << 24 | grey << 16 | grey << 8 | grey;
    }

    public static enum VoxelColorMode {
        GREY,
        PSEUDO,
        CUSTOM;

    }
}

