/*
 * Decompiled with CFR 0.152.
 */
package misc;

import misc.VoxelColorTable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class VoxelColorTableTest {
    private VoxelColorTable _vct;
    private static int DIM = 2048;

    @Before
    public void init() {
        this._vct = new VoxelColorTable(DIM);
    }

    @Test
    public void testVoxelColorTabl() {
        Assert.assertEquals((long)DIM, (long)this._vct._colors.length);
    }

    @Test
    public void testInit_roi_func() {
        int min = 100;
        int max = 355;
        this._vct.init_roi_func(min, max, VoxelColorTable.VoxelColorMode.GREY);
        int i = 0;
        while (i < DIM) {
            int color;
            if (i < min) {
                color = 0;
            } else if (i > max) {
                color = -1;
            } else {
                int val = i - min;
                color = val << 24 | val << 16 | val << 8 | val;
            }
            Assert.assertEquals((long)color, (long)this._vct._colors[i]);
            ++i;
        }
        min = 81;
        max = 253;
        this._vct.init_roi_func(min, max, VoxelColorTable.VoxelColorMode.GREY);
        double factor = 255.0 / (double)(max - min);
        int i2 = 0;
        while (i2 < DIM) {
            int color;
            if (i2 < min) {
                color = 0;
            } else if (i2 > max) {
                color = -1;
            } else {
                int val = (int)((double)(i2 - min) * factor);
                color = val << 24 | val << 16 | val << 8 | val;
            }
            Assert.assertEquals((long)color, (long)this._vct._colors[i2]);
            ++i2;
        }
    }
}

