/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.util.LinkedList;
import misc.Voxel;

public final class VoxelQueue {
    private final int _bucket_size;
    private int _last_bucket_counter;
    private int _first_bucket_counter;
    private final LinkedList<int[]> _bucket_list;
    private int[] _first_bucket;
    private int[] _last_bucket;
    private int _size;

    public VoxelQueue(int bucket_size) {
        this._bucket_size = bucket_size * 3;
        this._bucket_list = new LinkedList();
        this._last_bucket = new int[this._bucket_size];
        this._first_bucket = this._last_bucket;
        this._bucket_list.add(this._first_bucket);
        this._last_bucket_counter = 0;
        this._first_bucket_counter = 0;
        this._size = 0;
    }

    public void store(Voxel v) {
        if (this._last_bucket_counter == this._bucket_size) {
            this._last_bucket = new int[this._bucket_size];
            this._bucket_list.add(this._last_bucket);
            this._last_bucket_counter = 0;
        }
        this._last_bucket[this._last_bucket_counter + 0] = v._x;
        this._last_bucket[this._last_bucket_counter + 1] = v._y;
        this._last_bucket[this._last_bucket_counter + 2] = v._z;
        this._last_bucket_counter += 3;
        ++this._size;
    }

    public void store(int x, int y, int z) {
        if (this._last_bucket_counter == this._bucket_size) {
            this._last_bucket = new int[this._bucket_size];
            this._bucket_list.add(this._last_bucket);
            this._last_bucket_counter = 0;
        }
        this._last_bucket[this._last_bucket_counter + 0] = x;
        this._last_bucket[this._last_bucket_counter + 1] = y;
        this._last_bucket[this._last_bucket_counter + 2] = z;
        this._last_bucket_counter += 3;
        ++this._size;
    }

    public void fetch(Voxel v) {
        if (this._first_bucket_counter == this._bucket_size) {
            if (this._first_bucket != this._last_bucket) {
                this._bucket_list.removeFirst();
                this._first_bucket = this._bucket_list.getFirst();
            }
            this._first_bucket_counter = 0;
        }
        v._x = this._first_bucket[this._first_bucket_counter + 0];
        v._y = this._first_bucket[this._first_bucket_counter + 1];
        v._z = this._first_bucket[this._first_bucket_counter + 2];
        this._first_bucket_counter += 3;
        --this._size;
    }

    public int size() {
        return this._size;
    }
}

