/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.util.LinkedList;
import misc.Voxel;

public final class VoxelStack {
    private final int _bucket_size;
    private int _bucket_counter;
    private final LinkedList<int[]> _bucket_list;
    private int[] _bucket;
    private int _size;

    public VoxelStack(int bucket_size) {
        this._bucket_size = bucket_size * 3;
        this._bucket_list = new LinkedList();
        this._bucket = new int[this._bucket_size];
        this._bucket_list.add(this._bucket);
        this._bucket_counter = 0;
        this._size = 0;
    }

    public void store(Voxel v) {
        if (this._bucket_counter == this._bucket_size) {
            this._bucket = new int[this._bucket_size];
            this._bucket_list.add(this._bucket);
            this._bucket_counter = 0;
        }
        this._bucket[this._bucket_counter + 0] = v._x;
        this._bucket[this._bucket_counter + 1] = v._y;
        this._bucket[this._bucket_counter + 2] = v._z;
        this._bucket_counter += 3;
        ++this._size;
    }

    public void store(int x, int y, int z) {
        if (this._bucket_counter == this._bucket_size) {
            this._bucket = new int[this._bucket_size];
            this._bucket_list.add(this._bucket);
            this._bucket_counter = 0;
        }
        this._bucket[this._bucket_counter + 0] = x;
        this._bucket[this._bucket_counter + 1] = y;
        this._bucket[this._bucket_counter + 2] = z;
        this._bucket_counter += 3;
        ++this._size;
    }

    public void fetch(Voxel v) {
        if (this._bucket_counter == 0) {
            if (this._bucket_list.size() != 1) {
                this._bucket_list.removeLast();
                this._bucket = this._bucket_list.getLast();
            }
            this._bucket_counter = this._bucket_size;
        }
        v._z = this._bucket[this._bucket_counter - 1];
        v._y = this._bucket[this._bucket_counter - 2];
        v._x = this._bucket[this._bucket_counter - 3];
        this._bucket_counter -= 3;
        --this._size;
    }

    public int size() {
        return this._size;
    }
}

