/*
 * Decompiled with CFR 0.152.
 */
package misc.dicom;

import java.io.IOException;
import misc.dicom.DiDi;
import misc.dicom.DiFile;
import misc.dicom.DiFileInputStream;
import misc.dicom.DiFileOutputStream;

public final class DiDataElement {
    protected int _groupid;
    protected int _elementid;
    protected int _vr;
    protected int _vl;
    protected byte[] _values;
    private static String VL_ERROR = "DICOM Error: Wrong VL!";

    public DiDataElement() {
        this._groupid = 0;
        this._elementid = 0;
        this._vr = 0;
        this._vl = 0;
        this._values = null;
    }

    public DiDataElement(int groupid, int elementid, int vr, byte[] values) {
        this._groupid = groupid;
        this._elementid = elementid;
        this._vr = vr;
        this._vl = values.length;
        this._values = values;
    }

    public final void read_next(DiFileInputStream dfis) throws IOException {
        boolean explicit;
        int endianess;
        int vr_format;
        int b0 = dfis.read_byte();
        int b1 = dfis.read_byte();
        this._groupid = b1 << 8 | b0;
        if (dfis._before_meta_group && this._groupid == 2) {
            dfis._before_meta_group = false;
            dfis._meta_group = true;
        }
        if (dfis._meta_group && this._groupid != 2) {
            dfis._meta_group = false;
        }
        if (dfis._before_meta_group || dfis._meta_group) {
            vr_format = DiFile.VR_EXPLICIT;
            endianess = DiFile.ENDIAN_LITTLE;
        } else {
            vr_format = dfis.get_vr_format();
            endianess = dfis.get_endianess();
        }
        if (endianess == DiFile.ENDIAN_BIG) {
            this._groupid = b0 << 8 | b1;
        }
        this._elementid = dfis.read_short(endianess);
        b0 = dfis.read_byte();
        b1 = dfis.read_byte();
        this._vr = b0 << 8 | b1;
        boolean bl = explicit = vr_format == DiFile.VR_EXPLICIT || vr_format == DiFile.VR_UNKNOWN && (this._vr == 16709 || this._vr == 16723 || this._vr == 16724 || this._vr == 17235 || this._vr == 17473 || this._vr == 17491 || this._vr == 17492 || this._vr == 17988 || this._vr == 17996 || this._vr == 18771 || this._vr == 19535 || this._vr == 19540 || this._vr == 20558 || this._vr == 21320 || this._vr == 21324 || this._vr == 21331 || this._vr == 21332 || this._vr == 21581 || this._vr == 21833 || this._vr == 21836 || this._vr == 21843 || this._vr == 21844 || this._vr == 20290 || this._vr == 20311 || this._vr == 21329 || this._vr == 21838 || this._vr == 16191);
        if (this._groupid == 65534 && (this._elementid == 57344 || this._elementid == 57357 || this._elementid == 57565)) {
            explicit = false;
        }
        if (explicit) {
            if (this._vr == 20290 || this._vr == 20311 || this._vr == 21329 || this._vr == 21844 || this._vr == 21838) {
                dfis.read_byte();
                dfis.read_byte();
                this._vl = dfis.read_int(endianess);
            } else {
                this._vl = dfis.read_short(endianess);
            }
            if (this._vl == -1) {
                this._vl = 0;
            }
            this._values = new byte[this._vl];
        } else {
            this._vr = DiDi.get_vr(this.get_tag());
            int b2 = dfis.read_byte();
            int b3 = dfis.read_byte();
            this._vl = endianess == DiFile.ENDIAN_LITTLE ? (b3 << 24) + (b2 << 16) + (b1 << 8) + b0 : (b0 << 24) + (b1 << 16) + (b2 << 8) + b3;
            if (this._vl == -1) {
                this._vl = 0;
            }
            this._values = new byte[this._vl];
        }
        dfis.read(this._values);
        if (endianess == DiFile.ENDIAN_BIG && (this._vr == 21843 || this._vr == 21331 || this._vr == 20311 || this._vr == 21836 || this._vr == 21324 || this._vr == 17996 || this._vr == 17988)) {
            int i = 0;
            while (i < this._values.length / 2) {
                byte tmp = this._values[i];
                this._values[i] = this._values[this._values.length - 1 - i];
                this._values[this._values.length - 1 - i] = tmp;
                ++i;
            }
        }
    }

    public final void write(DiFileOutputStream dfos) throws Exception {
        int endianess;
        int vr_format;
        if (this._groupid <= 2) {
            vr_format = DiFile.VR_EXPLICIT;
            endianess = DiFile.ENDIAN_LITTLE;
        } else {
            endianess = dfos.get_endianess();
            vr_format = dfos.get_vr_format();
        }
        dfos.write_short(this._groupid, endianess);
        dfos.write_short(this._elementid, endianess);
        if (vr_format == DiFile.VR_EXPLICIT) {
            dfos.write(this.get_vr_string().getBytes());
            if (this._vr == 20290 || this._vr == 20311 || this._vr == 21329 || this._vr == 21844 || this._vr == 21838) {
                dfos.write(0);
                dfos.write(0);
                dfos.write_int(this._vl, endianess);
            } else {
                dfos.write_short(this._vl, endianess);
            }
        } else {
            dfos.write_int(this._vl, endianess);
        }
        dfos.write(this._values);
    }

    public final String toString() {
        String str = String.valueOf(this.get_tag_string()) + " (" + DiDi.get_tag_descr(this.get_tag()) + ")  ";
        str = String.valueOf(str) + "VR: " + this.get_vr_string() + "  VL: " + this._vl + "  Values: " + this.get_value_as_string();
        return str;
    }

    public final int get_element_id() {
        return this._elementid;
    }

    public final int get_group_id() {
        return this._groupid;
    }

    public final int get_vl() {
        return this._vl;
    }

    public final void set_vl(int value_length) {
        this._vl = value_length;
    }

    public final byte[] get_values() {
        return this._values;
    }

    public final double get_value_as_double() {
        String str = this.get_value_as_string();
        return Double.parseDouble(str.trim());
    }

    public final int get_value_as_int() {
        String str = this.get_value_as_string();
        return Integer.parseInt(str.trim());
    }

    public final String get_value_as_string() {
        String str = new String();
        if (this._vl > 255) {
            str = "(to long to be printed)";
        } else if (this._vr == 16709 || this._vr == 16723 || this._vr == 17235 || this._vr == 17473 || this._vr == 17491 || this._vr == 17492 || this._vr == 18771 || this._vr == 19535 || this._vr == 19540 || this._vr == 20294 || this._vr == 20558 || this._vr == 21320 || this._vr == 21332 || this._vr == 21581 || this._vr == 21833 || this._vr == 21838 || this._vr == 21844) {
            int i = 0;
            while (i < this._vl) {
                if (this._values[i] > 0) {
                    str = String.valueOf(str) + (char)this._values[i];
                }
                ++i;
            }
        } else if (this._vr == 17996) {
            if (this._values.length == 4) {
                int tmp = this._values[3] << 24 | this._values[2] << 16 | this._values[1] << 8 | this._values[0];
                Float f = new Float(Float.intBitsToFloat(tmp));
                str = f.toString();
            } else {
                str = VL_ERROR;
            }
        } else if (this._vr == 17988) {
            if (this._values.length == 8) {
                int tmp = this._values[7] << 56 | this._values[6] << 48 | this._values[5] << 40 | this._values[0] << 32 | this._values[3] << 24 | this._values[2] << 16 | this._values[1] << 8 | this._values[0];
                Double d = new Double(Double.longBitsToDouble(tmp));
                str = d.toString();
            } else {
                str = VL_ERROR;
            }
        } else if (this._vr == 21324) {
            if (this._values.length == 4) {
                int tmp = this._values[3] << 24 | this._values[2] << 16 | this._values[1] << 8 | this._values[0];
                str = "" + tmp;
            } else {
                str = VL_ERROR;
            }
        } else if (this._vr == 21329) {
            str = "TODO";
        } else if (this._vr == 21331) {
            if (this._values.length == 2) {
                int tmp = this._values[1] << 8 | this._values[0];
                str = "" + tmp;
            } else {
                str = VL_ERROR;
            }
        } else if (this._vr == 21836) {
            if (this._values.length == 4) {
                long tmp = (this._values[3] & 0xFF) << 24 | (this._values[2] & 0xFF) << 16 | (this._values[1] & 0xFF) << 8 | this._values[0] & 0xFF;
                str = "" + tmp;
            } else {
                str = VL_ERROR;
            }
        } else if (this._vr == 21843) {
            if (this._values.length == 2) {
                int tmp = (this._values[1] & 0xFF) << 8 | this._values[0] & 0xFF;
                str = "" + tmp;
            } else {
                str = VL_ERROR;
            }
        } else {
            int i = 0;
            while (i < this._vl) {
                str = String.valueOf(str) + this._values[i] + "|";
                ++i;
            }
        }
        return str;
    }

    public final int get_vr() {
        return this._vr;
    }

    public final String get_vr_string() {
        return "" + (char)((this._vr & 0xFF00) >> 8) + (char)(this._vr & 0xFF);
    }

    public final int get_tag() {
        return this._groupid << 16 | this._elementid;
    }

    public final String get_tag_string() {
        return "(" + this.my_format(this._groupid) + "," + this.my_format(this._elementid) + ")";
    }

    private final String my_format(int num) {
        String str = new String(Integer.toHexString(num));
        if (num < 4096) {
            str = "0" + str;
        }
        if (num < 256) {
            str = "0" + str;
        }
        if (num < 16) {
            str = "0" + str;
        }
        return str;
    }
}

