/*
 * Decompiled with CFR 0.152.
 */
package misc.dicom;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import misc.dicom.DiDataElement;
import misc.dicom.DiFileInputStream;
import misc.dicom.DiFileOutputStream;

public final class DiFile {
    public static int VR_UNKNOWN = 0;
    public static int VR_EXPLICIT = 1;
    public static int VR_IMPLICIT = 2;
    public static int ENDIAN_UNKNOWN = 0;
    public static int ENDIAN_LITTLE = 1;
    public static int ENDIAN_BIG = 2;
    private int _vr_format;
    private int _endianess;
    private int _w;
    private int _h;
    private int _bits_stored;
    private int _bits_allocated;
    private int _image_number;
    private String _file_name;
    private final HashMap<Integer, DiDataElement> _data_elements;
    private final HashMap<Integer, HashMap<Integer, DiDataElement>> _sequences;

    public DiFile() {
        this._image_number = 0;
        this._bits_allocated = 0;
        this._bits_stored = 0;
        this._h = 0;
        this._w = 0;
        this._data_elements = new HashMap();
        this._sequences = new HashMap();
        this._file_name = null;
        this._vr_format = VR_UNKNOWN;
        this._endianess = ENDIAN_UNKNOWN;
    }

    public DiFile(int endianess, int vr_format) {
        this._image_number = 0;
        this._bits_allocated = 0;
        this._bits_stored = 0;
        this._h = 0;
        this._w = 0;
        this._data_elements = new HashMap();
        this._sequences = new HashMap();
        this._file_name = null;
        this._vr_format = vr_format;
        this._endianess = endianess;
    }

    public DiFile(DiFile df) {
        this._vr_format = df._vr_format;
        this._endianess = df._endianess;
        this._w = df._w;
        this._h = df._h;
        this._bits_stored = df._bits_stored;
        this._bits_allocated = df.get_bits_allocated();
        this._image_number = df._image_number;
        this._file_name = new String(df._file_name);
        this._data_elements = new HashMap<Integer, DiDataElement>(df._data_elements);
        this._sequences = new HashMap<Integer, HashMap<Integer, DiDataElement>>(df._sequences);
    }

    public void load_from_file(String file_name) throws Exception {
        DiDataElement de;
        this._vr_format = VR_UNKNOWN;
        this._endianess = ENDIAN_UNKNOWN;
        DiDataElement de_old = null;
        this._file_name = new String(file_name);
        DiFileInputStream dfis = new DiFileInputStream(file_name);
        dfis.skip_header();
        do {
            de = new DiDataElement();
            de.read_next(dfis);
            if (de.get_tag() == -73728) {
                HashMap<Integer, DiDataElement> seq = new HashMap<Integer, DiDataElement>();
                DiDataElement seq_de = new DiDataElement();
                while (seq_de.get_tag() != -73507) {
                    seq_de = new DiDataElement();
                    seq_de.read_next(dfis);
                    seq.put(seq_de.get_tag(), seq_de);
                }
                this._sequences.put(de_old.get_tag(), seq);
            } else {
                this._data_elements.put(de.get_tag(), de);
                if (de.get_tag() == 131088) {
                    if (de.get_value_as_string().equals("1.2.840.10008.1.2")) {
                        this._vr_format = VR_IMPLICIT;
                        this._endianess = ENDIAN_LITTLE;
                    } else if (de.get_value_as_string().equals("1.2.840.10008.1.2.1")) {
                        this._vr_format = VR_EXPLICIT;
                        this._endianess = ENDIAN_LITTLE;
                    } else if (de.get_value_as_string().equals("1.2.840.10008.1.2.2")) {
                        this._vr_format = VR_EXPLICIT;
                        this._endianess = ENDIAN_BIG;
                    } else {
                        System.err.println("DiFile Warning: Unknown Transfer Syntax UID. Endianess & VR format will be guessed.");
                    }
                    dfis.set_endianess(this._vr_format);
                    dfis.set_endianess(this._endianess);
                }
            }
            de_old = de;
        } while (de.get_tag() != 2145386512);
        dfis.close();
        de = this._data_elements.get(2097171);
        this._image_number = de == null ? 0 : de.get_value_as_int();
        de = this._data_elements.get(2621456);
        this._h = de.get_value_as_int();
        de = this._data_elements.get(2621457);
        this._w = de.get_value_as_int();
        de = this._data_elements.get(2621696);
        this._bits_allocated = de.get_value_as_int();
        de = this._data_elements.get(2621697);
        this._bits_stored = de.get_value_as_int();
    }

    public void load_from_file(File file) throws Exception {
        this.load_from_file(file.getAbsolutePath());
    }

    public void save_to_file(String file_name) throws Exception {
        DiFileOutputStream dfos = new DiFileOutputStream(file_name);
        dfos.set_endianess(this._endianess);
        dfos.set_vr_format(this._vr_format);
        dfos.write_header();
        ArrayList<Integer> de_tags = new ArrayList<Integer>(this._data_elements.keySet());
        Collections.sort(de_tags);
        for (Integer tag : de_tags) {
            DiDataElement de = this._data_elements.get(tag);
            de.write(dfos);
        }
        dfos.close();
    }

    public final String toString() {
        String str = new String();
        str = String.valueOf(str) + this._file_name + "\n";
        ArrayList<Integer> de_tags = new ArrayList<Integer>(this._data_elements.keySet());
        Collections.sort(de_tags);
        for (Integer key : de_tags) {
            DiDataElement el = this._data_elements.get(key);
            str = String.valueOf(str) + el.toString();
        }
        return str;
    }

    public int get_bits_allocated() {
        return this._bits_allocated;
    }

    public int get_bits_stored() {
        return this._bits_stored;
    }

    public int get_slope() {
        double slope = 1.0;
        DiDataElement de = this._data_elements.get(2625619);
        if (de != null) {
            try {
                slope = de.get_value_as_double();
                if (slope == 0.0) {
                    slope = 1.0;
                }
            }
            catch (Exception ex) {
                System.err.println("DiFile::get_slope: Unhandeld Expression:" + ex);
            }
        }
        return (int)Math.round(slope);
    }

    public int get_intercept() {
        double intercept = 0.0;
        DiDataElement de = this._data_elements.get(2625618);
        if (de != null) {
            try {
                intercept = de.get_value_as_double();
            }
            catch (Exception ex) {
                System.err.println("DiFile::get_intercept: Unhandeld Expression:" + ex);
            }
        }
        return (int)Math.round(intercept);
    }

    public double[] get_image_pos_patient() {
        String[] str;
        double[] pos = new double[3];
        pos[2] = 0.0;
        pos[1] = 0.0;
        pos[0] = 0.0;
        DiDataElement de = this._data_elements.get(0x200032);
        if (de != null && (str = de.get_value_as_string().split("\\\\")).length == 3) {
            pos[0] = Double.parseDouble(str[0]);
            pos[1] = Double.parseDouble(str[1]);
            pos[2] = Double.parseDouble(str[2]);
        }
        return pos;
    }

    public double[][] get_image_orientation_patient() {
        String[] str;
        double[][] orient = new double[2][3];
        orient[0][2] = 0.0;
        orient[0][1] = 0.0;
        orient[0][0] = 0.0;
        orient[1][2] = 0.0;
        orient[1][1] = 0.0;
        orient[1][0] = 0.0;
        DiDataElement de = this._data_elements.get(2097207);
        if (de != null && (str = de.get_value_as_string().split("\\\\")).length == 6) {
            orient[0][0] = Double.parseDouble(str[0]);
            orient[0][1] = Double.parseDouble(str[1]);
            orient[0][2] = Double.parseDouble(str[2]);
            orient[1][0] = Double.parseDouble(str[3]);
            orient[1][1] = Double.parseDouble(str[4]);
            orient[1][2] = Double.parseDouble(str[5]);
        }
        return orient;
    }

    public double[] get_pixel_spacing() {
        Object str;
        double[] spacing = new double[3];
        spacing[2] = 1.0;
        spacing[1] = 1.0;
        spacing[0] = 1.0;
        DiDataElement de = this._data_elements.get(2621488);
        if (de != null && ((String[])(str = de.get_value_as_string().split("\\\\"))).length == 2) {
            spacing[0] = Double.parseDouble(str[0]);
            spacing[1] = Double.parseDouble(str[1]);
        }
        if ((de = this._data_elements.get(1572944)) != null) {
            str = de.get_value_as_string();
            try {
                spacing[2] = Double.parseDouble((String)str);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return spacing;
    }

    public int get_window_center() {
        double w_center = -1.0;
        DiDataElement de = this._data_elements.get(2625616);
        if (de != null) {
            try {
                w_center = de.get_value_as_double();
            }
            catch (Exception ex1) {
                String[] parts = de.get_value_as_string().split("\\\\");
                if (parts.length > 0) {
                    try {
                        w_center = Double.parseDouble(parts[0]);
                    }
                    catch (NumberFormatException ex2) {
                        w_center = -1.0;
                        System.err.print("DiFile::get_window_center: Expression:" + ex1 + ". Fixing failed.");
                    }
                }
                w_center = -1.0;
                System.err.print("DiFile::get_window_center: Expression:" + ex1 + ". Fixing failed.");
            }
        }
        if (w_center == -1.0) {
            w_center = 1 << this._bits_stored - 1;
        }
        return (int)Math.round(w_center);
    }

    public int get_window_width() {
        double w_width = 0.0;
        DiDataElement de = this._data_elements.get(2625617);
        if (de != null) {
            try {
                w_width = de.get_value_as_double();
            }
            catch (Exception ex1) {
                String[] parts = de.get_value_as_string().split("\\\\");
                if (parts.length > 0) {
                    try {
                        w_width = Double.parseDouble(parts[0]);
                    }
                    catch (NumberFormatException ex2) {
                        w_width = -1.0;
                        System.err.print("DiFile::get_window_width: Expression:" + ex1 + ". Fixing failed.");
                    }
                }
                w_width = -1.0;
                System.err.print("DiFile::get_window_width: Expression:" + ex1 + ". Fixing failed.");
            }
        }
        if (w_width == 0.0) {
            w_width = 1 << this._bits_stored;
        }
        return (int)Math.round(w_width);
    }

    public HashMap<Integer, DiDataElement> get_squence(int tag) {
        return this._sequences.get(tag);
    }

    public HashMap<Integer, DiDataElement> get_data_elements() {
        return this._data_elements;
    }

    public int get_image_width() {
        return this._w;
    }

    public int get_image_height() {
        return this._h;
    }

    public String get_file_name() {
        return this._file_name;
    }

    public String get_study_instance_uid() {
        DiDataElement de = this._data_elements.get(0x20000D);
        return de.get_value_as_string();
    }

    public String get_series_instance_uid() {
        DiDataElement de = this._data_elements.get(0x20000E);
        return de.get_value_as_string();
    }

    public int get_image_number() {
        return this._image_number;
    }

    public int get_vr_format() {
        return this._vr_format;
    }

    public int get_endianess() {
        return this._endianess;
    }

    public int get_pixel_padding_value() {
        DiDataElement de = this.get_data_elements().get(2621728);
        int pixel_padding_value = de != null ? de.get_value_as_int() : Integer.MAX_VALUE;
        return pixel_padding_value;
    }

    public int[] get_pixel_data() {
        int h = this.get_image_height();
        int w = this.get_image_width();
        return this.get_pixel_data(new int[w * h]);
    }

    public int[] get_pixel_data(int[] pixel_data) {
        DiDataElement de = this.get_data_elements().get(2145386512);
        byte[] byte_data = de.get_values();
        int bytes_pp = this.get_bytes_per_pixel();
        int i = 0;
        while (i < pixel_data.length) {
            int value = 0;
            int j = 0;
            while (j < bytes_pp) {
                value |= (0xFF & byte_data[i * bytes_pp + j]) << j * 8;
                ++j;
            }
            pixel_data[i] = value * this.get_slope() + this.get_intercept();
            ++i;
        }
        return pixel_data;
    }

    public int get_bytes_per_pixel() {
        return (this.get_data_elements().get(2621696).get_value_as_int() - 1) / 8 + 1;
    }

    public void set_pixel_data(int w, int h, int[] pixel_data, int bytes_pp) {
        this.set_pixel_data(w, h, pixel_data, 0, (1 << 8 * bytes_pp) - 1);
    }

    public void set_pixel_data(int w, int h, int[] pixel_data, int min, int max) {
        int intercept = min;
        int range = max -= min;
        if (range <= 0) {
            throw new IllegalArgumentException("DiFile::set_pixel_data  max<=min");
        }
        int bits_stored = 32 - Integer.numberOfLeadingZeros(max);
        int bytes_pp = (bits_stored - 1) / 8 + 1;
        int bits_allocated = bytes_pp * 8;
        byte[] byte_data = new byte[pixel_data.length * bytes_pp];
        int i = 0;
        while (i < pixel_data.length) {
            int value = pixel_data[i];
            int j = 0;
            while (j < bytes_pp) {
                byte_data[i * bytes_pp + j] = (byte)(value - intercept >>> j * 8);
                ++j;
            }
            ++i;
        }
        DiDataElement de = new DiDataElement(40, 16, 21843, DiFileOutputStream.short_to_byte_array(h, this._endianess));
        this._data_elements.put(de.get_tag(), de);
        this._h = h;
        de = new DiDataElement(40, 17, 21843, DiFileOutputStream.short_to_byte_array(w, this._endianess));
        this._data_elements.put(de.get_tag(), de);
        this._w = w;
        de = new DiDataElement(40, 256, 21843, DiFileOutputStream.short_to_byte_array(bits_allocated, this._endianess));
        this._data_elements.put(de.get_tag(), de);
        this._bits_allocated = bits_allocated;
        de = new DiDataElement(40, 257, 21843, DiFileOutputStream.short_to_byte_array(bits_stored, this._endianess));
        this._data_elements.put(de.get_tag(), de);
        this._bits_stored = bits_stored;
        de = new DiDataElement(40, 258, 21843, DiFileOutputStream.short_to_byte_array(bits_stored - 1, this._endianess));
        this._data_elements.put(de.get_tag(), de);
        de = new DiDataElement(40, 4176, 17491, String.valueOf(range / 2 + intercept).getBytes());
        this._data_elements.put(de.get_tag(), de);
        de = new DiDataElement(40, 4177, 17491, String.valueOf(range).getBytes());
        this._data_elements.put(de.get_tag(), de);
        de = new DiDataElement(40, 4178, 17491, String.valueOf(intercept).getBytes());
        this._data_elements.put(de.get_tag(), de);
        de = new DiDataElement(40, 4179, 17491, new String("1").getBytes());
        this._data_elements.put(de.get_tag(), de);
        de = new DiDataElement(32736, 16, 20290, byte_data);
        this._data_elements.put(de.get_tag(), de);
    }

    public int get_min_possible_value() {
        return this.get_intercept();
    }

    public int get_max_possible_value() {
        return this.get_intercept() + this.get_slope() * (1 << this.get_bits_stored());
    }
}

