/*
 * Decompiled with CFR 0.152.
 */
package misc.dicom;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import misc.dicom.DiDataElement;
import misc.dicom.DiFile;

public final class DiFileInputStream
extends FileInputStream {
    public static int DFIS_WRONG_SERIES = -1;
    public static int DFIS_SCOUT_IMAGE = -2;
    public static int DFIS_NO_IMAGE_NUMBER = -3;
    private int _location = 0;
    private int _endianess = DiFile.ENDIAN_UNKNOWN;
    private int _vr_format = DiFile.VR_UNKNOWN;
    public boolean _meta_group = false;
    public boolean _before_meta_group = true;

    public DiFileInputStream(String fname) throws IOException {
        super(fname);
    }

    public DiFileInputStream(File file) throws IOException {
        super(file);
    }

    @Override
    public final int read(byte[] bytes) throws IOException {
        int len = super.read(bytes);
        if (len != bytes.length) {
            throw new EOFException();
        }
        this._location += len;
        return len;
    }

    public final int read_byte() throws IOException {
        int b = this.read();
        if (b == -1) {
            throw new EOFException();
        }
        ++this._location;
        return b;
    }

    public final int read_short(int endianess) throws IOException {
        int b0 = this.read_byte();
        int b1 = this.read_byte();
        int result = b0 == -1 || b1 == -1 ? -1 : (endianess != DiFile.ENDIAN_BIG ? b1 << 8 | b0 : b0 << 8 | b1);
        return result;
    }

    public final int read_int(int endianess) throws IOException {
        int b0 = this.read_byte();
        int b1 = this.read_byte();
        int b2 = this.read_byte();
        int b3 = this.read_byte();
        int result = b0 == -1 || b1 == -1 || b2 == -1 || b3 == -1 ? -1 : (endianess != DiFile.ENDIAN_BIG ? (b3 << 24) + (b2 << 16) + (b1 << 8) + b0 : (b0 << 24) + (b1 << 16) + (b2 << 8) + b3);
        return result;
    }

    public final boolean skip_header() throws IOException {
        byte[] dicm = new byte[4];
        this.skip(128L);
        if (this.read(dicm) < 0) {
            return false;
        }
        this._location = 132;
        return (char)dicm[0] == 'D' && (char)dicm[1] == 'I' && (char)dicm[2] == 'C' && (char)dicm[3] == 'M';
    }

    public QuickInfo get_quick_info() {
        DiDataElement de = new DiDataElement();
        QuickInfo qi = new QuickInfo();
        this._vr_format = DiFile.VR_EXPLICIT;
        this._endianess = DiFile.ENDIAN_LITTLE;
        boolean exception_occured = false;
        boolean in_sequence = false;
        do {
            try {
                de.read_next(this);
            }
            catch (Exception ex) {
                System.err.println("DiFileInputStream::get_quick_info failed:" + ex);
                exception_occured = true;
            }
            if (de.get_tag() == 524296) {
                String image_type = de.get_value_as_string();
                String[] split = image_type.split("\\\\");
                if (split.length > 2 && split[2].equals("SCOUT")) {
                    qi._scout = true;
                    continue;
                }
                qi._scout = false;
                continue;
            }
            if (de.get_tag() == 131088) {
                String ts_uid = de.get_value_as_string();
                if (ts_uid.equals("1.2.840.10008.1.2")) {
                    this._vr_format = DiFile.VR_IMPLICIT;
                    this._endianess = DiFile.ENDIAN_LITTLE;
                    continue;
                }
                if (de.get_value_as_string().equals("1.2.840.10008.1.2.1")) {
                    this._vr_format = DiFile.VR_EXPLICIT;
                    this._endianess = DiFile.ENDIAN_LITTLE;
                    continue;
                }
                if (de.get_value_as_string().equals("1.2.840.10008.1.2.2")) {
                    this._vr_format = DiFile.VR_EXPLICIT;
                    this._endianess = DiFile.ENDIAN_BIG;
                    continue;
                }
                System.err.println("DiFileInputStream::get_quick_info Warning: Unknown Transfer Syntax UID \"" + ts_uid + "\". Endianess & VR format will be guessed.");
                continue;
            }
            if (de.get_tag() == 0x20000E) {
                qi._series_uid = de.get_value_as_string();
                continue;
            }
            if (de.get_tag() == -73728) {
                in_sequence = true;
                continue;
            }
            if (de.get_tag() != -73507) continue;
            in_sequence = false;
        } while (!exception_occured && (in_sequence || de.get_tag() < 2097171));
        qi._image_number = de.get_tag() == 2097171 ? de.get_value_as_int() : DFIS_NO_IMAGE_NUMBER;
        return qi;
    }

    public final int quick_check(String series_uid) throws IOException {
        DiDataElement de = new DiDataElement();
        this._vr_format = DiFile.VR_EXPLICIT;
        this._endianess = DiFile.ENDIAN_LITTLE;
        boolean exception_occured = false;
        boolean in_sequence = false;
        do {
            try {
                de.read_next(this);
            }
            catch (Exception ex) {
                System.err.println("DiFileInputStream::quick_check failed:" + ex);
                exception_occured = true;
            }
            if (de.get_tag() == 524296) {
                String image_type = de.get_value_as_string();
                String[] split = image_type.split("\\\\");
                if (split.length <= 2 || !split[2].equals("SCOUT")) continue;
                return DFIS_SCOUT_IMAGE;
            }
            if (de.get_tag() == 131088) {
                if (de.get_value_as_string().equals("1.2.840.10008.1.2")) {
                    this._vr_format = DiFile.VR_IMPLICIT;
                    this._endianess = DiFile.ENDIAN_LITTLE;
                    continue;
                }
                if (de.get_value_as_string().equals("1.2.840.10008.1.2.1")) {
                    this._vr_format = DiFile.VR_EXPLICIT;
                    this._endianess = DiFile.ENDIAN_LITTLE;
                    continue;
                }
                if (de.get_value_as_string().equals("1.2.840.10008.1.2.2")) {
                    this._vr_format = DiFile.VR_EXPLICIT;
                    this._endianess = DiFile.ENDIAN_BIG;
                    continue;
                }
                System.err.println("DiFileInputStream::quick_check Warning: Unknown Transfer Syntax UID. Endianess & VR format will be guessed.");
                continue;
            }
            if (de.get_tag() == 0x20000E) {
                if (series_uid.equals(de.get_value_as_string())) continue;
                return DFIS_WRONG_SERIES;
            }
            if (de.get_tag() == -73728) {
                in_sequence = true;
                continue;
            }
            if (de.get_tag() != -73507) continue;
            in_sequence = false;
        } while (!exception_occured && (in_sequence || de.get_tag() < 2097171));
        if (de.get_tag() != 2097171) {
            return DFIS_NO_IMAGE_NUMBER;
        }
        return de.get_value_as_int();
    }

    public final int get_location() {
        return this._location;
    }

    public final int get_endianess() {
        return this._endianess;
    }

    public final void set_endianess(int endianess) {
        this._endianess = endianess;
    }

    public final int get_vr_format() {
        return this._vr_format;
    }

    public final void set_vr_format(int vr_format) {
        this._vr_format = vr_format;
    }

    public class QuickInfo {
        public String _series_uid;
        public int _image_number;
        public boolean _scout;
    }
}

