/*
 * Decompiled with CFR 0.152.
 */
package misc.dicom;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import misc.dicom.DiFile;

public final class DiFileOutputStream
extends FileOutputStream {
    private int _endianess;
    private int _vr_format;

    public static byte[] int_to_byte_array(int value, int endianess) {
        byte[] b = new byte[4];
        if (endianess != DiFile.ENDIAN_BIG) {
            int i = 0;
            while (i < b.length) {
                b[i] = (byte)(value >>> i * 8);
                ++i;
            }
        } else {
            int i = b.length - 1;
            while (i >= 0) {
                b[i] = (byte)(value >>> i * 8);
                --i;
            }
        }
        return b;
    }

    public static byte[] short_to_byte_array(int value, int endianess) {
        byte[] b = new byte[2];
        if (endianess != DiFile.ENDIAN_BIG) {
            int i = 0;
            while (i < b.length) {
                b[i] = (byte)(value >>> i * 8);
                ++i;
            }
        } else {
            int i = b.length - 1;
            while (i >= 0) {
                b[i] = (byte)(value >>> i * 8);
                --i;
            }
        }
        return b;
    }

    public DiFileOutputStream(String name) throws FileNotFoundException {
        super(name);
    }

    public final void write_header() throws IOException {
        byte[] header = new byte[132];
        header[128] = 68;
        header[129] = 73;
        header[130] = 67;
        header[131] = 77;
        this.write(header);
    }

    public final void write_short(int value, int endianess) throws IOException {
        this.write(DiFileOutputStream.short_to_byte_array(value, endianess));
    }

    public final void write_int(int value, int endianess) throws IOException {
        this.write(DiFileOutputStream.int_to_byte_array(value, endianess));
    }

    public int get_endianess() {
        return this._endianess;
    }

    public void set_endianess(int endianess) {
        this._endianess = endianess;
    }

    public int get_vr_format() {
        return this._vr_format;
    }

    public void set_vr_format(int vrFormat) {
        this._vr_format = vrFormat;
    }
}

