/*
 * Decompiled with CFR 0.152.
 */
package misc.geomarker;

import java.awt.Color;
import java.util.Collection;
import java.util.Iterator;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import main.Message;
import misc.geomarker.GeoMarker;

public class GMPolyCurve
extends GeoMarker {
    protected Point3d[] _points;
    protected double _length;
    protected boolean _length_update_needed = true;

    public GMPolyCurve(String label, Point3d[] points) {
        super(label);
        this.set_points(points);
    }

    public GMPolyCurve(String label, Color color, Point3d[] points) {
        super(label, color);
        this.set_points(points);
    }

    public GMPolyCurve(String label, int point_number) {
        super(label);
        this._points = new Point3d[point_number];
    }

    public GMPolyCurve(String label, Color color, int point_number) {
        super(label, color);
        this._points = new Point3d[point_number];
    }

    public Point3d[] get_points() {
        return this._points;
    }

    public Point3d get_point(int i) {
        return this._points[i];
    }

    public void set_point(int i, Point3d p) {
        this._points[i] = new Point3d(p);
        this._length_update_needed = true;
        this.setChanged();
        this.notifyObservers(new Message(M_MARKER_GEO_CHANGED, null));
    }

    public void set_points(Point3d[] points) {
        this._points = new Point3d[points.length];
        int i = 0;
        while (i < points.length) {
            this._points[i] = new Point3d(points[i]);
            ++i;
        }
        this._length_update_needed = true;
        this.setChanged();
        this.notifyObservers(new Message(M_MARKER_GEO_CHANGED, null));
    }

    public void set_points(Collection<Point3d> c) {
        this._points = new Point3d[c.size()];
        Iterator<Point3d> p3i = c.iterator();
        int i = 0;
        while (p3i.hasNext()) {
            this._points[i++] = new Point3d(p3i.next());
        }
        this._length_update_needed = true;
        this.setChanged();
        this.notifyObservers(new Message(M_MARKER_GEO_CHANGED, null));
    }

    public double get_length() {
        if (this._length_update_needed) {
            this._length = 0.0;
            int i = 0;
            while (i < this._points.length - 1) {
                Vector3d tmp = new Vector3d((Tuple3d)this._points[i]);
                tmp.sub((Tuple3d)this._points[i + 1]);
                this._length += tmp.lengthSquared();
                ++i;
            }
            this._length = Math.sqrt(this._length);
            this._length_update_needed = false;
        }
        return this._length;
    }
}

