/*
 * Decompiled with CFR 0.152.
 */
package misc.geomarker;

import java.awt.Color;
import javax.vecmath.Color3f;
import main.Message;
import misc.MutableColor;
import misc.messages.YObservable;

public abstract class GeoMarker
extends YObservable {
    public static int M_MARKER_LABEL_CHANGED = Message.register_message("Marker NameChanged");
    public static int M_MARKER_COL_CHANGED = Message.register_message("Marker ColorChanged");
    public static int M_MARKER_GEO_CHANGED = Message.register_message("Marker GeometryChanged");
    protected String _label;
    protected MutableColor _color;

    protected GeoMarker(String label) {
        this._label = label;
        this._color = new MutableColor(255, 255, 255, 255);
    }

    protected GeoMarker(String label, Color color) {
        this._label = label;
        this._color = new MutableColor(color);
    }

    public String get_label() {
        return this._label;
    }

    public void set_label(String label) {
        String old_label = label;
        this._label = label;
        this.setChanged();
        this.notifyObservers(new Message(M_MARKER_LABEL_CHANGED, old_label));
    }

    public Color get_color() {
        return new Color(this._color.getRed(), this._color.getGreen(), this._color.getBlue(), this._color.getAlpha());
    }

    public Color3f get_color3f() {
        return new Color3f((float)this._color.getRed(), (float)this._color.getGreen(), (float)this._color.getBlue());
    }

    public void set_color(Color color) {
        this._color.set(color);
        this.setChanged();
        this.notifyObservers(new Message(M_MARKER_COL_CHANGED, null));
    }

    public static enum KoordType {
        GRID,
        REAL_WORLD;

    }
}

