/*
 * Decompiled with CFR 0.152.
 */
package misc.geomarker.editor;

import gui.GeoMarkerSelector;
import gui.LazyInitComponent;
import gui.MyToolbar;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.vecmath.Point3d;
import jgridmaker.GMPanel;
import main.ImageStack;
import main.MasterControl;
import misc.geomarker.GMPoint;
import misc.geomarker.GMPolyCurve;
import misc.geomarker.GMSphere;
import misc.geomarker.GeoMarker;
import misc.geomarker.editor.GMPointEditor;
import misc.geomarker.editor.GeoMarkerEditorPanel;
import misc.geomarker.editor.GeoMarkerInfoPanel;

public class GeoMarkerEditor
extends GMPanel
implements LazyInitComponent {
    private GeoMarkerInfoPanel _info_panel = null;
    private Class<?> _gm_type;
    private GeoMarkerEditorPanel _gm_editor = null;

    public GeoMarkerEditor(Class<?> gm_type) {
        this._gm_type = gm_type;
    }

    @Override
    public void create_gui() {
        this._info_panel = new GeoMarkerInfoPanel();
        final GeoMarkerSelector gm_sel = new GeoMarkerSelector(this._gm_type);
        gm_sel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String property = propertyChangeEvent.getPropertyName();
                if (GeoMarkerSelector.GM_SELECTION_CHANGED.equals(property)) {
                    GeoMarker gm = gm_sel.get_selected_marker();
                    GeoMarkerEditor.this._info_panel.show_info(gm);
                    GeoMarkerEditor.this._gm_editor.set_marker(gm);
                }
            }
        });
        MyToolbar tool_bar = new MyToolbar();
        tool_bar.setOrientation(0);
        AbstractAction new_marker = new AbstractAction("New", new ImageIcon("resources/gfx/seg_new.png")){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ImageStack is = MasterControl.get_is();
                GMPoint pm = new GMPoint("point 0", new Point3d(10.0, 10.0, 10.0));
                pm.set_color(new Color(255, 0, 255));
                is.add_marker(pm);
                pm = new GMPoint("point 1", new Point3d(30.0, 20.0, 20.0));
                pm.set_color(new Color(0, 255, 255));
                is.add_marker(pm);
                pm = new GMPoint("point 2", new Point3d(50.0, 20.0, 20.0));
                pm.set_color(new Color(255, 255, 0));
                is.add_marker(pm);
                GMPolyCurve lm = new GMPolyCurve("line 0", 2);
                lm.set_point(0, new Point3d(40.0, 40.0, 40.0));
                lm.set_point(1, new Point3d(80.0, 80.0, 70.0));
                lm.set_color(new Color(255, 255, 255));
                is.add_marker(lm);
                lm = new GMPolyCurve("line 1", 3);
                lm.set_point(0, new Point3d(140.0, 140.0, 60.0));
                lm.set_point(1, new Point3d(180.0, 180.0, 30.0));
                lm.set_point(2, new Point3d(120.0, 130.0, 30.0));
                lm.set_color(new Color(0, 255, 0));
                is.add_marker(lm);
                GMSphere sm = new GMSphere("sphere", Color.CYAN, new Point3d(100.0, 20.0, 20.0), 20.0);
                is.add_marker(sm);
            }
        };
        tool_bar.add_button(new_marker, "New Marker");
        if (this._gm_type == GMPoint.class) {
            this._gm_editor = new GMPointEditor();
        }
        this.add("gm_sel", gm_sel);
        this.add("info_panel", this._info_panel);
        this.add("buttons", tool_bar);
        this.add("gm_editor", (JComponent)((Object)this._gm_editor));
        this.set_layout("<table width='100%' height='100%'>  <colgroup>    <col width='1%' />    <col width='1%' />    <col width='98%' />  </colgroup>  <tr height='1%'>    <td>Select Marker</td>    <td>Info</td>    <td>Edit</td>  </tr><tr height='98%'>    <td fill='both'>::gm_sel::</td>    <td rowspan='2' fill='both'>::info_panel::</td>    <td>::gm_editor::</td>  </tr><tr height='1%'>    <td>::buttons::</td>  </tr></table>");
        this._gm_editor.setEnabled(false);
    }

    @Override
    public boolean gui_created() {
        return this._info_panel != null;
    }
}

