/*
 * Decompiled with CFR 0.152.
 */
package misc.geomarker.editor;

import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.JTextArea;
import javax.swing.text.DefaultCaret;
import misc.geomarker.GMPlane;
import misc.geomarker.GMPoint;
import misc.geomarker.GMPolyCurve;
import misc.geomarker.GMSphere;
import misc.geomarker.GeoMarker;

public class GeoMarkerInfoPanel
extends JTextArea {
    public GeoMarkerInfoPanel() {
        this.setEditable(false);
        this.setOpaque(false);
        this.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.gray));
        this.setColumns(20);
        DefaultCaret caret = (DefaultCaret)this.getCaret();
        caret.setUpdatePolicy(2);
    }

    public void show_info(GeoMarker gm) {
        String text = String.valueOf(gm.get_label()) + "\n\n";
        if (gm.getClass() == GMPoint.class) {
            GMPoint gmp = (GMPoint)gm;
            text = String.valueOf(text) + "Type = Point Marker\n";
            text = String.valueOf(text) + "Coordinates = " + gmp.get_point() + "\n";
        } else if (gm.getClass() == GMPolyCurve.class) {
            GMPolyCurve gmpc = (GMPolyCurve)gm;
            text = String.valueOf(text) + "Type = PolyCurve Marker\n";
            text = String.valueOf(text) + "Length = " + gmpc.get_length() + "\n";
            text = String.valueOf(text) + "Points = " + gmpc.get_points().length + "\n";
        } else if (gm.getClass() == GMPlane.class) {
            GMPlane gmp = (GMPlane)gm;
            text = String.valueOf(text) + "Type = Plane Marker\n";
            text = String.valueOf(text) + "Footpoint = " + gmp.get_a() + "\n";
        } else if (gm.getClass() == GMSphere.class) {
            GMSphere gms = (GMSphere)gm;
            text = String.valueOf(text) + "Type = Sphere Marker\n";
            text = String.valueOf(text) + "Center = " + gms.get_center() + "\n";
            text = String.valueOf(text) + "Radius = " + gms.get_radius() + "\n";
            text = String.valueOf(text) + "Volume = " + Math.PI * 4 * Math.pow(gms.get_radius(), 3.0) / 3.0 + "\n";
        }
        this.setText(text);
        this.validate();
        this.update(this.getGraphics());
    }
}

