/*
 * Decompiled with CFR 0.152.
 */
package misc.grid;

import java.util.Arrays;
import main.MasterControl;
import misc.grid.AbstractRegularGrid3i;
import misc.grid.MutableRegularGrid3i;
import misc.grid.RegularGrid3i;

public abstract class AbstractMutableRegularGrid3i
extends AbstractRegularGrid3i
implements MutableRegularGrid3i {
    protected final int[] _data = new int[this.get_data_size()];

    public AbstractMutableRegularGrid3i(int dim_x, int dim_y, int dim_z, int max_voxel_value) {
        super(dim_x, dim_y, dim_z, max_voxel_value);
    }

    public AbstractMutableRegularGrid3i(int dim_x, int dim_y, int dim_z) {
        super(dim_x, dim_y, dim_z, MasterControl.get_is().get_voxel_value_range() - 1);
    }

    public AbstractMutableRegularGrid3i(RegularGrid3i grid) {
        this(grid.get_dim_x(), grid.get_dim_y(), grid.get_dim_z(), grid.get_max_voxel_value());
        if (grid.getClass() == this.getClass() && grid instanceof AbstractMutableRegularGrid3i) {
            System.arraycopy(((AbstractMutableRegularGrid3i)grid).get_data(), 0, this._data, 0, this._data.length);
        } else {
            int voxel_num = this.get_number_of_voxels();
            int i = 0;
            while (i < voxel_num) {
                int value_at_i = grid.get(i);
                this.set(i, value_at_i);
                ++i;
            }
        }
    }

    protected abstract int get_data_size();

    @Override
    public void clear() {
        Arrays.fill(this._data, 0);
    }

    @Override
    public abstract void set(int var1, int var2);

    @Override
    public void set(int x, int y, int z, int value) {
        int index_of_xyz = this.coordinates_to_index(x, y, z);
        this.set(index_of_xyz, value);
    }

    @Override
    public abstract void add(int var1, int var2);

    @Override
    public void add(int x, int y, int z, int inc) {
        int index = this.coordinates_to_index(x, y, z);
        this.add(index, inc);
    }

    int[] get_data() {
        return this._data;
    }
}

