/*
 * Decompiled with CFR 0.152.
 */
package misc.grid;

import misc.grid.RegularGrid3i;

public abstract class AbstractRegularGrid3i
implements RegularGrid3i {
    protected final int _dim_x;
    protected final int _dim_y;
    protected final int _dim_z;
    protected final int _offset_for_y_plus_1;
    protected final int _offset_for_z_plus_1;
    protected final int _number_of_voxels;
    protected final int _max_voxel_value;

    public AbstractRegularGrid3i(int dim_x, int dim_y, int dim_z, int max_voxel_value) {
        this._dim_x = dim_x;
        this._dim_y = dim_y;
        this._dim_z = dim_z;
        this._offset_for_y_plus_1 = dim_x;
        this._offset_for_z_plus_1 = dim_x * dim_y;
        this._number_of_voxels = dim_x * dim_y * dim_z;
        this._max_voxel_value = max_voxel_value;
    }

    @Override
    public int get_dim_x() {
        return this._dim_x;
    }

    @Override
    public int get_dim_y() {
        return this._dim_y;
    }

    @Override
    public int get_dim_z() {
        return this._dim_z;
    }

    @Override
    public int get_number_of_voxels() {
        return this._number_of_voxels;
    }

    @Override
    public int get(int x, int y, int z) {
        int index_of_xyz = this.coordinates_to_index(x, y, z);
        return this.get(index_of_xyz);
    }

    @Override
    public abstract int get(int var1);

    @Override
    public int coordinates_to_index(int x, int y, int z) {
        return z * this._offset_for_z_plus_1 + y * this._offset_for_y_plus_1 + x;
    }

    @Override
    public int get_img_size() {
        return this._dim_x * this._dim_y;
    }

    @Override
    public int get_index_offset_for_y_plus_1() {
        return this._offset_for_y_plus_1;
    }

    @Override
    public int get_index_offset_for_z_plus_1() {
        return this._offset_for_z_plus_1;
    }

    @Override
    public int get_max_voxel_value() {
        return this._max_voxel_value;
    }
}

