/*
 * Decompiled with CFR 0.152.
 */
package misc.grid;

import misc.Voxel;
import misc.grid.AbstractMutableRegularGrid3i;
import misc.grid.N26Iterator;
import misc.grid.N6Iterator;

public class BitCube
extends AbstractMutableRegularGrid3i {
    public static final int MIRROR_X = 0;
    public static final int MIRROR_Y = 1;
    public static final int MIRROR_Z = 2;
    public static final int BITS = 32;
    public static final int SHIFT = 5;
    public final int[] _bb_min = new int[3];
    public final int[] _bb_max = new int[3];
    private final int _ints_per_row;
    private final int _ints_per_img;
    private final int _error_per_row;

    public BitCube(int dim_x, int dim_y, int dim_z) {
        super(dim_x, dim_y, dim_z, 1);
        this.clear_bounding_box();
        if (this._dim_x % 32 == 0) {
            this._ints_per_row = dim_x / 32;
            this._error_per_row = 0;
        } else {
            this._ints_per_row = dim_x / 32 + 1;
            this._error_per_row = 32 - dim_x % 32;
        }
        this._ints_per_img = dim_y * this._ints_per_row;
    }

    private void clear_bounding_box() {
        this._bb_min[2] = Integer.MAX_VALUE;
        this._bb_min[1] = Integer.MAX_VALUE;
        this._bb_min[0] = Integer.MAX_VALUE;
        this._bb_max[2] = Integer.MIN_VALUE;
        this._bb_max[1] = Integer.MIN_VALUE;
        this._bb_max[0] = Integer.MIN_VALUE;
    }

    @Override
    protected int get_data_size() {
        int ints_per_row = this._dim_x % 32 == 0 ? this._dim_x / 32 : this._dim_x / 32 + 1;
        int ints_per_img = this._dim_y * ints_per_row;
        return ints_per_img * this._dim_z;
    }

    public BitCube(BitCube bc) {
        this(bc._dim_x, bc._dim_y, bc._dim_z);
        System.arraycopy(bc._bb_min, 0, this._bb_min, 0, this._bb_min.length);
        System.arraycopy(bc._bb_max, 0, this._bb_max, 0, this._bb_max.length);
        System.arraycopy(bc._data, 0, this._data, 0, this._data.length);
    }

    public int get_ints_per_row() {
        return this._ints_per_row;
    }

    public int get_ints_per_img() {
        return this._ints_per_img;
    }

    public boolean getXYZ(int x, int y, int z) {
        int bitnum;
        int intnum = this.coordinates_to_data_index(x, y, z);
        return (this._data[intnum] & 1 << (bitnum = this.coordinates_to_bit_number(x))) != 0;
    }

    private int coordinates_to_data_index(int x, int y, int z) {
        return z * this._ints_per_img + y * this._ints_per_row + (x >>> 5);
    }

    private int coordinates_to_bit_number(int x) {
        return x % 32;
    }

    public void setXYZ(int x, int y, int z, boolean value) {
        int intnum = this.coordinates_to_data_index(x, y, z);
        int bitnum = this.coordinates_to_bit_number(x);
        if (value) {
            int n = intnum;
            this._data[n] = this._data[n] | 1 << bitnum;
        } else {
            int n = intnum;
            this._data[n] = this._data[n] & ~(1 << bitnum);
        }
    }

    public final void copy_data_from(BitCube bc) {
        int i = 0;
        while (i < this._data.length) {
            this._data[i] = bc._data[i];
            ++i;
        }
        i = 0;
        while (i < 3) {
            this._bb_min[i] = bc._bb_min[i];
            this._bb_max[i] = bc._bb_max[i];
            ++i;
        }
    }

    public final void copy_data_from(BitCube bc, int tx, int ty, int tz) {
        int src_z = 0;
        while (src_z < bc.get_dim_z()) {
            int src_y = 0;
            while (src_y < bc.get_dim_y()) {
                int src_pos = src_z * bc._ints_per_img + src_y * bc._ints_per_row;
                int tgt_pos = src_z * this._ints_per_img + src_y * this._ints_per_row;
                int i = 0;
                while (i < bc.get_ints_per_row()) {
                    this._data[tgt_pos + i] = bc._data[src_pos + i];
                    ++i;
                }
                ++src_y;
            }
            ++src_z;
        }
        this.calc_bb();
        this.translate(tx, ty, tz);
    }

    public void invert(int[] bb_min, int[] bb_max) {
        if (this._dim_x <= 32) {
            int z = bb_min[2];
            while (z <= bb_max[2]) {
                int y = bb_min[1];
                while (y <= bb_max[1]) {
                    int x = bb_min[0];
                    while (x <= bb_max[0]) {
                        if (this.getXYZ(x, y, z)) {
                            this.setXYZ(x, y, z, false);
                        } else {
                            this.setXYZ(x, y, z, true);
                        }
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
        } else {
            int row_start = bb_min[0] / 32 + 1;
            int row_end = bb_max[0] / 32;
            int z = bb_min[2];
            while (z <= bb_max[2]) {
                int y = bb_min[1];
                while (y <= bb_max[1]) {
                    int row = z * this._ints_per_img + y * this._ints_per_row;
                    int x = bb_min[0];
                    while (x < row_start * 32) {
                        if (this.getXYZ(x, y, z)) {
                            this.setXYZ(x, y, z, false);
                        } else {
                            this.setXYZ(x, y, z, true);
                        }
                        ++x;
                    }
                    int i = row + row_start;
                    while (i < row + row_end) {
                        this._data[i] = ~this._data[i];
                        ++i;
                    }
                    x = row_end * 32;
                    while (x <= bb_max[0]) {
                        if (this.getXYZ(x, y, z)) {
                            this.setXYZ(x, y, z, false);
                        } else {
                            this.setXYZ(x, y, z, true);
                        }
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
        }
        this.calc_bb();
    }

    public final void invert() {
        int[] bb_min = new int[3];
        int[] bb_max = new int[]{this._dim_x - 1, this._dim_y - 1, this._dim_z - 1};
        this.invert(bb_min, bb_max);
    }

    @Override
    public final void clear() {
        super.clear();
        this.clear_bounding_box();
    }

    public void add(BitCube bc) {
        int i = 0;
        while (i < this._data.length) {
            int n = i;
            this._data[n] = this._data[n] | bc._data[i];
            ++i;
        }
    }

    public void del(BitCube bc) {
        int i = 0;
        while (i < this._data.length) {
            int n = i;
            this._data[n] = this._data[n] & ~bc._data[i];
            ++i;
        }
    }

    public void translate(int tx, int ty, int tz) {
        int[] new_data = new int[this._data.length];
        if (tx >= 0) {
            int txi = tx >> 5;
            int txb = this.coordinates_to_bit_number(tx);
            int mask = Integer.reverse((1 << txb) - 1);
            int z = this._bb_min[2];
            while (z <= this._bb_max[2]) {
                int y = this._bb_min[1];
                while (y <= this._bb_max[1]) {
                    int pos_o = z * this._ints_per_img + y * this._ints_per_row;
                    int pos_t = (z + tz) * this._ints_per_img + (y + ty) * this._ints_per_row;
                    int i = 0;
                    while (i < this._ints_per_row - 1) {
                        int n = pos_t + i + txi;
                        new_data[n] = new_data[n] | this._data[pos_o + i] << txb;
                        int n2 = pos_t + i + txi + 1;
                        new_data[n2] = new_data[n2] | (this._data[pos_o + i] & mask) >>> 32 - txb;
                        ++i;
                    }
                    int n = pos_t + this._ints_per_row + txi - 1;
                    new_data[n] = new_data[n] | this._data[pos_o + this._ints_per_row - 1] << txb;
                    ++y;
                }
                ++z;
            }
        } else {
            tx = -tx;
            int txi = tx >> 5;
            int txb = this.coordinates_to_bit_number(tx);
            int mask = (1 << txb) - 1;
            int z = this._bb_min[2];
            while (z <= this._bb_max[2]) {
                int y = this._bb_min[1];
                while (y <= this._bb_max[1]) {
                    int pos_o = z * this._ints_per_img + y * this._ints_per_row;
                    int pos_t = (z + tz) * this._ints_per_img + (y + ty) * this._ints_per_row;
                    new_data[pos_t - txi] = this._data[pos_o] >>> txb;
                    int i = 1;
                    while (i < this._ints_per_row) {
                        int n = pos_t + i - txi;
                        new_data[n] = new_data[n] | this._data[pos_o + i] >>> txb;
                        int n3 = pos_t + i - txi - 1;
                        new_data[n3] = new_data[n3] | (this._data[pos_o + i] & mask) << 32 - txb;
                        ++i;
                    }
                    ++y;
                }
                ++z;
            }
            tx = -tx;
        }
        System.arraycopy(new_data, 0, this._data, 0, this._data.length);
        this._bb_min[0] = this._bb_min[0] + tx;
        this._bb_min[1] = this._bb_min[1] + ty;
        this._bb_min[2] = this._bb_min[2] + tz;
        this._bb_max[0] = this._bb_max[0] + tx;
        this._bb_max[1] = this._bb_max[1] + ty;
        this._bb_max[2] = this._bb_max[2] + tz;
    }

    public void mirror(int mode) {
        if (mode == 0) {
            int z = this._bb_min[2];
            while (z <= this._bb_max[2]) {
                int y = this._bb_min[1];
                while (y <= this._bb_max[1]) {
                    int x = 0;
                    while (x < this._dim_x / 2) {
                        boolean tmp = this.getXYZ(x, y, z);
                        this.setXYZ(x, y, z, this.getXYZ(this._dim_x - x - 1, y, z));
                        this.setXYZ(this._dim_x - x - 1, y, z, tmp);
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
            int new_x_min = this._dim_x - this._bb_max[0] - 1;
            this._bb_max[0] = this._dim_x - 1 - this._bb_min[0] - 1;
            this._bb_min[0] = new_x_min;
        } else if (mode == 1) {
            int z = this._bb_min[2];
            while (z <= this._bb_max[2]) {
                int i = 0;
                while (i < this._ints_per_row) {
                    int pos1 = (z + 0) * this._ints_per_img + i;
                    int pos2 = (z + 1) * this._ints_per_img + i;
                    int y = 0;
                    while (y < this._dim_y / 2) {
                        int tmp = this._data[pos1];
                        this._data[pos1] = this._data[pos2 -= this._ints_per_row];
                        this._data[pos2] = tmp;
                        pos1 += this._ints_per_row;
                        ++y;
                    }
                    ++i;
                }
                ++z;
            }
            int new_y_min = this._dim_y - this._bb_max[1] - 1;
            this._bb_max[1] = this._dim_y - 1 - this._bb_min[1] - 1;
            this._bb_min[1] = new_y_min;
        } else {
            int z = 0;
            while (z < this._dim_z / 2) {
                int pos1 = z * this._ints_per_img + this._bb_min[1] * this._ints_per_row;
                int pos2 = this._data.length - (z + 1) * this._ints_per_img + this._bb_min[1] * this._ints_per_row;
                int y = this._bb_min[1];
                while (y <= this._bb_max[1]) {
                    int i = 0;
                    while (i < this._ints_per_row) {
                        int tmp = this._data[pos1 + i];
                        this._data[pos1 + i] = this._data[pos2 + i];
                        this._data[pos2 + i] = tmp;
                        ++i;
                    }
                    pos1 += this._ints_per_row;
                    pos2 += this._ints_per_row;
                    ++y;
                }
                ++z;
            }
            int new_z_min = this._dim_z - this._bb_max[2] - 1;
            this._bb_max[2] = this._dim_z - 1 - this._bb_min[2] - 1;
            this._bb_min[2] = new_z_min;
        }
    }

    public void clear_plane(int mode, int num) {
        if (mode == 0) {
            int y = 0;
            while (y < this._dim_y) {
                int x = 0;
                while (x < this._dim_x) {
                    this.setXYZ(x, y, num, false);
                    ++x;
                }
                ++y;
            }
        } else if (mode == 1) {
            int y = 0;
            while (y < this._dim_y) {
                int z = 0;
                while (z < this._dim_z) {
                    this.setXYZ(num, y, z, false);
                    ++z;
                }
                ++y;
            }
        } else {
            int z = 0;
            while (z < this._dim_z) {
                int x = 0;
                while (x < this._dim_x) {
                    this.setXYZ(x, num, z, false);
                    ++x;
                }
                ++z;
            }
        }
    }

    public void calc_bb(int bbmin_x, int bbmin_y, int bbmin_z, int bbmax_x, int bbmax_y, int bbmax_z) {
        if (this._bb_min[0] >= bbmin_x || this._bb_min[1] >= bbmin_y || this._bb_min[2] >= bbmin_z || this._bb_max[0] <= bbmax_x || this._bb_max[1] <= bbmax_y || this._bb_max[2] <= bbmax_z) {
            this.calc_bb();
        }
    }

    public void calc_bb() {
        int y;
        int ix;
        int z;
        this.clear_bounding_box();
        int intnum = 0;
        while (intnum < this._data.length) {
            if (this._data[intnum] != 0) {
                this._bb_min[2] = intnum / this._ints_per_img;
                break;
            }
            ++intnum;
        }
        if (this._bb_min[2] == Integer.MAX_VALUE) {
            return;
        }
        intnum = this._data.length - 1;
        while (intnum >= this._bb_min[2]) {
            if (this._data[intnum] != 0) {
                this._bb_max[2] = intnum / this._ints_per_img;
                break;
            }
            --intnum;
        }
        boolean gotcha = false;
        int y2 = 0;
        while (y2 < this._dim_y) {
            z = this._bb_min[2];
            while (z <= this._bb_max[2] && !gotcha) {
                intnum = z * this._ints_per_img + y2 * this._ints_per_row;
                ix = 0;
                while (ix < this._ints_per_row && !gotcha) {
                    if (this._data[intnum + ix] != 0) {
                        this._bb_min[1] = y2;
                        gotcha = true;
                    }
                    ++ix;
                }
                ++z;
            }
            ++y2;
        }
        gotcha = false;
        y2 = this._dim_y - 1;
        while (y2 >= this._bb_min[1]) {
            z = this._bb_min[2];
            while (z <= this._bb_max[2] && !gotcha) {
                intnum = z * this._ints_per_img + y2 * this._ints_per_row;
                ix = 0;
                while (ix < this._ints_per_row && !gotcha) {
                    if (this._data[intnum + ix] != 0) {
                        this._bb_max[1] = y2;
                        gotcha = true;
                    }
                    ++ix;
                }
                ++z;
            }
            --y2;
        }
        gotcha = false;
        int ix2 = 0;
        while (ix2 < this._ints_per_row && !gotcha) {
            z = this._bb_min[2];
            while (z <= this._bb_max[2]) {
                intnum = z * this._ints_per_img + this._bb_min[1] * this._ints_per_row + ix2;
                y = this._bb_min[1];
                while (y <= this._bb_max[1]) {
                    if (this._data[intnum] != 0) {
                        int min_x = Integer.numberOfTrailingZeros(this._data[intnum]);
                        if (min_x < this._bb_min[0]) {
                            this._bb_min[0] = min_x;
                        }
                        gotcha = true;
                    }
                    intnum += this._ints_per_row;
                    ++y;
                }
                ++z;
            }
            if (gotcha) {
                this._bb_min[0] = this._bb_min[0] + ix2 * 32;
            }
            ++ix2;
        }
        gotcha = false;
        ix2 = this._ints_per_row - 1;
        while (ix2 >= 0 && !gotcha) {
            z = this._bb_min[2];
            while (z <= this._bb_max[2]) {
                intnum = z * this._ints_per_img + this._bb_min[1] * this._ints_per_row + ix2;
                y = this._bb_min[1];
                while (y <= this._bb_max[1]) {
                    if (this._data[intnum] != 0) {
                        int max_x = 32 - Integer.numberOfLeadingZeros(this._data[intnum]);
                        if (max_x > this._bb_max[0]) {
                            this._bb_max[0] = max_x;
                        }
                        gotcha = true;
                    }
                    intnum += this._ints_per_row;
                    ++y;
                }
                ++z;
            }
            if (gotcha) {
                this._bb_max[0] = this._bb_max[0] + (ix2 * 32 - 1);
            }
            --ix2;
        }
        if (this._bb_max[0] > this._dim_x - 1) {
            this._bb_max[0] = this._dim_x - 1 - 1;
        }
    }

    public boolean has_unset_n6_neighbour(int x, int y, int z) {
        N6Iterator _n6i = new N6Iterator(this);
        _n6i.init(x, y, z);
        Voxel v = new Voxel();
        while (_n6i.next(v)) {
            if (this.getXYZ(v._x, v._y, v._z)) continue;
            return true;
        }
        return false;
    }

    public boolean has_unset_n26_neighbour(int x, int y, int z) {
        N26Iterator _n26i = new N26Iterator(this);
        _n26i.init(x, y, z);
        Voxel v = new Voxel();
        while (_n26i.next(v)) {
            if (this.getXYZ(v._x, v._y, v._z)) continue;
            return true;
        }
        return false;
    }

    public boolean has_set_n6_neighbour(int x, int y, int z) {
        N6Iterator _n6i = new N6Iterator(this);
        _n6i.init(new Voxel(x, y, z));
        Voxel v = new Voxel();
        while (_n6i.next(v)) {
            if (!this.getXYZ(v._x, v._y, v._z)) continue;
            return true;
        }
        return false;
    }

    public boolean has_set_n26_neighbour(int x, int y, int z) {
        N26Iterator _n26i = new N26Iterator(this);
        _n26i.init(new Voxel(x, y, z));
        Voxel v = new Voxel();
        while (_n26i.next(v)) {
            if (!this.getXYZ(v._x, v._y, v._z)) continue;
            return true;
        }
        return false;
    }

    public void shrink(int[] bb_min, int[] bb_max) {
        BitCube new_bc = new BitCube(this);
        int[] my_bb_min = new int[3];
        int[] my_bb_max = new int[3];
        my_bb_min[0] = bb_min[0] > this._bb_min[0] ? bb_min[0] : this._bb_min[0];
        my_bb_min[1] = bb_min[1] > this._bb_min[1] ? bb_min[1] : this._bb_min[1];
        my_bb_min[2] = bb_min[2] > this._bb_min[2] ? bb_min[2] : this._bb_min[2];
        my_bb_max[0] = bb_max[0] < this._bb_max[0] ? bb_max[0] : this._bb_max[0];
        my_bb_max[1] = bb_max[1] < this._bb_max[1] ? bb_max[1] : this._bb_max[1];
        my_bb_max[2] = bb_max[2] < this._bb_max[2] ? bb_max[2] : this._bb_max[2];
        int start = my_bb_min[2] * this._ints_per_img;
        int end = my_bb_max[2] * this._ints_per_img;
        if (start > this._ints_per_img) {
            start -= this._ints_per_img;
        }
        if (end < this._data.length - this._ints_per_img) {
            end += this._ints_per_img;
        }
        if (start < 0) {
            return;
        }
        int i = start;
        while (i < end) {
            if (this._data[i] != 0) {
                int z = i / this._ints_per_img;
                int y = (i - z * this._ints_per_img) / this._ints_per_row;
                if (y > 0 && y < this._dim_y - 1 && z > 0 && z < this._dim_z - 1) {
                    if ((new_bc._data[i] & 1) != 0 && ((new_bc._data[i - 1] & Integer.MIN_VALUE) == 0 || (new_bc._data[i] & 2) == 0 || (new_bc._data[i - this._ints_per_row] & 1) == 0 || (new_bc._data[i + this._ints_per_row] & 1) == 0 || (new_bc._data[i - this._ints_per_img] & 1) == 0 || (new_bc._data[i + this._ints_per_img] & 1) == 0)) {
                        int n = i;
                        this._data[n] = this._data[n] & 0xFFFFFFFE;
                    }
                    int bx = 1;
                    while (bx < 31) {
                        if ((new_bc._data[i] & 1 << bx) != 0 && ((new_bc._data[i] & (1 << bx - 1 | 1 << bx + 1)) == 0 || (new_bc._data[i - this._ints_per_row] & 1 << bx) == 0 || (new_bc._data[i + this._ints_per_row] & 1 << bx) == 0 || (new_bc._data[i - this._ints_per_img] & 1 << bx) == 0 || (new_bc._data[i + this._ints_per_img] & 1 << bx) == 0)) {
                            int n = i;
                            this._data[n] = this._data[n] & ~(1 << bx);
                        }
                        ++bx;
                    }
                    if ((new_bc._data[i] & Integer.MIN_VALUE) != 0 && ((new_bc._data[i] & 0x40000000) == 0 || (new_bc._data[i + 1] & 1) == 0 || (new_bc._data[i - this._ints_per_row] & Integer.MIN_VALUE) == 0 || (new_bc._data[i + this._ints_per_row] & Integer.MIN_VALUE) == 0 || (new_bc._data[i - this._ints_per_img] & Integer.MIN_VALUE) == 0 || (new_bc._data[i + this._ints_per_img] & Integer.MIN_VALUE) == 0)) {
                        int n = i;
                        this._data[n] = this._data[n] & Integer.MAX_VALUE;
                    }
                } else {
                    int start_x;
                    int x = start_x = (i - z * this._ints_per_img - y * this._ints_per_row) * 32;
                    while (x < start_x + 32) {
                        if (new_bc.getXYZ(x, y, z) && new_bc.has_unset_n6_neighbour(x, y, z)) {
                            this.setXYZ(x, y, z, true);
                        }
                        ++x;
                    }
                }
            }
            ++i;
        }
        this.calc_bb(my_bb_min[0], my_bb_min[1], my_bb_min[2], my_bb_max[0], my_bb_max[1], my_bb_max[2]);
    }

    public void shrink() {
        int[] bb_min = new int[3];
        int[] bb_max = new int[]{this._dim_x - 1, this._dim_y - 1, this._dim_z - 1};
        this.shrink(bb_min, bb_max);
    }

    public void grow(int[] bb_min, int[] bb_max) {
        BitCube new_bc = new BitCube(this);
        int[] my_bb_min = new int[3];
        int[] my_bb_max = new int[3];
        my_bb_min[0] = bb_min[0] > this._bb_min[0] ? bb_min[0] : this._bb_min[0];
        my_bb_min[1] = bb_min[1] > this._bb_min[1] ? bb_min[1] : this._bb_min[1];
        my_bb_min[2] = bb_min[2] > this._bb_min[2] ? bb_min[2] : this._bb_min[2];
        my_bb_max[0] = bb_max[0] < this._bb_max[0] ? bb_max[0] : this._bb_max[0];
        my_bb_max[1] = bb_max[1] < this._bb_max[1] ? bb_max[1] : this._bb_max[1];
        my_bb_max[2] = bb_max[2] < this._bb_max[2] ? bb_max[2] : this._bb_max[2];
        int start = my_bb_min[2] * this._ints_per_img;
        int end = my_bb_max[2] * this._ints_per_img;
        if (start > this._ints_per_img) {
            start -= this._ints_per_img;
        }
        if (end < this._data.length - this._ints_per_img) {
            end += this._ints_per_img;
        }
        if (start < 0) {
            return;
        }
        int i = start;
        while (i < end) {
            int z;
            int y;
            if (this._data[i] != 0 && (y = (i - (z = i / this._ints_per_img) * this._ints_per_img) / this._ints_per_row) > 0 && y < this._dim_y - 1 && z > 0 && z < this._dim_z - 1) {
                if ((new_bc._data[i] & 1) != 0) {
                    int n = i - 1;
                    this._data[n] = this._data[n] | Integer.MIN_VALUE;
                    int n2 = i;
                    this._data[n2] = this._data[n2] | 2;
                    int n3 = i - this._ints_per_row;
                    this._data[n3] = this._data[n3] | 1;
                    int n4 = i + this._ints_per_row;
                    this._data[n4] = this._data[n4] | 1;
                    int n5 = i - this._ints_per_img;
                    this._data[n5] = this._data[n5] | 1;
                    int n6 = i + this._ints_per_img;
                    this._data[n6] = this._data[n6] | 1;
                }
                int bx = 1;
                while (bx < 31) {
                    if ((new_bc._data[i] & 1 << bx) != 0) {
                        int n = i;
                        this._data[n] = this._data[n] | 1 << bx - 1;
                        int n7 = i;
                        this._data[n7] = this._data[n7] | 1 << bx + 1;
                        int n8 = i - this._ints_per_row;
                        this._data[n8] = this._data[n8] | 1 << bx;
                        int n9 = i + this._ints_per_row;
                        this._data[n9] = this._data[n9] | 1 << bx;
                        int n10 = i - this._ints_per_img;
                        this._data[n10] = this._data[n10] | 1 << bx;
                        int n11 = i + this._ints_per_img;
                        this._data[n11] = this._data[n11] | 1 << bx;
                    }
                    ++bx;
                }
                if ((new_bc._data[i] & Integer.MIN_VALUE) != 0) {
                    int n = i;
                    this._data[n] = this._data[n] | 0x40000000;
                    int n12 = i + 1;
                    this._data[n12] = this._data[n12] | 1;
                    int n13 = i - this._ints_per_row;
                    this._data[n13] = this._data[n13] | Integer.MIN_VALUE;
                    int n14 = i + this._ints_per_row;
                    this._data[n14] = this._data[n14] | Integer.MIN_VALUE;
                    int n15 = i - this._ints_per_img;
                    this._data[n15] = this._data[n15] | Integer.MIN_VALUE;
                    int n16 = i + this._ints_per_img;
                    this._data[n16] = this._data[n16] | Integer.MIN_VALUE;
                }
            }
            ++i;
        }
        if (this._bb_min[0] > 0) {
            this._bb_min[0] = this._bb_min[0] - 1;
        }
        if (this._bb_min[1] > 0) {
            this._bb_min[1] = this._bb_min[1] - 1;
        }
        if (this._bb_min[2] > 0) {
            this._bb_min[2] = this._bb_min[2] - 1;
        }
        if (this._bb_max[0] < this._dim_x - 1) {
            this._bb_max[0] = this._bb_max[0] + 1;
        }
        if (this._bb_max[1] < this._dim_y - 1) {
            this._bb_max[1] = this._bb_max[1] + 1;
        }
        if (this._bb_max[2] < this._dim_z - 1) {
            this._bb_max[2] = this._bb_max[2] + 1;
        }
    }

    public void grow() {
        int[] bb_min = new int[3];
        int[] bb_max = new int[]{this._dim_x - 1, this._dim_y - 1, this._dim_z - 1};
        this.grow(bb_min, bb_max);
    }

    public String create_str_representation() {
        StringBuilder result = new StringBuilder();
        int z = 0;
        while (z < this._dim_z) {
            int y = 0;
            while (y < this._dim_y) {
                int x = 0;
                while (x < this._dim_x) {
                    result.append(this.getXYZ(x, y, z) ? "1" : "0");
                    ++x;
                }
                result.append("\n");
                ++y;
            }
            result.append("\n");
            ++z;
        }
        return result.toString();
    }

    public int count_voxels() {
        int gotcha_count = 0;
        int i = 0;
        while (i < this._data.length) {
            gotcha_count += Integer.bitCount(this._data[i]);
            ++i;
        }
        return gotcha_count;
    }

    @Override
    public void add(int i, int inc) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int x, int y, int z, int inc) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int get(int x, int y, int z) {
        return this.getXYZ(x, y, z) ? 1 : 0;
    }

    @Override
    public int get(int i) {
        int rows = i / this._dim_x;
        int corrected_index = i + rows * this._error_per_row;
        int intnum = corrected_index / 32;
        int bitnum = corrected_index - intnum * 32;
        return this._data[intnum] >> bitnum & 1;
    }

    @Override
    public void set(int i, int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(int x, int y, int z, int value) {
        this.setXYZ(x, y, z, value != 0);
    }

    @Override
    public int[] get_data() {
        return this._data;
    }

    public BitCube detect_n6_border(int[] bb_min, int[] bb_max) {
        BitCube new_bc = new BitCube(this._dim_x, this._dim_y, this._dim_z);
        int[] my_bb_min = new int[3];
        int[] my_bb_max = new int[3];
        my_bb_min[0] = bb_min[0] > this._bb_min[0] ? bb_min[0] : this._bb_min[0];
        my_bb_min[1] = bb_min[1] > this._bb_min[1] ? bb_min[1] : this._bb_min[1];
        my_bb_min[2] = bb_min[2] > this._bb_min[2] ? bb_min[2] : this._bb_min[2];
        my_bb_max[0] = bb_max[0] < this._bb_max[0] ? bb_max[0] : this._bb_max[0];
        my_bb_max[1] = bb_max[1] < this._bb_max[1] ? bb_max[1] : this._bb_max[1];
        my_bb_max[2] = bb_max[2] < this._bb_max[2] ? bb_max[2] : this._bb_max[2];
        int start = my_bb_min[2] * this._ints_per_img;
        int end = my_bb_max[2] * this._ints_per_img;
        if (start > this._ints_per_img) {
            start -= this._ints_per_img;
        }
        if (end < this._data.length - this._ints_per_img) {
            end += this._ints_per_img;
        }
        int i = start;
        while (i < end) {
            if (this._data[i] != 0) {
                int start_x;
                int z = i / this._ints_per_img;
                int y = (i - z * this._ints_per_img) / this._ints_per_row;
                int x = start_x = (i - z * this._ints_per_img - y * this._ints_per_row) * 32;
                while (x < start_x + 31) {
                    if (this.getXYZ(x, y, z) && this.has_unset_n6_neighbour(x, y, z)) {
                        new_bc.setXYZ(x, y, z, true);
                    }
                    ++x;
                }
            }
            ++i;
        }
        new_bc._bb_min[0] = this._bb_min[0];
        new_bc._bb_min[1] = this._bb_min[1];
        new_bc._bb_min[2] = this._bb_min[2];
        new_bc._bb_max[0] = this._bb_max[0];
        new_bc._bb_max[1] = this._bb_max[1];
        new_bc._bb_max[2] = this._bb_max[2];
        return new_bc;
    }

    public BitCube detect_n26_border(int[] bb_min, int[] bb_max) {
        BitCube new_bc = new BitCube(this._dim_x, this._dim_y, this._dim_z);
        int[] my_bb_min = new int[3];
        int[] my_bb_max = new int[3];
        my_bb_min[0] = bb_min[0] > this._bb_min[0] ? bb_min[0] : this._bb_min[0];
        my_bb_min[1] = bb_min[1] > this._bb_min[1] ? bb_min[1] : this._bb_min[1];
        my_bb_min[2] = bb_min[2] > this._bb_min[2] ? bb_min[2] : this._bb_min[2];
        my_bb_max[0] = bb_max[0] < this._bb_max[0] ? bb_max[0] : this._bb_max[0];
        my_bb_max[1] = bb_max[1] < this._bb_max[1] ? bb_max[1] : this._bb_max[1];
        my_bb_max[2] = bb_max[2] < this._bb_max[2] ? bb_max[2] : this._bb_max[2];
        int start = my_bb_min[2] * this._ints_per_img;
        int end = my_bb_max[2] * this._ints_per_img;
        if (start > this._ints_per_img) {
            start -= this._ints_per_img;
        }
        if (end < this._data.length - this._ints_per_img) {
            end += this._ints_per_img;
        }
        int i = start;
        while (i < end) {
            if (this._data[i] != 0) {
                int start_x;
                int z = i / this._ints_per_img;
                int y = (i - z * this._ints_per_img) / this._ints_per_row;
                int x = start_x = (i - z * this._ints_per_img - y * this._ints_per_row) * 32;
                while (x < start_x + 31) {
                    if (this.getXYZ(x, y, z) && this.has_unset_n26_neighbour(x, y, z)) {
                        new_bc.setXYZ(x, y, z, true);
                    }
                    ++x;
                }
            }
            ++i;
        }
        new_bc._bb_min[0] = this._bb_min[0];
        new_bc._bb_min[1] = this._bb_min[1];
        new_bc._bb_min[2] = this._bb_min[2];
        new_bc._bb_max[0] = this._bb_max[0];
        new_bc._bb_max[1] = this._bb_max[1];
        new_bc._bb_max[2] = this._bb_max[2];
        return new_bc;
    }
}

