/*
 * Decompiled with CFR 0.152.
 */
package misc.grid;

import java.util.Random;
import javax.vecmath.Point3i;
import misc.grid.BitCube;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BitCubeTest {
    private static int MIN_DIM = 10;
    private static int MAX_DIM = 100;
    private BitCube[] _test_cubes;
    private int[][] _test_dims;
    Random _r = new Random(42L);
    private final int _dim_x = 32;
    private final int _dim_y = 32;
    private final int _dim_z = 64;
    private final Point3i vp1 = new Point3i(0, 0, 0);
    private final Point3i vp2 = new Point3i(16, 16, 32);
    private final Point3i vp3 = new Point3i(31, 31, 63);
    private BitCube _bc;

    @Before
    public void set_up() {
        this._bc = new BitCube(32, 32, 64);
        this.set_cube_point_visible(this._bc, this.vp1);
        this.set_cube_point_visible(this._bc, this.vp2);
        this.set_cube_point_visible(this._bc, this.vp3);
        this._test_cubes = new BitCube[10];
        this._test_dims = new int[10][3];
        int i = 0;
        while (i < 10) {
            this._test_dims[i][0] = MIN_DIM + this._r.nextInt(MAX_DIM - MIN_DIM) + 1;
            this._test_dims[i][1] = MIN_DIM + this._r.nextInt(MAX_DIM - MIN_DIM) + 1;
            this._test_dims[i][2] = MIN_DIM + this._r.nextInt(MAX_DIM - MIN_DIM) + 1;
            this._test_cubes[i] = new BitCube(this._test_dims[i][0], this._test_dims[i][1], this._test_dims[i][2]);
            ++i;
        }
    }

    public void randomize_cube(BitCube bc) {
        int dim_x = bc.get_dim_x();
        int dim_y = bc.get_dim_y();
        int dim_z = bc.get_dim_z();
        int j = 0;
        while (j < dim_x * dim_y * dim_z / 10) {
            int x = this._r.nextInt(dim_x);
            int y = this._r.nextInt(dim_y);
            int z = this._r.nextInt(dim_z);
            bc.setXYZ(x, y, z, true);
            ++j;
        }
        bc.calc_bb();
    }

    @Test
    public void testBitCube() {
        int i = 0;
        while (i < this._test_cubes.length) {
            Assert.assertEquals((long)this._test_dims[i][0], (long)this._test_cubes[i].get_dim_x());
            Assert.assertEquals((long)this._test_dims[i][1], (long)this._test_cubes[i].get_dim_y());
            Assert.assertEquals((long)this._test_dims[i][2], (long)this._test_cubes[i].get_dim_z());
            ++i;
        }
    }

    private void set_cube_point_visible(BitCube c, Point3i p) {
        c.setXYZ(p.x, p.y, p.z, true);
    }

    @Test
    public void testIndexGet() {
        int idx_1 = this.vp1.z * 32 * 32 + this.vp1.y * 32 + this.vp1.x;
        int idx_2 = this.vp2.z * 32 * 32 + this.vp2.y * 32 + this.vp2.x;
        int idx_3 = this.vp3.z * 32 * 32 + this.vp3.y * 32 + this.vp3.x;
        int i = 0;
        while (i < 65536) {
            if (i == idx_1 || i == idx_2 || i == idx_3) {
                Assert.assertEquals((String)("at index " + i), (long)1L, (long)this._bc.get(i));
            } else {
                Assert.assertEquals((String)("at index " + i), (long)0L, (long)this._bc.get(i));
            }
            ++i;
        }
    }

    @Test
    public void testSetAndGet() {
        int i = 0;
        while (i < 10) {
            int z = 0;
            while (z < this._test_dims[i][2]) {
                int y = 0;
                while (y < this._test_dims[i][1]) {
                    int x = 0;
                    while (x < this._test_dims[i][0]) {
                        boolean value = this._r.nextInt(2) > 0;
                        this._test_cubes[i].setXYZ(x, y, z, value);
                        Assert.assertEquals((Object)value, (Object)this._test_cubes[i].getXYZ(x, y, z));
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
            ++i;
        }
    }

    @Test
    public void testCopyDataFrom() {
        int i = 0;
        while (i < 10) {
            this.randomize_cube(this._test_cubes[i]);
            BitCube bc_copy = new BitCube(this._test_dims[i][0], this._test_dims[i][1], this._test_dims[i][2]);
            bc_copy.copy_data_from(this._test_cubes[i]);
            int z = 0;
            while (z < this._test_dims[i][2]) {
                int y = 0;
                while (y < this._test_dims[i][1]) {
                    int x = 0;
                    while (x < this._test_dims[i][0]) {
                        Assert.assertEquals((Object)this._test_cubes[i].getXYZ(x, y, z), (Object)bc_copy.getXYZ(x, y, z));
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
            ++i;
        }
    }

    @Test
    public void testTranslate() {
        int border_width = 4;
        int i = 0;
        while (i < 10) {
            int b;
            this.randomize_cube(this._test_cubes[i]);
            int z = 0;
            while (z < this._test_dims[i][2]) {
                int y = 0;
                while (y < this._test_dims[i][1]) {
                    b = 0;
                    while (b < 4) {
                        this._test_cubes[i].setXYZ(b, y, z, false);
                        this._test_cubes[i].setXYZ(this._test_dims[i][0] - b - 1, y, z, false);
                        ++b;
                    }
                    ++y;
                }
                ++z;
            }
            int y = 0;
            while (y < this._test_dims[i][1]) {
                int x = 0;
                while (x < this._test_dims[i][0]) {
                    b = 0;
                    while (b < 4) {
                        this._test_cubes[i].setXYZ(x, y, b, false);
                        this._test_cubes[i].setXYZ(x, y, this._test_dims[i][2] - b - 1, false);
                        ++b;
                    }
                    ++x;
                }
                ++y;
            }
            this._test_cubes[i].calc_bb();
            BitCube bc_copy = new BitCube(this._test_cubes[i]);
            int shift_x = 4 - this._r.nextInt(8);
            int shift_y = 4 - this._r.nextInt(8);
            int shift_z = 4 - this._r.nextInt(8);
            this._test_cubes[i].translate(shift_x, shift_y, shift_z);
            int z2 = bc_copy._bb_min[2];
            while (z2 < bc_copy._bb_max[2]) {
                int y2 = bc_copy._bb_min[1];
                while (y2 < bc_copy._bb_max[1]) {
                    int x = bc_copy._bb_min[0];
                    while (x < bc_copy._bb_max[0]) {
                        Assert.assertEquals((Object)this._test_cubes[i].getXYZ(x + shift_x, y2 + shift_y, z2 + shift_z), (Object)bc_copy.getXYZ(x, y2, z2));
                        ++x;
                    }
                    ++y2;
                }
                ++z2;
            }
            ++i;
        }
    }

    @Test
    public void testCopyDataFromShift() {
        int i = 0;
        while (i < 10) {
            BitCube bc_shifted_copy = new BitCube(this._test_dims[i][0] * 2, this._test_dims[i][1] * 2, this._test_dims[i][2] * 2);
            this.randomize_cube(this._test_cubes[i]);
            bc_shifted_copy.clear();
            int shift_x = this._r.nextInt(this._test_dims[i][0] / 10);
            int shift_y = this._r.nextInt(this._test_dims[i][1] / 10);
            int shift_z = this._r.nextInt(this._test_dims[i][2] / 10);
            bc_shifted_copy.copy_data_from(this._test_cubes[i], shift_x, shift_y, shift_z);
            int z = 0;
            while (z < this._test_dims[i][2]) {
                int y = 0;
                while (y < this._test_dims[i][1]) {
                    int x = 0;
                    while (x < this._test_dims[i][0]) {
                        Assert.assertEquals((Object)this._test_cubes[i].getXYZ(x, y, z), (Object)bc_shifted_copy.getXYZ(x + shift_x, y + shift_y, z + shift_z));
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
            ++i;
        }
    }

    @Test
    public void testClear() {
        int i = 0;
        while (i < 10) {
            this.randomize_cube(this._test_cubes[i]);
            this._test_cubes[i].clear();
            int z = 0;
            while (z < this._test_dims[i][2]) {
                int y = 0;
                while (y < this._test_dims[i][1]) {
                    int x = 0;
                    while (x < this._test_dims[i][0]) {
                        Assert.assertEquals((Object)false, (Object)this._test_cubes[i].getXYZ(x, y, z));
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
            ++i;
        }
    }

    @Test
    public void testInvert() {
        int i = 0;
        while (i < 10) {
            this.randomize_cube(this._test_cubes[i]);
            BitCube bc_invert = new BitCube(this._test_dims[i][0], this._test_dims[i][1], this._test_dims[i][2]);
            bc_invert.copy_data_from(this._test_cubes[i]);
            bc_invert.invert();
            int z = 0;
            while (z < this._test_dims[i][2]) {
                int y = 0;
                while (y < this._test_dims[i][1]) {
                    int x = 0;
                    while (x < this._test_dims[i][0]) {
                        if (this._test_cubes[i].getXYZ(x, y, z) == bc_invert.getXYZ(x, y, z)) {
                            System.out.println(String.valueOf(this._test_dims[i][0]) + " " + this._test_dims[i][1] + " " + this._test_dims[i][2] + " ");
                            System.out.println("x=" + x + "  y=" + y + "  z=" + z);
                        }
                        Assert.assertEquals((Object)this._test_cubes[i].getXYZ(x, y, z), (Object)(!bc_invert.getXYZ(x, y, z) ? 1 : 0));
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
            ++i;
        }
    }

    @Test
    public void testAdd() {
        int i = 0;
        while (i < 10) {
            BitCube bc = new BitCube(this._test_dims[i][0], this._test_dims[i][1], this._test_dims[i][2]);
            BitCube bc_result = new BitCube(this._test_dims[i][0], this._test_dims[i][1], this._test_dims[i][2]);
            this.randomize_cube(this._test_cubes[i]);
            this.randomize_cube(bc);
            bc_result.copy_data_from(this._test_cubes[i]);
            bc_result.add(bc);
            int z = 0;
            while (z < this._test_dims[i][2]) {
                int y = 0;
                while (y < this._test_dims[i][1]) {
                    int x = 0;
                    while (x < this._test_dims[i][0]) {
                        Assert.assertEquals((Object)(this._test_cubes[i].getXYZ(x, y, z) || bc.getXYZ(x, y, z) ? 1 : 0), (Object)bc_result.getXYZ(x, y, z));
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
            ++i;
        }
    }

    @Test
    public void testDel() {
        int i = 0;
        while (i < 10) {
            BitCube bc = new BitCube(this._test_dims[i][0], this._test_dims[i][1], this._test_dims[i][2]);
            BitCube bc_result = new BitCube(this._test_dims[i][0], this._test_dims[i][1], this._test_dims[i][2]);
            this.randomize_cube(this._test_cubes[i]);
            this.randomize_cube(bc);
            bc_result.copy_data_from(this._test_cubes[i]);
            bc_result.del(bc);
            int z = 0;
            while (z < this._test_dims[i][2]) {
                int y = 0;
                while (y < this._test_dims[i][1]) {
                    int x = 0;
                    while (x < this._test_dims[i][0]) {
                        Assert.assertEquals((Object)(this._test_cubes[i].getXYZ(x, y, z) && !bc.getXYZ(x, y, z) ? 1 : 0), (Object)bc_result.getXYZ(x, y, z));
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
            ++i;
        }
    }

    @Test
    public void testBB() {
        int i = 0;
        while (i < 10) {
            int z;
            int y;
            int x;
            int min_z = Integer.MAX_VALUE;
            int min_y = Integer.MAX_VALUE;
            int min_x = Integer.MAX_VALUE;
            int max_z = Integer.MIN_VALUE;
            int max_y = Integer.MIN_VALUE;
            int max_x = Integer.MIN_VALUE;
            int j = 0;
            while (j < this._test_dims[i][0] * this._test_dims[i][1] * this._test_dims[i][2] / 10) {
                x = this._r.nextInt(this._test_dims[i][0]);
                y = this._r.nextInt(this._test_dims[i][1]);
                z = this._r.nextInt(this._test_dims[i][2]);
                if (x < min_x) {
                    min_x = x;
                }
                if (x > max_x) {
                    max_x = x;
                }
                if (y < min_y) {
                    min_y = y;
                }
                if (y > max_y) {
                    max_y = y;
                }
                if (z < min_z) {
                    min_z = z;
                }
                if (z > max_z) {
                    max_z = z;
                }
                this._test_cubes[i].setXYZ(x, y, z, true);
                ++j;
            }
            this._test_cubes[i].calc_bb();
            Assert.assertEquals((long)min_x, (long)this._test_cubes[i]._bb_min[0]);
            Assert.assertEquals((long)min_y, (long)this._test_cubes[i]._bb_min[1]);
            Assert.assertEquals((long)min_z, (long)this._test_cubes[i]._bb_min[2]);
            Assert.assertEquals((long)max_x, (long)this._test_cubes[i]._bb_max[0]);
            Assert.assertEquals((long)max_y, (long)this._test_cubes[i]._bb_max[1]);
            Assert.assertEquals((long)max_z, (long)this._test_cubes[i]._bb_max[2]);
            j = 0;
            while (j < this._test_dims[i][0] * this._test_dims[i][1] * this._test_dims[i][2] / 10) {
                x = this._r.nextInt(this._test_dims[i][0]);
                y = this._r.nextInt(this._test_dims[i][1]);
                z = this._r.nextInt(this._test_dims[i][2]);
                if (x < min_x) {
                    min_x = x;
                }
                if (x > max_x) {
                    max_x = x;
                }
                if (y < min_y) {
                    min_y = y;
                }
                if (y > max_y) {
                    max_y = y;
                }
                if (z < min_z) {
                    min_z = z;
                }
                if (z > max_z) {
                    max_z = z;
                }
                this._test_cubes[i].setXYZ(x, y, z, true);
                ++j;
            }
            this._test_cubes[i].calc_bb(min_x, min_y, min_z, max_x, max_y, max_z);
            Assert.assertEquals((long)min_x, (long)this._test_cubes[i]._bb_min[0]);
            Assert.assertEquals((long)min_y, (long)this._test_cubes[i]._bb_min[1]);
            Assert.assertEquals((long)min_z, (long)this._test_cubes[i]._bb_min[2]);
            Assert.assertEquals((long)max_x, (long)this._test_cubes[i]._bb_max[0]);
            Assert.assertEquals((long)max_y, (long)this._test_cubes[i]._bb_max[1]);
            Assert.assertEquals((long)max_z, (long)this._test_cubes[i]._bb_max[2]);
            ++i;
        }
    }

    @Test
    public void testMirror() {
        int i = 0;
        while (i < 10) {
            int dim_x = this._test_cubes[i].get_dim_x();
            int dim_y = this._test_cubes[i].get_dim_y();
            int dim_z = this._test_cubes[i].get_dim_z();
            this.randomize_cube(this._test_cubes[i]);
            BitCube bc_mirror_x = new BitCube(dim_x, dim_y, dim_z);
            BitCube bc_mirror_y = new BitCube(dim_x, dim_y, dim_z);
            BitCube bc_mirror_z = new BitCube(dim_x, dim_y, dim_z);
            bc_mirror_x.copy_data_from(this._test_cubes[i]);
            bc_mirror_y.copy_data_from(this._test_cubes[i]);
            bc_mirror_z.copy_data_from(this._test_cubes[i]);
            bc_mirror_x.mirror(0);
            bc_mirror_y.mirror(1);
            bc_mirror_z.mirror(2);
            int z = 0;
            while (z < dim_z) {
                int y = 0;
                while (y < dim_y) {
                    int x = 0;
                    while (x < dim_x) {
                        Assert.assertEquals((Object)this._test_cubes[i].getXYZ(x, y, z), (Object)bc_mirror_x.getXYZ(dim_x - x - 1, y, z));
                        Assert.assertEquals((Object)this._test_cubes[i].getXYZ(x, y, z), (Object)bc_mirror_y.getXYZ(x, dim_y - y - 1, z));
                        Assert.assertEquals((Object)this._test_cubes[i].getXYZ(x, y, z), (Object)bc_mirror_z.getXYZ(x, y, dim_z - z - 1));
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
            ++i;
        }
    }
}

