/*
 * Decompiled with CFR 0.152.
 */
package misc.grid;

import java.util.Vector;

public final class BitMask {
    public static final int BITS = 32;
    public static final int SHIFT = 5;
    private final int[] _data;
    private final int _dim_x;
    private final int _dim_y;
    private int _ints_per_row;
    final int _ints_per_img;
    public int[] _bbmin;
    public int[] _bbmax;

    public BitMask(int dim_x, int dim_y) {
        this._dim_x = dim_x;
        this._dim_y = dim_y;
        this._bbmin = new int[2];
        this._bbmax = new int[2];
        this._bbmin[1] = Integer.MAX_VALUE;
        this._bbmin[0] = Integer.MAX_VALUE;
        this._bbmax[1] = Integer.MIN_VALUE;
        this._bbmax[0] = Integer.MIN_VALUE;
        this._ints_per_row = this._dim_x % 32 == 0 ? this._dim_x / 32 : this._dim_x / 32 + 1;
        this._ints_per_img = this._dim_y * this._ints_per_row;
        this._data = new int[this._ints_per_img];
    }

    public int get_dim_x() {
        return this._dim_x;
    }

    public int get_dim_y() {
        return this._dim_y;
    }

    public final void copy_data_from(BitMask bc) {
        int i = 0;
        while (i < this._data.length) {
            this._data[i] = bc._data[i];
            ++i;
        }
        i = 0;
        while (i < 2) {
            this._bbmin[i] = bc._bbmin[i];
            this._bbmax[i] = bc._bbmax[i];
            ++i;
        }
    }

    public int[] get_data() {
        return this._data;
    }

    public final void setXY(int x, int y, boolean value) {
        int intnum = y * this._ints_per_row + (x >>> 5);
        int bitnum = x % 32;
        if (value) {
            int n = intnum;
            this._data[n] = this._data[n] | 1 << bitnum;
        } else {
            int n = intnum;
            this._data[n] = this._data[n] & ~(1 << bitnum);
        }
    }

    public final boolean getXY(int x, int y) {
        int intnum = y * this._ints_per_row + (x >>> 5);
        int bitnum = x % 32;
        return (this._data[intnum] & 1 << bitnum) != 0;
    }

    public final String toString() {
        StringBuffer str = new StringBuffer(this._data.length + this._dim_y);
        int i = 0;
        while (i < this._dim_y) {
            int j = 0;
            while (j < this._dim_x) {
                str.append(this.getXY(j, i) ? "1" : "0");
                ++j;
            }
            str.append("\n");
            ++i;
        }
        return str.toString();
    }

    public final void fill_with(boolean value) {
        if (value) {
            int i = 0;
            while (i < this._data.length) {
                this._data[i] = -1;
                ++i;
            }
        } else {
            int i = 0;
            while (i < this._data.length) {
                this._data[i] = 0;
                ++i;
            }
        }
    }

    public final void clear() {
        this.fill_with(false);
    }

    public final void invert() {
        int i = 0;
        while (i < this._data.length) {
            this._data[i] = ~this._data[i];
            ++i;
        }
    }

    public final void add(BitMask mask) {
        if (this._dim_x == mask._dim_x && this._dim_y == mask._dim_y) {
            int i = 0;
            while (i < this._data.length) {
                int n = i;
                this._data[n] = this._data[n] | mask._data[i];
                ++i;
            }
        }
    }

    public final void del(BitMask mask) {
        if (this._dim_x == mask._dim_x && this._dim_y == mask._dim_y) {
            int i = 0;
            while (i < this._data.length) {
                int n = i;
                this._data[n] = this._data[n] & ~mask._data[i];
                ++i;
            }
        }
    }

    public void calc_bb(int bbmin_x, int bbmin_y, int bbmax_x, int bbmax_y) {
        if (this._bbmin[0] >= bbmin_x || this._bbmin[1] >= bbmin_y || this._bbmax[0] <= bbmax_x || this._bbmax[1] <= bbmax_y) {
            this.calc_bb();
        }
    }

    public void calc_bb() {
        int y;
        int ix;
        int intnum;
        this._bbmin[1] = Integer.MAX_VALUE;
        this._bbmin[0] = Integer.MAX_VALUE;
        this._bbmax[1] = Integer.MIN_VALUE;
        this._bbmax[0] = Integer.MIN_VALUE;
        boolean gotcha = false;
        int y2 = 0;
        while (y2 < this._dim_y) {
            intnum = y2 * this._ints_per_row;
            ix = 0;
            while (ix < this._ints_per_row && !gotcha) {
                if (this._data[intnum + ix] != 0) {
                    this._bbmin[1] = y2;
                    gotcha = true;
                }
                ++ix;
            }
            ++y2;
        }
        gotcha = false;
        y2 = this._dim_y - 1;
        while (y2 >= this._bbmin[1]) {
            intnum = y2 * this._ints_per_row;
            ix = 0;
            while (ix < this._ints_per_row && !gotcha) {
                if (this._data[intnum + ix] != 0) {
                    this._bbmax[1] = y2;
                    gotcha = true;
                }
                ++ix;
            }
            --y2;
        }
        gotcha = false;
        int ix2 = 0;
        while (ix2 < this._ints_per_row && !gotcha) {
            intnum = this._bbmin[1] * this._ints_per_row + ix2;
            y = this._bbmin[1];
            while (y <= this._bbmax[1]) {
                if (this._data[intnum] != 0) {
                    int min_x = Integer.numberOfTrailingZeros(this._data[intnum]);
                    if (min_x < this._bbmin[0]) {
                        this._bbmin[0] = min_x;
                    }
                    gotcha = true;
                }
                intnum += this._ints_per_row;
                ++y;
            }
            if (gotcha) {
                this._bbmin[0] = this._bbmin[0] + ix2 * 32;
            }
            ++ix2;
        }
        gotcha = false;
        ix2 = this._ints_per_row - 1;
        while (ix2 >= 0 && !gotcha) {
            intnum = this._bbmin[1] * this._ints_per_row + ix2;
            y = this._bbmin[1];
            while (y <= this._bbmax[1]) {
                if (this._data[intnum] != 0) {
                    int max_x = 32 - Integer.numberOfLeadingZeros(this._data[intnum]);
                    if (max_x > this._bbmax[0]) {
                        this._bbmax[0] = max_x;
                    }
                    gotcha = true;
                }
                intnum += this._ints_per_row;
                ++y;
            }
            if (gotcha) {
                this._bbmax[0] = this._bbmax[0] + (ix2 * 32 - 1);
            }
            --ix2;
        }
        if (this._bbmax[0] > this._dim_x - 1) {
            this._bbmax[0] = this._dim_x - 1;
        }
    }

    public final Vector<Vector<int[]>> detectBorder() {
        Vector<Vector<int[]>> outline = new Vector<Vector<int[]>>();
        BitMask b1 = new BitMask(this._dim_x, this._dim_y);
        BitMask b2 = new BitMask(this._dim_x, this._dim_y);
        int i = 0;
        while (i < this._dim_x) {
            int j = 0;
            while (j < this._dim_y) {
                if (this.getXY(i, j) && (i > 0 && !this.getXY(i - 1, j) || j > 0 && !this.getXY(i, j - 1) || i < this._dim_x - 1 && !this.getXY(i + 1, j) || j < this._dim_y - 1 && !this.getXY(i, j + 1))) {
                    b1.setXY(i, j, true);
                }
                ++j;
            }
            ++i;
        }
        boolean exit = false;
        int i2 = 0;
        while (i2 < this._dim_y) {
            int j = 0;
            while (j < this._dim_x) {
                if (b1.getXY(j, i2) && !b2.getXY(j, i2)) {
                    int ni = j;
                    int nj = i2;
                    int figure = 2;
                    boolean no_follow = false;
                    Vector<int[]> ring = new Vector<int[]>();
                    do {
                        b2.setXY(ni, nj, true);
                        ring.add(new int[]{ni, nj});
                        switch (figure) {
                            case 0: {
                                if (ni > 0 && nj < this._dim_y - 1 && b1.getXY(ni - 1, nj + 1)) {
                                    figure = 5;
                                    --ni;
                                    ++nj;
                                    break;
                                }
                                if (ni > 0 && b1.getXY(ni - 1, nj)) {
                                    figure = 6;
                                    --ni;
                                    break;
                                }
                                if (ni > 0 && nj > 0 && b1.getXY(ni - 1, nj - 1)) {
                                    figure = 7;
                                    --ni;
                                    --nj;
                                    break;
                                }
                                if (nj > 0 && b1.getXY(ni, nj - 1)) {
                                    figure = 0;
                                    --nj;
                                    break;
                                }
                                if (ni < this._dim_x - 1 && nj > 0 && b1.getXY(ni + 1, nj - 1)) {
                                    figure = 1;
                                    ++ni;
                                    --nj;
                                    break;
                                }
                                if (ni < this._dim_x - 1 && b1.getXY(ni + 1, nj)) {
                                    figure = 2;
                                    ++ni;
                                    break;
                                }
                                if (ni < this._dim_x - 1 && nj < this._dim_y - 1 && b1.getXY(ni + 1, nj + 1)) {
                                    figure = 3;
                                    ++ni;
                                    ++nj;
                                    break;
                                }
                                if (nj < this._dim_y - 1 && b1.getXY(ni, nj + 1)) {
                                    figure = 4;
                                    ++nj;
                                    break;
                                }
                                no_follow = true;
                                break;
                            }
                            case 1: {
                                if (ni > 0 && b1.getXY(ni - 1, nj)) {
                                    figure = 6;
                                    --ni;
                                    break;
                                }
                                if (ni > 0 && nj > 0 && b1.getXY(ni - 1, nj - 1)) {
                                    figure = 7;
                                    --ni;
                                    --nj;
                                    break;
                                }
                                if (nj > 0 && b1.getXY(ni, nj - 1)) {
                                    figure = 0;
                                    --nj;
                                    break;
                                }
                                if (ni < this._dim_x - 1 && nj > 0 && b1.getXY(ni + 1, nj - 1)) {
                                    figure = 1;
                                    ++ni;
                                    --nj;
                                    break;
                                }
                                if (ni < this._dim_x - 1 && b1.getXY(ni + 1, nj)) {
                                    figure = 2;
                                    ++ni;
                                    break;
                                }
                                if (ni < this._dim_x - 1 && nj < this._dim_y - 1 && b1.getXY(ni + 1, nj + 1)) {
                                    figure = 3;
                                    ++ni;
                                    ++nj;
                                    break;
                                }
                                if (nj < this._dim_y - 1 && b1.getXY(ni, nj + 1)) {
                                    figure = 4;
                                    ++nj;
                                    break;
                                }
                                if (ni > 0 && nj < this._dim_y - 1 && b1.getXY(ni - 1, nj + 1)) {
                                    figure = 5;
                                    --ni;
                                    ++nj;
                                    break;
                                }
                                no_follow = true;
                                break;
                            }
                            case 2: {
                                if (ni > 0 && nj > 0 && b1.getXY(ni - 1, nj - 1)) {
                                    figure = 7;
                                    --ni;
                                    --nj;
                                    break;
                                }
                                if (nj > 0 && b1.getXY(ni, nj - 1)) {
                                    figure = 0;
                                    --nj;
                                    break;
                                }
                                if (ni < this._dim_x - 1 && nj > 0 && b1.getXY(ni + 1, nj - 1)) {
                                    figure = 1;
                                    ++ni;
                                    --nj;
                                    break;
                                }
                                if (ni < this._dim_x - 1 && b1.getXY(ni + 1, nj)) {
                                    figure = 2;
                                    ++ni;
                                    break;
                                }
                                if (ni < this._dim_x - 1 && nj < this._dim_y - 1 && b1.getXY(ni + 1, nj + 1)) {
                                    figure = 3;
                                    ++ni;
                                    ++nj;
                                    break;
                                }
                                if (nj < this._dim_y - 1 && b1.getXY(ni, nj + 1)) {
                                    figure = 4;
                                    ++nj;
                                    break;
                                }
                                if (ni > 0 && nj < this._dim_y - 1 && b1.getXY(ni - 1, nj + 1)) {
                                    figure = 5;
                                    --ni;
                                    ++nj;
                                    break;
                                }
                                if (ni > 0 && b1.getXY(ni - 1, nj)) {
                                    figure = 6;
                                    --ni;
                                    break;
                                }
                                no_follow = true;
                                break;
                            }
                            case 3: {
                                if (nj > 0 && b1.getXY(ni, nj - 1)) {
                                    figure = 0;
                                    --nj;
                                    break;
                                }
                                if (ni < this._dim_x - 1 && nj > 0 && b1.getXY(ni + 1, nj - 1)) {
                                    figure = 1;
                                    ++ni;
                                    --nj;
                                    break;
                                }
                                if (ni < this._dim_x - 1 && b1.getXY(ni + 1, nj)) {
                                    figure = 2;
                                    ++ni;
                                    break;
                                }
                                if (ni < this._dim_x - 1 && nj < this._dim_y - 1 && b1.getXY(ni + 1, nj + 1)) {
                                    figure = 3;
                                    ++ni;
                                    ++nj;
                                    break;
                                }
                                if (nj < this._dim_y - 1 && b1.getXY(ni, nj + 1)) {
                                    figure = 4;
                                    ++nj;
                                    break;
                                }
                                if (ni > 0 && nj < this._dim_y - 1 && b1.getXY(ni - 1, nj + 1)) {
                                    figure = 5;
                                    --ni;
                                    ++nj;
                                    break;
                                }
                                if (ni > 0 && b1.getXY(ni - 1, nj)) {
                                    figure = 6;
                                    --ni;
                                    break;
                                }
                                if (ni > 0 && nj > 0 && b1.getXY(ni - 1, nj - 1)) {
                                    figure = 7;
                                    --ni;
                                    --nj;
                                    break;
                                }
                                no_follow = true;
                                break;
                            }
                            case 4: {
                                if (ni < this._dim_x - 1 && nj > 0 && b1.getXY(ni + 1, nj - 1)) {
                                    figure = 1;
                                    ++ni;
                                    --nj;
                                    break;
                                }
                                if (ni < this._dim_x - 1 && b1.getXY(ni + 1, nj)) {
                                    figure = 2;
                                    ++ni;
                                    break;
                                }
                                if (ni < this._dim_x - 1 && nj < this._dim_y - 1 && b1.getXY(ni + 1, nj + 1)) {
                                    figure = 3;
                                    ++ni;
                                    ++nj;
                                    break;
                                }
                                if (nj < this._dim_y - 1 && b1.getXY(ni, nj + 1)) {
                                    figure = 4;
                                    ++nj;
                                    break;
                                }
                                if (ni > 0 && nj < this._dim_y - 1 && b1.getXY(ni - 1, nj + 1)) {
                                    figure = 5;
                                    --ni;
                                    ++nj;
                                    break;
                                }
                                if (ni > 0 && b1.getXY(ni - 1, nj)) {
                                    figure = 6;
                                    --ni;
                                    break;
                                }
                                if (ni > 0 && nj > 0 && b1.getXY(ni - 1, nj - 1)) {
                                    figure = 7;
                                    --ni;
                                    --nj;
                                    break;
                                }
                                if (nj > 0 && b1.getXY(ni, nj - 1)) {
                                    figure = 0;
                                    --nj;
                                    break;
                                }
                                no_follow = true;
                                break;
                            }
                            case 5: {
                                if (ni < this._dim_x - 1 && b1.getXY(ni + 1, nj)) {
                                    figure = 2;
                                    ++ni;
                                    break;
                                }
                                if (ni < this._dim_x - 1 && nj < this._dim_y - 1 && b1.getXY(ni + 1, nj + 1)) {
                                    figure = 3;
                                    ++ni;
                                    ++nj;
                                    break;
                                }
                                if (nj < this._dim_y - 1 && b1.getXY(ni, nj + 1)) {
                                    figure = 4;
                                    ++nj;
                                    break;
                                }
                                if (ni > 0 && nj < this._dim_y - 1 && b1.getXY(ni - 1, nj + 1)) {
                                    figure = 5;
                                    --ni;
                                    ++nj;
                                    break;
                                }
                                if (ni > 0 && b1.getXY(ni - 1, nj)) {
                                    figure = 6;
                                    --ni;
                                    break;
                                }
                                if (ni > 0 && nj > 0 && b1.getXY(ni - 1, nj - 1)) {
                                    figure = 7;
                                    --ni;
                                    --nj;
                                    break;
                                }
                                if (nj > 0 && b1.getXY(ni, nj - 1)) {
                                    figure = 0;
                                    --nj;
                                    break;
                                }
                                if (ni < this._dim_x - 1 && nj > 0 && b1.getXY(ni + 1, nj - 1)) {
                                    figure = 1;
                                    ++ni;
                                    --nj;
                                    break;
                                }
                                no_follow = true;
                                break;
                            }
                            case 6: {
                                if (ni < this._dim_x - 1 && nj < this._dim_y - 1 && b1.getXY(ni + 1, nj + 1)) {
                                    figure = 3;
                                    ++ni;
                                    ++nj;
                                    break;
                                }
                                if (nj < this._dim_y - 1 && b1.getXY(ni, nj + 1)) {
                                    figure = 4;
                                    ++nj;
                                    break;
                                }
                                if (ni > 0 && nj < this._dim_y - 1 && b1.getXY(ni - 1, nj + 1)) {
                                    figure = 5;
                                    --ni;
                                    ++nj;
                                    break;
                                }
                                if (ni > 0 && b1.getXY(ni - 1, nj)) {
                                    figure = 6;
                                    --ni;
                                    break;
                                }
                                if (ni > 0 && nj > 0 && b1.getXY(ni - 1, nj - 1)) {
                                    figure = 7;
                                    --ni;
                                    --nj;
                                    break;
                                }
                                if (nj > 0 && b1.getXY(ni, nj - 1)) {
                                    figure = 0;
                                    --nj;
                                    break;
                                }
                                if (ni < this._dim_x - 1 && nj > 0 && b1.getXY(ni + 1, nj - 1)) {
                                    figure = 1;
                                    ++ni;
                                    --nj;
                                    break;
                                }
                                if (ni < this._dim_x - 1 && b1.getXY(ni + 1, nj)) {
                                    figure = 2;
                                    ++ni;
                                    break;
                                }
                                no_follow = true;
                                break;
                            }
                            case 7: {
                                if (nj < this._dim_y - 1 && b1.getXY(ni, nj + 1)) {
                                    figure = 4;
                                    ++nj;
                                    break;
                                }
                                if (ni > 0 && nj < this._dim_y - 1 && b1.getXY(ni - 1, nj + 1)) {
                                    figure = 5;
                                    --ni;
                                    ++nj;
                                    break;
                                }
                                if (ni > 0 && b1.getXY(ni - 1, nj)) {
                                    figure = 6;
                                    --ni;
                                    break;
                                }
                                if (ni > 0 && nj > 0 && b1.getXY(ni - 1, nj - 1)) {
                                    figure = 7;
                                    --ni;
                                    --nj;
                                    break;
                                }
                                if (nj > 0 && b1.getXY(ni, nj - 1)) {
                                    figure = 0;
                                    --nj;
                                    break;
                                }
                                if (ni < this._dim_x - 1 && nj > 0 && b1.getXY(ni + 1, nj - 1)) {
                                    figure = 1;
                                    ++ni;
                                    --nj;
                                    break;
                                }
                                if (ni < this._dim_x - 1 && b1.getXY(ni + 1, nj)) {
                                    figure = 2;
                                    ++ni;
                                    break;
                                }
                                if (ni < this._dim_x - 1 && nj < this._dim_y - 1 && b1.getXY(ni + 1, nj + 1)) {
                                    figure = 3;
                                    ++ni;
                                    ++nj;
                                    break;
                                }
                                no_follow = true;
                            }
                        }
                    } while (!no_follow && (ni != j || nj != i2));
                    if (ring.size() > 4) {
                        outline.add(ring);
                    }
                }
                ++j;
            }
            ++i2;
        }
        return outline;
    }
}

