/*
 * Decompiled with CFR 0.152.
 */
package misc.grid;

import misc.grid.BitMask;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BitMaskTest {
    private static int MIN_DIM = 1;
    private static int MAX_DIM = 100;
    private BitMask[] _test_cubes;
    private int[][] _test_dims;

    @Before
    public void init() {
        this._test_cubes = new BitMask[10];
        this._test_dims = new int[10][2];
        int i = 0;
        while (i < 10) {
            this._test_dims[i][0] = MIN_DIM + (int)(Math.random() * (double)(MAX_DIM - MIN_DIM) + 1.0);
            this._test_dims[i][1] = MIN_DIM + (int)(Math.random() * (double)(MAX_DIM - MIN_DIM) + 1.0);
            this._test_cubes[i] = new BitMask(this._test_dims[i][0], this._test_dims[i][1]);
            ++i;
        }
    }

    public void randomize_mask(BitMask bc) {
        int dim_x = bc.get_dim_x();
        int dim_y = bc.get_dim_y();
        int j = 0;
        while (j < dim_x * dim_y / 10) {
            int x = (int)(Math.random() * (double)dim_x);
            int y = (int)(Math.random() * (double)dim_y);
            bc.setXY(x, y, true);
            ++j;
        }
        bc.calc_bb();
    }

    @Test
    public void testBitMask() {
        int i = 0;
        while (i < 10) {
            BitMask bc = new BitMask(this._test_dims[i][0], this._test_dims[i][1]);
            Assert.assertEquals((long)this._test_dims[i][0], (long)bc.get_dim_x());
            Assert.assertEquals((long)this._test_dims[i][1], (long)bc.get_dim_y());
            ++i;
        }
    }

    @Test
    public void testSetAndGet() {
        int i = 0;
        while (i < 10) {
            int y = 0;
            while (y < this._test_dims[i][1]) {
                int x = 0;
                while (x < this._test_dims[i][0]) {
                    boolean value = Math.random() > 0.5;
                    this._test_cubes[i].setXY(x, y, value);
                    Assert.assertEquals((Object)value, (Object)this._test_cubes[i].getXY(x, y));
                    ++x;
                }
                ++y;
            }
            ++i;
        }
    }

    @Test
    public void testCopyFrom() {
        int i = 0;
        while (i < 10) {
            this.randomize_mask(this._test_cubes[i]);
            BitMask bc_copy = new BitMask(this._test_dims[i][0], this._test_dims[i][1]);
            bc_copy.copy_data_from(this._test_cubes[i]);
            int y = 0;
            while (y < this._test_dims[i][1]) {
                int x = 0;
                while (x < this._test_dims[i][0]) {
                    Assert.assertEquals((Object)this._test_cubes[i].getXY(x, y), (Object)bc_copy.getXY(x, y));
                    ++x;
                }
                ++y;
            }
            ++i;
        }
    }

    @Test
    public void testClear() {
        int i = 0;
        while (i < 10) {
            this.randomize_mask(this._test_cubes[i]);
            this._test_cubes[i].clear();
            int y = 0;
            while (y < this._test_dims[i][1]) {
                int x = 0;
                while (x < this._test_dims[i][0]) {
                    Assert.assertEquals((Object)false, (Object)this._test_cubes[i].getXY(x, y));
                    ++x;
                }
                ++y;
            }
            ++i;
        }
    }

    @Test
    public void testInvert() {
        int i = 0;
        while (i < 10) {
            this.randomize_mask(this._test_cubes[i]);
            BitMask bc_invert = new BitMask(this._test_dims[i][0], this._test_dims[i][1]);
            bc_invert.copy_data_from(this._test_cubes[i]);
            bc_invert.invert();
            int y = 0;
            while (y < this._test_dims[i][1]) {
                int x = 0;
                while (x < this._test_dims[i][0]) {
                    Assert.assertEquals((Object)this._test_cubes[i].getXY(x, y), (Object)(!bc_invert.getXY(x, y) ? 1 : 0));
                    ++x;
                }
                ++y;
            }
            ++i;
        }
    }

    @Test
    public void testAdd() {
        int i = 0;
        while (i < 10) {
            this.randomize_mask(this._test_cubes[i]);
            BitMask bc = new BitMask(this._test_dims[i][0], this._test_dims[i][1]);
            this.randomize_mask(bc);
            BitMask bc_result = new BitMask(this._test_dims[i][0], this._test_dims[i][1]);
            bc_result.copy_data_from(this._test_cubes[i]);
            bc_result.add(bc);
            int y = 0;
            while (y < this._test_dims[i][1]) {
                int x = 0;
                while (x < this._test_dims[i][0]) {
                    Assert.assertEquals((Object)(this._test_cubes[i].getXY(x, y) || bc.getXY(x, y) ? 1 : 0), (Object)bc_result.getXY(x, y));
                    ++x;
                }
                ++y;
            }
            ++i;
        }
    }

    @Test
    public void testDel() {
        int i = 0;
        while (i < 10) {
            this.randomize_mask(this._test_cubes[i]);
            BitMask bc = new BitMask(this._test_dims[i][0], this._test_dims[i][1]);
            this.randomize_mask(bc);
            BitMask bc_result = new BitMask(this._test_dims[i][0], this._test_dims[i][1]);
            bc_result.copy_data_from(this._test_cubes[i]);
            bc_result.del(bc);
            int y = 0;
            while (y < this._test_dims[i][1]) {
                int x = 0;
                while (x < this._test_dims[i][0]) {
                    Assert.assertEquals((Object)(this._test_cubes[i].getXY(x, y) && !bc.getXY(x, y) ? 1 : 0), (Object)bc_result.getXY(x, y));
                    ++x;
                }
                ++y;
            }
            ++i;
        }
    }

    @Test
    public void testBB() {
        int i = 0;
        while (i < 10) {
            int y;
            int x;
            int min_y = Integer.MAX_VALUE;
            int min_x = Integer.MAX_VALUE;
            int max_y = Integer.MIN_VALUE;
            int max_x = Integer.MIN_VALUE;
            int j = 0;
            while (j < this._test_dims[i][0] * this._test_dims[i][1] / 10) {
                x = (int)(Math.random() * (double)this._test_dims[i][0]);
                y = (int)(Math.random() * (double)this._test_dims[i][1]);
                if (x < min_x) {
                    min_x = x;
                }
                if (x > max_x) {
                    max_x = x;
                }
                if (y < min_y) {
                    min_y = y;
                }
                if (y > max_y) {
                    max_y = y;
                }
                this._test_cubes[i].setXY(x, y, true);
                ++j;
            }
            this._test_cubes[i].calc_bb();
            Assert.assertEquals((long)min_x, (long)this._test_cubes[i]._bbmin[0]);
            Assert.assertEquals((long)min_y, (long)this._test_cubes[i]._bbmin[1]);
            Assert.assertEquals((long)max_x, (long)this._test_cubes[i]._bbmax[0]);
            Assert.assertEquals((long)max_y, (long)this._test_cubes[i]._bbmax[1]);
            j = 0;
            while (j < this._test_dims[i][0] * this._test_dims[i][1] / 10) {
                x = (int)(Math.random() * (double)this._test_dims[i][0]);
                y = (int)(Math.random() * (double)this._test_dims[i][1]);
                if (x < min_x) {
                    min_x = x;
                }
                if (x > max_x) {
                    max_x = x;
                }
                if (y < min_y) {
                    min_y = y;
                }
                if (y > max_y) {
                    max_y = y;
                }
                this._test_cubes[i].setXY(x, y, true);
                ++j;
            }
            this._test_cubes[i].calc_bb(min_x, min_y, max_x, max_y);
            Assert.assertEquals((long)min_x, (long)this._test_cubes[i]._bbmin[0]);
            Assert.assertEquals((long)min_y, (long)this._test_cubes[i]._bbmin[1]);
            Assert.assertEquals((long)max_x, (long)this._test_cubes[i]._bbmax[0]);
            Assert.assertEquals((long)max_y, (long)this._test_cubes[i]._bbmax[1]);
            ++i;
        }
    }
}

