/*
 * Decompiled with CFR 0.152.
 */
package misc.grid;

import misc.Voxel;
import misc.grid.N26Iterator;
import org.junit.Assert;
import org.junit.Test;

public class N26IteratorTest {
    @Test
    public void middle() {
        N26Iterator i26 = new N26Iterator(0, 0, 0, 100, 100, 100);
        Voxel v = new Voxel();
        i26.init(new Voxel(15, 15, 15));
        int count = 0;
        while (i26.next(v)) {
            ++count;
        }
        Assert.assertEquals((String)"N26 iterate middle", (long)26L, (long)count);
    }

    @Test
    public void border_but_no_corner() {
        N26Iterator i26 = new N26Iterator(0, 0, 0, 100, 100, 100);
        Voxel v = new Voxel();
        i26.init(new Voxel(0, 15, 15));
        int count = 0;
        while (i26.next(v)) {
            ++count;
        }
        Assert.assertEquals((String)"N26 iterate border but no corner x=0", (long)17L, (long)count);
        i26.init(new Voxel(100, 15, 15));
        count = 0;
        while (i26.next(v)) {
            ++count;
        }
        Assert.assertEquals((String)"N26 iterate border but no corner x=max", (long)17L, (long)count);
        i26.init(new Voxel(15, 0, 15));
        count = 0;
        while (i26.next(v)) {
            ++count;
        }
        Assert.assertEquals((String)"N26 iterate border but no corner y=0", (long)17L, (long)count);
        i26.init(new Voxel(15, 100, 15));
        count = 0;
        while (i26.next(v)) {
            ++count;
        }
        Assert.assertEquals((String)"N26 iterate border but no corner y=max", (long)17L, (long)count);
        i26.init(new Voxel(15, 15, 0));
        count = 0;
        while (i26.next(v)) {
            ++count;
        }
        Assert.assertEquals((String)"N26 iterate border but no corner z=0", (long)17L, (long)count);
        i26.init(new Voxel(15, 15, 100));
        count = 0;
        while (i26.next(v)) {
            ++count;
        }
        Assert.assertEquals((String)"N26 iterate border but no corner z=max", (long)17L, (long)count);
    }

    @Test
    public void corner() {
        N26Iterator i26 = new N26Iterator(0, 0, 0, 100, 100, 100);
        Voxel v = new Voxel();
        i26.init(new Voxel(0, 0, 0));
        int count = 0;
        while (i26.next(v)) {
            ++count;
        }
        Assert.assertEquals((String)"N26 iterate corner 0 0 0", (long)7L, (long)count);
        i26.init(new Voxel(100, 0, 0));
        count = 0;
        while (i26.next(v)) {
            ++count;
        }
        Assert.assertEquals((String)"N26 iterate corner max 0 0", (long)7L, (long)count);
    }
}

