/*
 * Decompiled with CFR 0.152.
 */
package misc.grid;

import misc.Voxel;
import misc.grid.RegularGrid3;

public final class N6Iterator {
    private int _step;
    private int _x;
    private int _y;
    private int _z;
    private final int _min_x;
    private int _min_y;
    private int _min_z;
    private final int _max_x;
    private final int _max_y;
    private final int _max_z;

    public N6Iterator(RegularGrid3 g3) {
        this._min_z = 0;
        this._min_y = 0;
        this._min_x = 0;
        this._max_x = g3.get_dim_x() - 1;
        this._max_y = g3.get_dim_y() - 1;
        this._max_z = g3.get_dim_z() - 1;
    }

    public N6Iterator(int min_x, int min_y, int min_z, int max_x, int max_y, int max_z) {
        this._min_x = min_x;
        this._min_y = min_y;
        this._min_z = min_z;
        this._max_x = max_x;
        this._max_y = max_y;
        this._max_z = max_z;
    }

    public void init(int x, int y, int z) {
        this._x = x;
        this._y = y;
        this._z = z;
        this._step = 0;
    }

    public void init(Voxel pos) {
        this._x = pos._x;
        this._y = pos._y;
        this._z = pos._z;
        this._step = 0;
    }

    public boolean next(Voxel v) {
        switch (this._step) {
            case 0: {
                ++this._step;
                if (this._x > this._min_x) {
                    v.set(this._x - 1, this._y, this._z);
                    return true;
                }
            }
            case 1: {
                ++this._step;
                if (this._y > this._min_y) {
                    v.set(this._x, this._y - 1, this._z);
                    return true;
                }
            }
            case 2: {
                ++this._step;
                if (this._z > this._min_z) {
                    v.set(this._x, this._y, this._z - 1);
                    return true;
                }
            }
            case 3: {
                ++this._step;
                if (this._x < this._max_x) {
                    v.set(this._x + 1, this._y, this._z);
                    return true;
                }
            }
            case 4: {
                ++this._step;
                if (this._y < this._max_y) {
                    v.set(this._x, this._y + 1, this._z);
                    return true;
                }
            }
            case 5: {
                ++this._step;
                if (this._z >= this._max_z) break;
                v.set(this._x, this._y, this._z + 1);
                return true;
            }
        }
        return false;
    }

    public boolean next_unsafe(Voxel v) {
        ++this._step;
        switch (this._step) {
            case 1: {
                v.set(this._x - 1, this._y, this._z);
                return true;
            }
            case 2: {
                v.set(this._x, this._y - 1, this._z);
                return true;
            }
            case 3: {
                v.set(this._x, this._y, this._z - 1);
                return true;
            }
            case 4: {
                v.set(this._x + 1, this._y, this._z);
                return true;
            }
            case 5: {
                v.set(this._x, this._y + 1, this._z);
                return true;
            }
            case 6: {
                v.set(this._x, this._y, this._z + 1);
                return true;
            }
        }
        return false;
    }
}

