/*
 * Decompiled with CFR 0.152.
 */
package misc.grid;

import misc.Voxel;
import misc.grid.N6Iterator;
import org.junit.Assert;
import org.junit.Test;

public class N6IteratorTest {
    @Test
    public void middle() {
        N6Iterator i6 = new N6Iterator(0, 0, 0, 100, 100, 100);
        Voxel v = new Voxel();
        i6.init(new Voxel(15, 15, 15));
        int count = 0;
        while (i6.next(v)) {
            ++count;
        }
        Assert.assertEquals((String)"n6 iterate middle", (long)6L, (long)count);
    }

    @Test
    public void border_but_no_corner() {
        N6Iterator i6 = new N6Iterator(0, 0, 0, 100, 100, 100);
        Voxel v = new Voxel();
        i6.init(new Voxel(0, 15, 15));
        int count = 0;
        while (i6.next(v)) {
            ++count;
        }
        Assert.assertEquals((String)"n6 iterate border but no corner x=0", (long)5L, (long)count);
        i6.init(new Voxel(100, 15, 15));
        count = 0;
        while (i6.next(v)) {
            ++count;
        }
        Assert.assertEquals((String)"n6 iterate border but no corner x=max", (long)5L, (long)count);
        i6.init(new Voxel(15, 0, 15));
        count = 0;
        while (i6.next(v)) {
            ++count;
        }
        Assert.assertEquals((String)"n6 iterate border but no corner y=0", (long)5L, (long)count);
        i6.init(new Voxel(15, 100, 15));
        count = 0;
        while (i6.next(v)) {
            ++count;
        }
        Assert.assertEquals((String)"n6 iterate border but no corner y=max", (long)5L, (long)count);
        i6.init(new Voxel(15, 15, 0));
        count = 0;
        while (i6.next(v)) {
            ++count;
        }
        Assert.assertEquals((String)"n6 iterate border but no corner z=0", (long)5L, (long)count);
        i6.init(new Voxel(15, 15, 100));
        count = 0;
        while (i6.next(v)) {
            ++count;
        }
        Assert.assertEquals((String)"n6 iterate border but no corner z=max", (long)5L, (long)count);
    }

    @Test
    public void corner() {
        N6Iterator i6 = new N6Iterator(0, 0, 0, 100, 100, 100);
        Voxel v = new Voxel();
        i6.init(new Voxel(0, 0, 0));
        int count = 0;
        while (i6.next(v)) {
            ++count;
        }
        Assert.assertEquals((String)"n6 iterate corner 0 0 0", (long)3L, (long)count);
        i6.init(new Voxel(100, 0, 0));
        count = 0;
        while (i6.next(v)) {
            ++count;
        }
        Assert.assertEquals((String)"n6 iterate corner max 0 0", (long)3L, (long)count);
    }
}

