/*
 * Decompiled with CFR 0.152.
 */
package misc.grid;

import misc.grid.AbstractRegularGrid3i;
import misc.grid.RegularGrid3i;

public class PaddedRegularGrid3i
extends AbstractRegularGrid3i {
    private final RegularGrid3i _grid;
    private final int _padding;
    private final int _padding_y_offset;
    private final int _padding_z_offset;

    public PaddedRegularGrid3i(RegularGrid3i grid, int padding) {
        super(grid.get_dim_x(), grid.get_dim_y(), grid.get_dim_z(), grid.get_max_voxel_value());
        this._grid = grid;
        this._padding = padding;
        this._padding_y_offset = this._dim_x + 2 * padding;
        this._padding_z_offset = (this._dim_y + 2 * padding) * this._padding_y_offset;
    }

    @Override
    public int coordinates_to_index(int x, int y, int z) {
        return x + this._padding + (y + this._padding) * this._padding_y_offset + (z + this._padding) * this._padding_z_offset;
    }

    @Override
    public int get(int index) {
        int x = index % this._padding_y_offset - this._padding;
        if (!this.coordinate_is_in_valid_region(x, this._dim_x)) {
            return 0;
        }
        int y = (index -= x) % this._padding_z_offset / this._padding_y_offset - this._padding;
        if (!this.coordinate_is_in_valid_region(y, this._dim_y)) {
            return 0;
        }
        int z = (index -= y) / this._padding_z_offset - this._padding;
        if (!this.coordinate_is_in_valid_region(z, this._dim_z)) {
            return 0;
        }
        return this._grid.get(x, y, z);
    }

    private boolean coordinate_is_in_valid_region(int coordinate, int dim) {
        return coordinate >= 0 && coordinate < dim;
    }

    private boolean coordinates_are_in_valid_region(int x, int y, int z) {
        return this.coordinate_is_in_valid_region(x, this._dim_x) && this.coordinate_is_in_valid_region(y, this._dim_y) && this.coordinate_is_in_valid_region(z, this._dim_z);
    }

    @Override
    public int get(int x, int y, int z) {
        if (this.coordinates_are_in_valid_region(x, y, z)) {
            return this._grid.get(x, y, z);
        }
        return super.get(x, y, z);
    }

    @Override
    public int get_index_offset_for_y_plus_1() {
        return this._padding_y_offset;
    }

    @Override
    public int get_index_offset_for_z_plus_1() {
        return this._padding_z_offset;
    }
}

