/*
 * Decompiled with CFR 0.152.
 */
package misc.grid;

import junit.framework.Assert;
import misc.grid.MutableRegularGrid3i;
import misc.grid.PaddedRegularGrid3i;
import misc.grid.RegularGrid3i;
import misc.grid.RegularGrid3iAbstractTest;
import misc.grid.VoxelCube;
import org.junit.Test;

public class PaddedRegularGrid3iTest
extends RegularGrid3iAbstractTest {
    private final int _dim_x = 2;
    private final int _dim_y = 3;
    private final int _dim_z = 4;
    private final int _padding = 2;
    private final RegularGrid3i _padded_grid;
    private final MutableRegularGrid3i _grid = new VoxelCube(2, 3, 4, 0);

    public PaddedRegularGrid3iTest() {
        super(new PaddedRegularGrid3i(new VoxelCube(2, 3, 4, 0), 2));
        int i = 0;
        while (i < this._grid.get_number_of_voxels()) {
            this._grid.set(i, i + 1);
            ++i;
        }
        this._padded_grid = new PaddedRegularGrid3i(this._grid, 2);
    }

    @Test
    public void test_coordinates_to_index() {
        int i = 0;
        int z = -2;
        while (z < 6) {
            int y = -2;
            while (y < 5) {
                int x = -2;
                while (x < 4) {
                    Assert.assertEquals((int)i, (int)this._padded_grid.coordinates_to_index(x, y, z));
                    ++i;
                    ++x;
                }
                ++y;
            }
            ++z;
        }
    }

    @Test
    public void test_get_index_for_non_padding_indexes() {
        int i = 1;
        int z = 0;
        while (z < 4) {
            int y = 0;
            while (y < 3) {
                int x = 0;
                while (x < 2) {
                    int index = this._padded_grid.coordinates_to_index(x, y, z);
                    Assert.assertEquals((int)i, (int)this._padded_grid.get(index));
                    ++i;
                    ++x;
                }
                ++y;
            }
            ++z;
        }
    }

    @Test
    public void test_get_index_for_padding_indexes() {
        int z;
        int x = -2;
        while (x < 0) {
            int y = -2;
            while (y < 0) {
                Assert.assertEquals((int)0, (int)this.calculate_index_and_get(x, y, -2));
                Assert.assertEquals((int)0, (int)this.calculate_index_and_get(x, y, -1));
                Assert.assertEquals((int)0, (int)this.calculate_index_and_get(x, y, 4));
                Assert.assertEquals((int)0, (int)this.calculate_index_and_get(x, y, 5));
                ++y;
            }
            ++x;
        }
        int y = -2;
        while (y < 0) {
            z = -2;
            while (z < 0) {
                Assert.assertEquals((int)0, (int)this.calculate_index_and_get(-2, y, z));
                Assert.assertEquals((int)0, (int)this.calculate_index_and_get(-1, y, z));
                Assert.assertEquals((int)0, (int)this.calculate_index_and_get(4, y, z));
                Assert.assertEquals((int)0, (int)this.calculate_index_and_get(5, y, z));
                ++z;
            }
            ++y;
        }
        x = -2;
        while (x < 0) {
            z = -2;
            while (z < 0) {
                Assert.assertEquals((int)0, (int)this.calculate_index_and_get(x, -2, z));
                Assert.assertEquals((int)0, (int)this.calculate_index_and_get(x, -1, z));
                Assert.assertEquals((int)0, (int)this.calculate_index_and_get(x, 4, z));
                Assert.assertEquals((int)0, (int)this.calculate_index_and_get(x, 5, z));
                ++z;
            }
            ++x;
        }
    }

    private int calculate_index_and_get(int x, int y, int z) {
        int index = this._padded_grid.coordinates_to_index(x, y, z);
        return this._padded_grid.get(index);
    }

    @Test
    public void test_get_xyz_for_non_padding_indexes() {
        int i = 1;
        int z = 0;
        while (z < 4) {
            int y = 0;
            while (y < 3) {
                int x = 0;
                while (x < 2) {
                    Assert.assertEquals((int)i, (int)this._padded_grid.get(x, y, z));
                    ++i;
                    ++x;
                }
                ++y;
            }
            ++z;
        }
    }

    @Test
    public void test_get_xyz_for_padding_indexes() {
        int z;
        int x = -2;
        while (x < 0) {
            int y = -2;
            while (y < 0) {
                Assert.assertEquals((int)0, (int)this._padded_grid.get(x, y, -2));
                Assert.assertEquals((int)0, (int)this._padded_grid.get(x, y, -1));
                Assert.assertEquals((int)0, (int)this._padded_grid.get(x, y, 4));
                Assert.assertEquals((int)0, (int)this._padded_grid.get(x, y, 5));
                ++y;
            }
            ++x;
        }
        int y = -2;
        while (y < 0) {
            z = -2;
            while (z < 0) {
                Assert.assertEquals((int)0, (int)this._padded_grid.get(-2, y, z));
                Assert.assertEquals((int)0, (int)this._padded_grid.get(-1, y, z));
                Assert.assertEquals((int)0, (int)this._padded_grid.get(4, y, z));
                Assert.assertEquals((int)0, (int)this._padded_grid.get(5, y, z));
                ++z;
            }
            ++y;
        }
        x = -2;
        while (x < 0) {
            z = -2;
            while (z < 0) {
                Assert.assertEquals((int)0, (int)this._padded_grid.get(x, -2, z));
                Assert.assertEquals((int)0, (int)this._padded_grid.get(x, -1, z));
                Assert.assertEquals((int)0, (int)this._padded_grid.get(x, 4, z));
                Assert.assertEquals((int)0, (int)this._padded_grid.get(x, 5, z));
                ++z;
            }
            ++x;
        }
    }

    @Override
    @Test
    public void testCoordinateToIndex() {
        Assert.assertEquals((int)0, (int)this._padded_grid.coordinates_to_index(-2, -2, -2));
        int index_of_zero = this._padded_grid.coordinates_to_index(0, 0, 0);
        Assert.assertEquals((int)(index_of_zero + 1), (int)this._padded_grid.coordinates_to_index(1, 0, 0));
        Assert.assertEquals((int)(index_of_zero + this._index_offset_for_y_plus_1), (int)this._padded_grid.coordinates_to_index(0, 1, 0));
        Assert.assertEquals((int)(index_of_zero + this._index_offset_for_z_plus_1), (int)this._padded_grid.coordinates_to_index(0, 0, 1));
    }
}

