/*
 * Decompiled with CFR 0.152.
 */
package misc.grid;

import junit.framework.Assert;
import misc.grid.RegularGrid3i;
import org.junit.Test;

public abstract class RegularGrid3iAbstractTest {
    protected final int _x_size;
    protected final int _y_size;
    protected final int _z_size;
    protected final int _number_of_voxels;
    protected final int _index_offset_for_y_plus_1;
    protected final int _index_offset_for_z_plus_1;
    private RegularGrid3i _grid;

    public RegularGrid3iAbstractTest(RegularGrid3i grid) {
        this._grid = grid;
        this._x_size = grid.get_dim_x();
        this._y_size = grid.get_dim_y();
        this._z_size = grid.get_dim_z();
        this._number_of_voxels = this._x_size * this._y_size * this._z_size;
        this._index_offset_for_y_plus_1 = grid.get_index_offset_for_y_plus_1();
        this._index_offset_for_z_plus_1 = grid.get_index_offset_for_z_plus_1();
    }

    @Test
    public void testGetNumberOfVoxels() {
        Assert.assertEquals((int)this._number_of_voxels, (int)this._grid.get_number_of_voxels());
    }

    @Test
    public void testCoordinateToIndex() {
        Assert.assertEquals((int)0, (int)this._grid.coordinates_to_index(0, 0, 0));
        Assert.assertEquals((int)1, (int)this._grid.coordinates_to_index(1, 0, 0));
        Assert.assertEquals((int)this._index_offset_for_y_plus_1, (int)this._grid.coordinates_to_index(0, 1, 0));
        Assert.assertEquals((int)this._index_offset_for_z_plus_1, (int)this._grid.coordinates_to_index(0, 0, 1));
        Assert.assertEquals((int)(this._number_of_voxels - 1), (int)this._grid.coordinates_to_index(this._x_size - 1, this._y_size - 1, this._z_size - 1));
    }
}

