/*
 * Decompiled with CFR 0.152.
 */
package misc.grid;

import misc.grid.AbstractMutableRegularGrid3i;
import misc.grid.RegularGrid3i;

public final class VoxelCube32Pack16
extends AbstractMutableRegularGrid3i {
    public VoxelCube32Pack16(int dim_x, int dim_y, int dim_z) {
        super(dim_x, dim_y, dim_z);
    }

    public VoxelCube32Pack16(RegularGrid3i rg3i) {
        super(rg3i);
    }

    @Override
    protected int get_data_size() {
        int data_size = this.get_number_of_voxels() / 2 + 1;
        return data_size;
    }

    @Override
    public int get(int i) {
        return (i & 1) == 0 ? this._data[i >>> 1] & 0xFFFF : this._data[i >>> 1] >>> 16;
    }

    @Override
    public int get(int x, int y, int z) {
        int index_of_xyz = this.coordinates_to_index(x, y, z);
        int halfed_index = index_of_xyz >>> 1;
        return (index_of_xyz & 1) == 0 ? this._data[halfed_index] & 0xFFFF : this._data[halfed_index] >>> 16;
    }

    @Override
    public void set(int i, int value) {
        int i_halfed = i >>> 1;
        if ((i & 1) == 0) {
            int n = i_halfed;
            this._data[n] = this._data[n] & 0xFFFF0000;
            int n2 = i_halfed;
            this._data[n2] = this._data[n2] | value;
        } else {
            int n = i_halfed;
            this._data[n] = this._data[n] & 0xFFFF;
            int n3 = i_halfed;
            this._data[n3] = this._data[n3] | value << 16;
        }
    }

    @Override
    public void set(int x, int y, int z, int value) {
        int index_of_xyz = this.coordinates_to_index(x, y, z);
        int halfed_index = index_of_xyz >>> 1;
        if ((x & 1) == 0) {
            int n = halfed_index;
            this._data[n] = this._data[n] & 0xFFFF0000;
            int n2 = halfed_index;
            this._data[n2] = this._data[n2] | value;
        } else {
            int n = halfed_index;
            this._data[n] = this._data[n] & 0xFFFF;
            int n3 = halfed_index;
            this._data[n3] = this._data[n3] | value << 16;
        }
    }

    @Override
    public void add(int i, int inc) {
        int value = this.get(i) + inc & 0xFFFF;
        this.set(i, value);
    }
}

