/*
 * Decompiled with CFR 0.152.
 */
package misc.grid;

import misc.grid.AbstractMutableRegularGrid3i;
import misc.grid.RegularGrid3i;

public final class VoxelCube32Pack8
extends AbstractMutableRegularGrid3i {
    public VoxelCube32Pack8(int dim_x, int dim_y, int dim_z) {
        super(dim_x, dim_y, dim_z);
    }

    public VoxelCube32Pack8(RegularGrid3i rg3i) {
        super(rg3i);
    }

    @Override
    protected int get_data_size() {
        int data_size = this.get_number_of_voxels() / 4 + 1;
        return data_size;
    }

    @Override
    public int get(int i) {
        int i_divied_by_4 = i >>> 2;
        switch (i & 3) {
            case 0: {
                return this._data[i_divied_by_4] & 0xFF;
            }
            case 1: {
                return (this._data[i_divied_by_4] & 0xFF00) >>> 8;
            }
            case 2: {
                return (this._data[i_divied_by_4] & 0xFF0000) >>> 16;
            }
        }
        return (this._data[i_divied_by_4] & 0xFF000000) >>> 24;
    }

    @Override
    public void set(int i, int value) {
        int i_divied_by_4 = i >>> 2;
        switch (i & 3) {
            case 0: {
                int n = i_divied_by_4;
                this._data[n] = this._data[n] & 0xFFFFFF00;
                int n2 = i_divied_by_4;
                this._data[n2] = this._data[n2] | value;
                break;
            }
            case 1: {
                int n = i_divied_by_4;
                this._data[n] = this._data[n] & 0xFFFF00FF;
                int n3 = i_divied_by_4;
                this._data[n3] = this._data[n3] | value << 8;
                break;
            }
            case 2: {
                int n = i_divied_by_4;
                this._data[n] = this._data[n] & 0xFF00FFFF;
                int n4 = i_divied_by_4;
                this._data[n4] = this._data[n4] | value << 16;
                break;
            }
            default: {
                int n = i_divied_by_4;
                this._data[n] = this._data[n] & 0xFFFFFF;
                int n5 = i_divied_by_4;
                this._data[n5] = this._data[n5] | value << 24;
            }
        }
    }

    @Override
    public void add(int i, int inc) {
        int value = this.get(i) + inc & 0xFF;
        this.set(i, value);
    }
}

