/*
 * Decompiled with CFR 0.152.
 */
package misc.grid.filter;

import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import misc.grid.RegularGrid3;
import misc.grid.RegularGrid3i;
import misc.grid.filter.BasicFilterOperations;
import misc.grid.filter.GradientFilter;
import misc.grid.filter.GridAndGradientFilter;
import misc.grid.filter.GridFilter;
import misc.grid.gradients.GradientFunction;

public abstract class AbstractFilter
extends BasicFilterOperations
implements GridFilter,
GradientFilter,
GridAndGradientFilter {
    protected final int _index_offset_for_y_plus_1;
    protected final int _index_offset_for_z_plus_1;
    protected final int _max_voxel_value;
    protected final RegularGrid3i _volume;
    protected final GradientFunction _gradient_function;

    AbstractFilter(RegularGrid3i volume, GradientFunction gradient_function) {
        super(gradient_function);
        this._gradient_function = gradient_function;
        this._volume = volume;
        RegularGrid3 grid = this.get_non_null_grid();
        this._index_offset_for_y_plus_1 = grid.get_index_offset_for_y_plus_1();
        this._index_offset_for_z_plus_1 = grid.get_index_offset_for_z_plus_1();
        this._max_voxel_value = grid.get_max_voxel_value();
    }

    protected RegularGrid3 get_non_null_grid() {
        RegularGrid3 instance;
        RegularGrid3 regularGrid3 = instance = this._volume == null ? this._gradient_function : this._volume;
        if (instance == null) {
            throw new IllegalStateException("Only one instance may be null");
        }
        return instance;
    }

    @Override
    public float sample_grid_value_at(Point3f p) {
        return this.sample_grid_value_at(p.x, p.y, p.z);
    }

    @Override
    public void sample_gradient_at(Point3f p, Vector3f gradient_return) {
        this.sample_gradient_at(p.x, p.y, p.z, gradient_return);
    }

    @Override
    public float sample_grid_value_and_gradient_at(Point3f p, Vector3f gradient_return) {
        return this.sample_grid_value_and_gradient_at(p.x, p.y, p.z, gradient_return);
    }
}

