/*
 * Decompiled with CFR 0.152.
 */
package misc.grid.filter;

import javax.vecmath.Vector3f;
import misc.grid.gradients.GradientFunction;

public class BasicFilterOperations {
    protected final GradientFunction _gradient_function;
    private final Vector3f temp_vector1 = new Vector3f();
    private final Vector3f temp_vector2 = new Vector3f();

    public BasicFilterOperations(GradientFunction gradient_function) {
        this._gradient_function = gradient_function;
    }

    protected void add_scaled_vector(Vector3f t1, Vector3f t2, float s) {
        t1.x += s * t2.x;
        t1.y += s * t2.y;
        t1.z += s * t2.z;
    }

    protected void add_scaled_gradient(int index, float f, Vector3f store) {
        this._gradient_function.gradient_at(index, this.temp_vector1);
        store.x += this.temp_vector1.x * f;
        store.y += this.temp_vector1.y * f;
        store.z += this.temp_vector1.z * f;
    }

    public void get_interpolated(int index_a, int index_b, float w, Vector3f store) {
        this._gradient_function.gradient_at(index_a, this.temp_vector1);
        this._gradient_function.gradient_at(index_b, this.temp_vector2);
        float v = 1.0f - w;
        store.x = this.temp_vector1.x * v + this.temp_vector2.x * w;
        store.y = this.temp_vector1.y * v + this.temp_vector2.y * w;
        store.z = this.temp_vector1.z * v + this.temp_vector2.z * w;
    }
}

