/*
 * Decompiled with CFR 0.152.
 */
package misc.grid.filter;

import javax.vecmath.Vector3f;
import misc.grid.RegularGrid3;
import misc.grid.RegularGrid3i;
import misc.grid.filter.AbstractFilter;
import misc.grid.filter.FilterOptions;
import misc.grid.filter.IndexOffsetCalculator;
import misc.grid.gradients.GradientFunction;
import misc.helper.Helper;

public final class CubicFilter
extends AbstractFilter {
    protected static final float NORMALIZATION = 0.0046296297f;
    private final float _inner_3;
    private final float _inner_2;
    private final float _inner_0;
    private final float _outer_3;
    private final float _outer_2;
    private final float _outer_1;
    private final float _outer_0;
    private final int[] _index_offsets;
    private final Vector3f sum_x_gradient = new Vector3f();
    private final Vector3f sum_y_gradient = new Vector3f();
    private final float[] x_weights = new float[4];
    private final float[] y_weights = new float[4];
    private final float[] z_weights = new float[4];

    @Override
    public int get_filter_radius() {
        return 2;
    }

    CubicFilter(RegularGrid3i volume, GradientFunction gradientFunction, CubicFilterOptions options) {
        super(volume, gradientFunction);
        float b = options._b;
        float c = options._c;
        this._inner_3 = 12.0f - 9.0f * b - 6.0f * c;
        this._inner_2 = -18.0f + 12.0f * b + 6.0f * c;
        this._inner_0 = 6.0f - 2.0f * b;
        this._outer_3 = -b - 6.0f * c;
        this._outer_2 = 6.0f * b + 30.0f * c;
        this._outer_1 = -12.0f * b - 48.0f * c;
        this._outer_0 = 8.0f * b + 24.0f * c;
        RegularGrid3 grid = this.get_non_null_grid();
        this._index_offsets = IndexOffsetCalculator.calculate_index_offsets(grid, this.get_filter_radius());
    }

    float outer_weighting_function(float x) {
        return ((this._outer_3 * x + this._outer_2) * x + this._outer_1) * x + this._outer_0;
    }

    float inner_weighting_function(float x) {
        return (this._inner_3 * x + this._inner_2) * x * x + this._inner_0;
    }

    void evaluate_for_one_dimension(float f, float f_rounded_down, float[] weight_store) {
        weight_store[0] = this.outer_weighting_function(f - f_rounded_down);
        weight_store[1] = this.inner_weighting_function(f - (f_rounded_down + 1.0f));
        weight_store[2] = this.inner_weighting_function(f_rounded_down + 2.0f - f);
        weight_store[3] = this.outer_weighting_function(f_rounded_down + 3.0f - f);
    }

    @Override
    public float sample_grid_value_and_gradient_at(float x, float y, float z, Vector3f gradient_return) {
        int x_rounded_down = (int)x - 1;
        int y_rounded_down = (int)y - 1;
        int z_rounded_down = (int)z - 1;
        int index_base = this._volume.coordinates_to_index(x_rounded_down, y_rounded_down, z_rounded_down);
        this.evaluate_for_one_dimension(x, x_rounded_down, this.x_weights);
        this.evaluate_for_one_dimension(y, y_rounded_down, this.y_weights);
        this.evaluate_for_one_dimension(z, z_rounded_down, this.z_weights);
        float sum = 0.0f;
        gradient_return.set(0.0f, 0.0f, 0.0f);
        int k = 0;
        int cz = 0;
        while (cz < 4) {
            float sum_y = 0.0f;
            this.sum_y_gradient.set(0.0f, 0.0f, 0.0f);
            int cy = 0;
            while (cy < 4) {
                float sum_x = 0.0f;
                this.sum_x_gradient.set(0.0f, 0.0f, 0.0f);
                int cx = 0;
                while (cx < 4) {
                    int index = index_base + this._index_offsets[k];
                    sum_x += (float)this._volume.get(index) * this.x_weights[cx];
                    this.add_scaled_gradient(index, this.x_weights[cx], this.sum_x_gradient);
                    ++k;
                    ++cx;
                }
                sum_y += sum_x * this.y_weights[cy];
                this.add_scaled_vector(this.sum_y_gradient, this.sum_x_gradient, this.y_weights[cy]);
                ++cy;
            }
            sum += sum_y * this.z_weights[cz];
            this.add_scaled_vector(gradient_return, this.sum_y_gradient, this.z_weights[cz]);
            ++cz;
        }
        gradient_return.scale(0.0046296297f);
        return Helper.clamp(sum *= 0.0046296297f, 0.0f, this._max_voxel_value);
    }

    @Override
    public float sample_grid_value_at(float x, float y, float z) {
        int x_rounded_down = (int)x - 1;
        int y_rounded_down = (int)y - 1;
        int z_rounded_down = (int)z - 1;
        int index_base = this._volume.coordinates_to_index(x_rounded_down, y_rounded_down, z_rounded_down);
        this.evaluate_for_one_dimension(x, x_rounded_down, this.x_weights);
        this.evaluate_for_one_dimension(y, y_rounded_down, this.y_weights);
        this.evaluate_for_one_dimension(z, z_rounded_down, this.z_weights);
        float sum = 0.0f;
        int k = 0;
        int cz = 0;
        while (cz < 4) {
            float sum_y = 0.0f;
            int cy = 0;
            while (cy < 4) {
                float sum_x = 0.0f;
                int cx = 0;
                while (cx < 4) {
                    int index = index_base + this._index_offsets[k];
                    sum_x += (float)this._volume.get(index) * this.x_weights[cx];
                    ++k;
                    ++cx;
                }
                sum_y += sum_x * this.y_weights[cy];
                ++cy;
            }
            sum += sum_y * this.z_weights[cz];
            ++cz;
        }
        return Helper.clamp(sum *= 0.0046296297f, 0.0f, this._max_voxel_value);
    }

    @Override
    public void sample_gradient_at(float x, float y, float z, Vector3f gradient_return) {
        int x_rounded_down = (int)x - 1;
        int y_rounded_down = (int)y - 1;
        int z_rounded_down = (int)z - 1;
        int index_base = this._gradient_function.coordinates_to_index(x_rounded_down, y_rounded_down, z_rounded_down);
        this.evaluate_for_one_dimension(x, x_rounded_down, this.x_weights);
        this.evaluate_for_one_dimension(y, y_rounded_down, this.y_weights);
        this.evaluate_for_one_dimension(z, z_rounded_down, this.z_weights);
        gradient_return.set(0.0f, 0.0f, 0.0f);
        int k = 0;
        int cz = 0;
        while (cz < 4) {
            this.sum_y_gradient.set(0.0f, 0.0f, 0.0f);
            int cy = 0;
            while (cy < 4) {
                this.sum_x_gradient.set(0.0f, 0.0f, 0.0f);
                int cx = 0;
                while (cx < 4) {
                    int index = index_base + this._index_offsets[k];
                    this.add_scaled_gradient(index, this.x_weights[cx], this.sum_x_gradient);
                    ++k;
                    ++cx;
                }
                this.add_scaled_vector(this.sum_y_gradient, this.sum_x_gradient, this.y_weights[cy]);
                ++cy;
            }
            this.add_scaled_vector(gradient_return, this.sum_y_gradient, this.z_weights[cz]);
            ++cz;
        }
        gradient_return.scale(0.0046296297f);
    }

    public static final class CubicFilterOptions
    implements FilterOptions {
        public float _b = 0.0f;
        public float _c = 0.0f;

        public CubicFilterOptions(float b, float c) {
            this._b = b;
            this._c = c;
        }
    }
}

