/*
 * Decompiled with CFR 0.152.
 */
package misc.grid.filter;

import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import misc.grid.MutableRegularGrid3i;
import misc.grid.VoxelCube;
import misc.grid.filter.FilterFactory;
import misc.grid.filter.FilterOptions;
import misc.grid.filter.FilterType;
import misc.grid.filter.FilterValueExpecter;
import misc.grid.filter.GradientFilter;
import misc.grid.filter.GridAndGradientFilter;
import misc.grid.filter.GridFilter;
import misc.grid.gradients.GradientFunctionMock;
import org.junit.Assert;

public abstract class FilterAbstractTest {
    private final float STEP_SIZE = 0.125f;
    protected final int DIM;
    protected final MutableRegularGrid3i _volume;
    protected final GridFilter _grid_filter;
    protected final GradientFilter _gradient_filter;
    protected final GridAndGradientFilter _combined_filter;
    protected final Point3f _center_point;
    protected final float _test_accuracy;
    private final Point3f _filter_point = new Point3f();
    private final Vector3f _temp_vector = new Vector3f();

    public FilterAbstractTest(int cube_dimensions, float test_accuracy, FilterType type, FilterOptions filter_options) {
        this.DIM = cube_dimensions;
        this._test_accuracy = test_accuracy;
        float cp_coords = ((float)this.DIM - 1.0f) / 2.0f;
        this._center_point = new Point3f(cp_coords, cp_coords, cp_coords);
        this._volume = new VoxelCube(this.DIM, this.DIM, this.DIM);
        this._grid_filter = FilterFactory.create_grid_filter(this._volume, type, filter_options);
        GradientFunctionMock gf = new GradientFunctionMock(this._volume);
        this._gradient_filter = FilterFactory.create_gradient_filter(gf, type, filter_options);
        this._combined_filter = FilterFactory.create_grid_and_gradient_filter(this._volume, gf, type, filter_options);
    }

    protected void assert_equals(float expected, float actual) {
        Assert.assertEquals((double)expected, (double)actual, (double)this._test_accuracy);
    }

    protected void assert_equals_exactly(float expected, float actual) {
        Assert.assertEquals((double)expected, (double)actual, (double)0.0);
    }

    protected void test_get_filter_radius(int expected_radius) {
        Assert.assertEquals((long)expected_radius, (long)this._grid_filter.get_filter_radius());
        Assert.assertEquals((long)expected_radius, (long)this._gradient_filter.get_filter_radius());
        Assert.assertEquals((long)expected_radius, (long)this._combined_filter.get_filter_radius());
    }

    protected void sample_value_at_and_expect(float x, float y, float z, float expected) {
        this._filter_point.x = x;
        this._filter_point.y = y;
        this._filter_point.z = z;
        float grid_value = this.sample_grid_value(this._grid_filter);
        float vector_value = this.sample_vector_value(this._gradient_filter);
        float combined_grid_value = this.sample_grid_value(this._combined_filter);
        float combined_vector_value = this.sample_vector_value(this._combined_filter);
        float combined_value = this.sample_combined_value(this._combined_filter);
        this.assert_equals_exactly(expected, grid_value);
        this.assert_equals_exactly(expected, vector_value);
        this.assert_equals_exactly(expected, combined_grid_value);
        this.assert_equals_exactly(expected, combined_vector_value);
        this.assert_equals_exactly(expected, combined_value);
    }

    private float sample_grid_value(GridFilter filter) {
        float point_value = this._grid_filter.sample_grid_value_at(this._filter_point);
        float coordinate_value = this._grid_filter.sample_grid_value_at(this._filter_point.x, this._filter_point.y, this._filter_point.z);
        this.assert_equals_exactly(point_value, coordinate_value);
        return point_value;
    }

    private float sample_vector_value(GradientFilter filter) {
        filter.sample_gradient_at(this._filter_point, this._temp_vector);
        float point_value = this.get_temp_vector_value();
        filter.sample_gradient_at(this._filter_point.x, this._filter_point.y, this._filter_point.z, this._temp_vector);
        float coordinate_value = this.get_temp_vector_value();
        this.assert_equals_exactly(point_value, coordinate_value);
        return point_value;
    }

    private float get_temp_vector_value() {
        float x = this._temp_vector.x;
        float y = this._temp_vector.y;
        float z = this._temp_vector.z;
        this.assert_equals_exactly(x, y);
        this.assert_equals_exactly(x, z);
        return x;
    }

    private float sample_combined_value(GridAndGradientFilter filter) {
        float point_grid_value = filter.sample_grid_value_and_gradient_at(this._filter_point, this._temp_vector);
        float point_vector_value = this.get_temp_vector_value();
        float coordinate_grid_value = filter.sample_grid_value_and_gradient_at(this._filter_point.x, this._filter_point.y, this._filter_point.z, this._temp_vector);
        float coordinate_vector_value = this.get_temp_vector_value();
        this.assert_equals_exactly(point_grid_value, point_vector_value);
        this.assert_equals_exactly(point_grid_value, coordinate_grid_value);
        this.assert_equals_exactly(point_grid_value, coordinate_vector_value);
        return point_grid_value;
    }

    protected void reset_cube_and_set_voxel_value(int index) {
        this._volume.clear();
        this._volume.set(index, 1);
    }

    protected void test_sample_methods(FilterValueExpecter expecter) {
        float x = 0.0f;
        while (x < (float)(this._volume.get_dim_x() - 1)) {
            float y = 0.0f;
            while (y < (float)(this._volume.get_dim_y() - 1)) {
                float z = 0.0f;
                while (z < (float)(this._volume.get_dim_z() - 1)) {
                    float expected_value = expecter.expect_at(x, y, z);
                    this.sample_value_at_and_expect(x, y, z, expected_value);
                    z += 0.125f;
                }
                y += 0.125f;
            }
            x += 0.125f;
        }
    }
}

