/*
 * Decompiled with CFR 0.152.
 */
package misc.grid.filter;

import misc.grid.RegularGrid3i;
import misc.grid.VoxelCube;
import misc.grid.filter.CubicFilter;
import misc.grid.filter.FilterOptions;
import misc.grid.filter.GradientFilter;
import misc.grid.filter.GridAndGradientFilter;
import misc.grid.filter.GridFilter;
import misc.grid.filter.NearestNeighbourFilter;
import misc.grid.filter.TrilinearFilter;
import misc.grid.filter.WindowedSincFilter;
import misc.grid.gradients.GradientFunction;

public enum FilterType {
    TRILINEAR{

        @Override
        GridAndGradientFilter get_grid_and_gradient_filter(RegularGrid3i volume, GradientFunction gradient_function, FilterOptions filter_options) {
            return new TrilinearFilter(volume, gradient_function);
        }
    }
    ,
    CUBIC{

        @Override
        GridAndGradientFilter get_grid_and_gradient_filter(RegularGrid3i volume, GradientFunction gradient_function, FilterOptions filter_options) {
            return new CubicFilter(volume, gradient_function, (CubicFilter.CubicFilterOptions)filter_options);
        }
    }
    ,
    WINDOWED_SINC{

        @Override
        GridAndGradientFilter get_grid_and_gradient_filter(RegularGrid3i volume, GradientFunction gradient_function, FilterOptions filter_options) {
            return new WindowedSincFilter(volume, gradient_function);
        }
    }
    ,
    NEAREST_NEIGHBOUR{

        @Override
        GridAndGradientFilter get_grid_and_gradient_filter(RegularGrid3i volume, GradientFunction gradient_function, FilterOptions filter_options) {
            return new NearestNeighbourFilter(volume, gradient_function);
        }
    };


    private FilterType() {
    }

    abstract GridAndGradientFilter get_grid_and_gradient_filter(RegularGrid3i var1, GradientFunction var2, FilterOptions var3);

    GridFilter get_grid_filter(RegularGrid3i volume, FilterOptions filter_options) {
        return this.get_grid_and_gradient_filter(volume, null, filter_options);
    }

    GradientFilter get_gradient_filter(GradientFunction gradient_function, FilterOptions filter_options) {
        return this.get_grid_and_gradient_filter(null, gradient_function, filter_options);
    }

    public int get_filter_radius() {
        GridFilter f = this.get_grid_filter(new VoxelCube(0, 0, 0, 0), new CubicFilter.CubicFilterOptions(0.0f, 0.0f));
        return f.get_filter_radius();
    }

    /* synthetic */ FilterType(String string, int n, FilterType filterType) {
        this();
    }
}

