/*
 * Decompiled with CFR 0.152.
 */
package misc.grid.filter;

import misc.grid.BitCube;
import misc.grid.RegularGrid3;
import misc.grid.filter.IndexOffsetCalculator;
import org.junit.Assert;
import org.junit.Test;

public class FilterindexOffsetCalculatorTest {
    private final int CUBE_SIZE = 5;
    private final RegularGrid3 grid = new BitCube(5, 5, 5);

    @Test
    public void testCalculateOffsetsForZeroFilterRadius() {
        int[] offsets = IndexOffsetCalculator.calculate_index_offsets(this.grid, 0);
        Assert.assertEquals((long)1L, (long)offsets.length);
        Assert.assertEquals((long)0L, (long)offsets[0]);
    }

    @Test
    public void testCalculateOffsetsForFilterRadiusOne() {
        int[] offsets = IndexOffsetCalculator.calculate_index_offsets(this.grid, 1);
        Assert.assertEquals((long)8L, (long)offsets.length);
        Assert.assertEquals((long)0L, (long)offsets[0]);
        int last_index_offset = this.grid.coordinates_to_index(1, 1, 1);
        Assert.assertEquals((long)last_index_offset, (long)offsets[7]);
    }

    @Test
    public void testCalculateOffsetsForFilterRadiusTwo() {
        int[] offsets = IndexOffsetCalculator.calculate_index_offsets(this.grid, 2);
        Assert.assertEquals((long)64L, (long)offsets.length);
        Assert.assertEquals((long)0L, (long)offsets[0]);
        int last_index_offset = this.grid.coordinates_to_index(3, 3, 3);
        Assert.assertEquals((long)last_index_offset, (long)offsets[63]);
    }
}

