/*
 * Decompiled with CFR 0.152.
 */
package misc.grid.filter;

import misc.grid.RegularGrid3;

public class IndexOffsetCalculator {
    public static int[] calculate_index_offsets(RegularGrid3 grid, int filter_radius) {
        int values_per_edge = 2 * filter_radius;
        int filter_region_size = values_per_edge * values_per_edge * values_per_edge;
        int number_of_indexes = Math.max(filter_region_size, 1);
        int[] index_offsets = new int[number_of_indexes];
        int v1 = values_per_edge;
        int v2 = v1 * values_per_edge;
        int z = 0;
        while (z < values_per_edge) {
            int y = 0;
            while (y < values_per_edge) {
                int x = 0;
                while (x < values_per_edge) {
                    index_offsets[x + v1 * y + v2 * z] = grid.coordinates_to_index(x, y, z);
                    ++x;
                }
                ++y;
            }
            ++z;
        }
        return index_offsets;
    }
}

