/*
 * Decompiled with CFR 0.152.
 */
package misc.grid.filter;

import javax.vecmath.Vector3f;
import misc.grid.RegularGrid3;
import misc.grid.RegularGrid3i;
import misc.grid.filter.AbstractFilter;
import misc.grid.gradients.GradientFunction;
import misc.helper.Helper;

public final class NearestNeighbourFilter
extends AbstractFilter {
    private final RegularGrid3 _grid = this.get_non_null_grid();

    NearestNeighbourFilter(RegularGrid3i volume, GradientFunction gradient_Function) {
        super(volume, gradient_Function);
    }

    @Override
    public int get_filter_radius() {
        return 0;
    }

    @Override
    public float sample_grid_value_at(float x, float y, float z) {
        int index = this.calculate_nearest_index(x, y, z);
        return this._volume.get(index);
    }

    private int calculate_nearest_index(float x, float y, float z) {
        int x_rounded = Helper.round(x);
        int y_rounded = Helper.round(y);
        int z_rounded = Helper.round(z);
        int index = this._grid.coordinates_to_index(x_rounded, y_rounded, z_rounded);
        return index;
    }

    @Override
    public void sample_gradient_at(float x, float y, float z, Vector3f gradient_return) {
        int index = this.calculate_nearest_index(x, y, z);
        this._gradient_function.gradient_at(index, gradient_return);
    }

    @Override
    public float sample_grid_value_and_gradient_at(float x, float y, float z, Vector3f gradient_return) {
        int index = this.calculate_nearest_index(x, y, z);
        this._gradient_function.gradient_at(index, gradient_return);
        return this._volume.get(index);
    }
}

