/*
 * Decompiled with CFR 0.152.
 */
package misc.grid.filter;

import misc.grid.filter.FilterAbstractTest;
import misc.grid.filter.FilterType;
import misc.grid.filter.FilterValueExpecter;
import misc.helper.Helper;
import org.junit.Before;
import org.junit.Test;

public class NearestNeighbourFilterTest
extends FilterAbstractTest {
    public NearestNeighbourFilterTest() {
        super(2, 0.0f, FilterType.NEAREST_NEIGHBOUR, null);
    }

    @Before
    public void set_up() {
        int i = 0;
        while (i < this._volume.get_number_of_voxels()) {
            this._volume.set(i, i);
            ++i;
        }
    }

    @Test
    public void test_sample_at() {
        this.test_sample_methods(new FilterValueExpecter(){

            @Override
            public float expect_at(double x, double y, double z) {
                int x_rounded = (int)Helper.round(x);
                int y_rounded = (int)Helper.round(y);
                int z_rounded = (int)Helper.round(z);
                return x_rounded + 2 * y_rounded + 4 * z_rounded;
            }
        });
    }

    @Test
    public void test_get_filter_radius() {
        this.test_get_filter_radius(0);
    }
}

