/*
 * Decompiled with CFR 0.152.
 */
package misc.grid.filter;

import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import misc.grid.RegularGrid3i;
import misc.grid.filter.AbstractFilter;
import misc.grid.gradients.GradientFunction;

public final class TrilinearFilter
extends AbstractFilter {
    private final Vector3f i1g = new Vector3f();
    private final Vector3f i2g = new Vector3f();
    private final Vector3f j1g = new Vector3f();
    private final Vector3f j2g = new Vector3f();
    private final Vector3f w1g = new Vector3f();
    private final Vector3f w2g = new Vector3f();

    TrilinearFilter(RegularGrid3i volume, GradientFunction gradient_function) {
        super(volume, gradient_function);
    }

    @Override
    public int get_filter_radius() {
        return 1;
    }

    @Override
    public float sample_grid_value_and_gradient_at(float x, float y, float z, Vector3f gradient_return) {
        int index_x = (int)x;
        int index_y = (int)y;
        int index_z = (int)z;
        int index = this._volume.coordinates_to_index(index_x, index_y, index_z);
        float x_weight = x - (float)index_x;
        float x_weight2 = 1.0f - x_weight;
        float i1 = (float)this._volume.get(index) * x_weight2 + (float)this._volume.get(index + 1) * x_weight;
        this.get_interpolated(index, index + 1, x_weight, this.i1g);
        float i2 = (float)this._volume.get(index += this._index_offset_for_y_plus_1) * x_weight2 + (float)this._volume.get(index + 1) * x_weight;
        this.get_interpolated(index, index + 1, x_weight, this.i2g);
        float j2 = (float)this._volume.get(index += this._index_offset_for_z_plus_1) * x_weight2 + (float)this._volume.get(index + 1) * x_weight;
        this.get_interpolated(index, index + 1, x_weight, this.j2g);
        float j1 = (float)this._volume.get(index -= this._index_offset_for_y_plus_1) * x_weight2 + (float)this._volume.get(index + 1) * x_weight;
        this.get_interpolated(index, index + 1, x_weight, this.j1g);
        float y_weight = y - (float)index_y;
        float y_weight2 = 1.0f - y_weight;
        float w1 = i1 * y_weight2 + i2 * y_weight;
        float w2 = j1 * y_weight2 + j2 * y_weight;
        this.w1g.interpolate((Tuple3f)this.i1g, (Tuple3f)this.i2g, y_weight);
        this.w2g.interpolate((Tuple3f)this.j1g, (Tuple3f)this.j2g, y_weight);
        float z_weight = z - (float)index_z;
        float z_weight2 = 1.0f - z_weight;
        gradient_return.interpolate((Tuple3f)this.w1g, (Tuple3f)this.w2g, z_weight);
        return w1 * z_weight2 + w2 * z_weight;
    }

    @Override
    public float sample_grid_value_at(float x, float y, float z) {
        int index_x = (int)x;
        int index_y = (int)y;
        int index_z = (int)z;
        int index = this._volume.coordinates_to_index(index_x, index_y, index_z);
        float x_weight = x - (float)index_x;
        float x_weight2 = 1.0f - x_weight;
        float i1 = (float)this._volume.get(index) * x_weight2 + (float)this._volume.get(index + 1) * x_weight;
        float i2 = (float)this._volume.get(index += this._index_offset_for_y_plus_1) * x_weight2 + (float)this._volume.get(index + 1) * x_weight;
        float j2 = (float)this._volume.get(index += this._index_offset_for_z_plus_1) * x_weight2 + (float)this._volume.get(index + 1) * x_weight;
        float j1 = (float)this._volume.get(index -= this._index_offset_for_y_plus_1) * x_weight2 + (float)this._volume.get(index + 1) * x_weight;
        float y_weight = y - (float)index_y;
        float y_weight2 = 1.0f - y_weight;
        float w1 = i1 * y_weight2 + i2 * y_weight;
        float w2 = j1 * y_weight2 + j2 * y_weight;
        float z_weight = z - (float)index_z;
        float z_weight2 = 1.0f - z_weight;
        return w1 * z_weight2 + w2 * z_weight;
    }

    @Override
    public void sample_gradient_at(float x, float y, float z, Vector3f gradient_return) {
        int index_x = (int)x;
        int index_y = (int)y;
        int index_z = (int)z;
        int index = this._gradient_function.coordinates_to_index(index_x, index_y, index_z);
        float x_weight = x - (float)index_x;
        this.get_interpolated(index, index + 1, x_weight, this.i1g);
        this.get_interpolated(index += this._index_offset_for_y_plus_1, index + 1, x_weight, this.i2g);
        this.get_interpolated(index += this._index_offset_for_z_plus_1, index + 1, x_weight, this.j2g);
        this.get_interpolated(index -= this._index_offset_for_y_plus_1, index + 1, x_weight, this.j1g);
        float y_weight = y - (float)index_y;
        this.w1g.interpolate((Tuple3f)this.i1g, (Tuple3f)this.i2g, y_weight);
        this.w2g.interpolate((Tuple3f)this.j1g, (Tuple3f)this.j2g, y_weight);
        float z_weight = z - (float)index_z;
        gradient_return.interpolate((Tuple3f)this.w1g, (Tuple3f)this.w2g, z_weight);
    }
}

