/*
 * Decompiled with CFR 0.152.
 */
package misc.grid.filter;

import misc.grid.filter.FilterAbstractTest;
import misc.grid.filter.FilterType;
import misc.grid.filter.FilterValueExpecter;
import org.junit.Test;

public class TrilinearFilterTest
extends FilterAbstractTest {
    final int _index_offset_for_y_plus_1;
    final int _index_offset_for_z_plus_1;

    public TrilinearFilterTest() {
        super(2, 0.0f, FilterType.TRILINEAR, null);
        this._index_offset_for_y_plus_1 = this._volume.get_index_offset_for_y_plus_1();
        this._index_offset_for_z_plus_1 = this._volume.get_index_offset_for_z_plus_1();
    }

    @Test
    public void test_sample_at() {
        int i = 0;
        while (i < this._volume.get_number_of_voxels()) {
            this.reset_cube_and_set_voxel_value(i);
            this.test_sample_methods(this.get_expecter_for_index(i));
            ++i;
        }
    }

    private FilterValueExpecter get_expecter_for_index(final int index) {
        final float value_at_index = this._volume.get(index);
        return new FilterValueExpecter(){

            @Override
            public float expect_at(double x, double y, double z) {
                int index_x = (int)x;
                int index_y = (int)y;
                int index_z = (int)z;
                boolean x_equals_0 = index % 2 == 0;
                boolean y_equals_0 = index % TrilinearFilterTest.this._index_offset_for_z_plus_1 - TrilinearFilterTest.this._index_offset_for_y_plus_1 < 0;
                boolean z_equals_0 = index - TrilinearFilterTest.this._index_offset_for_z_plus_1 < 0;
                float x_weight = (float)x - (float)index_x;
                float y_weight = (float)y - (float)index_y;
                float z_weight = (float)z - (float)index_z;
                if (x_equals_0) {
                    x_weight = 1.0f - x_weight;
                }
                if (y_equals_0) {
                    y_weight = 1.0f - y_weight;
                }
                if (z_equals_0) {
                    z_weight = 1.0f - z_weight;
                }
                return value_at_index * x_weight * y_weight * z_weight;
            }
        };
    }

    @Test
    public void test_get_filter_radius() {
        this.test_get_filter_radius(1);
    }
}

