/*
 * Decompiled with CFR 0.152.
 */
package misc.grid.filter;

import javax.vecmath.Vector3f;
import misc.grid.RegularGrid3;
import misc.grid.RegularGrid3i;
import misc.grid.filter.AbstractFilter;
import misc.grid.filter.IndexOffsetCalculator;
import misc.grid.gradients.GradientFunction;
import misc.helper.Helper;

public final class WindowedSincFilter
extends AbstractFilter {
    private final int _filter_radius = 2;
    private final double _pi_div_xm;
    private final double _four_div_xm;
    private final int[] _index_offsets;
    private final Vector3f sum_x_gradient = new Vector3f();
    private final Vector3f sum_y_gradient = new Vector3f();
    private final float[] _x_weights = new float[4];
    private final float[] _y_weights = new float[4];
    private final float[] _z_weights = new float[4];

    WindowedSincFilter(RegularGrid3i volume, GradientFunction gradientFunction) {
        super(volume, gradientFunction);
        this._pi_div_xm = 1.5707963267948966;
        this._four_div_xm = 2.0;
        RegularGrid3 grid = this.get_non_null_grid();
        this._index_offsets = IndexOffsetCalculator.calculate_index_offsets(grid, this.get_filter_radius());
    }

    @Override
    public int get_filter_radius() {
        return 2;
    }

    public float weighting_function(float x) {
        return (float)((1.0 + Math.cos((double)x * this._pi_div_xm)) * this.sinc((double)x * this._four_div_xm));
    }

    private double sinc(double x) {
        if (x == 0.0) {
            return 1.0;
        }
        return Math.sin(x) / x;
    }

    private void evaluate_filter_for_one_dimension(float f, float f_rounded_down, float[] h_store) {
        h_store[0] = this.weighting_function(f - f_rounded_down);
        h_store[1] = this.weighting_function(f - (f_rounded_down + 1.0f));
        h_store[2] = this.weighting_function(f_rounded_down + 2.0f - f);
        h_store[3] = this.weighting_function(f_rounded_down + 3.0f - f);
    }

    @Override
    public float sample_grid_value_and_gradient_at(float x, float y, float z, Vector3f gradient_return) {
        int x_rounded_down = (int)x - 1;
        int y_rounded_down = (int)y - 1;
        int z_rounded_down = (int)z - 1;
        int index_base = this._volume.coordinates_to_index(x_rounded_down, y_rounded_down, z_rounded_down);
        this.evaluate_filter_for_one_dimension(x, x_rounded_down, this._x_weights);
        this.evaluate_filter_for_one_dimension(y, y_rounded_down, this._y_weights);
        this.evaluate_filter_for_one_dimension(z, z_rounded_down, this._z_weights);
        float sum = 0.0f;
        gradient_return.set(0.0f, 0.0f, 0.0f);
        float norm = 0.0f;
        int k = 0;
        int cz = 0;
        while (cz < 4) {
            float sum_y = 0.0f;
            this.sum_y_gradient.set(0.0f, 0.0f, 0.0f);
            float norm_y = 0.0f;
            int cy = 0;
            while (cy < 4) {
                float sum_x = 0.0f;
                this.sum_x_gradient.set(0.0f, 0.0f, 0.0f);
                float norm_x = 0.0f;
                int cx = 0;
                while (cx < 4) {
                    int index = index_base + this._index_offsets[k];
                    sum_x += (float)this._volume.get(index) * this._x_weights[cx];
                    this.add_scaled_gradient(index, this._x_weights[cx], this.sum_x_gradient);
                    norm_x += this._x_weights[cx];
                    ++k;
                    ++cx;
                }
                sum_y += sum_x * this._y_weights[cy];
                this.add_scaled_vector(this.sum_y_gradient, this.sum_x_gradient, this._y_weights[cy]);
                norm_y += norm_x * this._y_weights[cy];
                ++cy;
            }
            sum += sum_y * this._z_weights[cz];
            this.add_scaled_vector(gradient_return, this.sum_y_gradient, this._z_weights[cz]);
            norm += norm_y * this._z_weights[cz];
            ++cz;
        }
        norm = 1.0f / norm;
        gradient_return.scale(norm);
        return Helper.clamp(sum *= norm, 0.0f, this._max_voxel_value);
    }

    @Override
    public float sample_grid_value_at(float x, float y, float z) {
        int x_rounded_down = (int)x - 1;
        int y_rounded_down = (int)y - 1;
        int z_rounded_down = (int)z - 1;
        int index_base = this._volume.coordinates_to_index(x_rounded_down, y_rounded_down, z_rounded_down);
        this.evaluate_filter_for_one_dimension(x, x_rounded_down, this._x_weights);
        this.evaluate_filter_for_one_dimension(y, y_rounded_down, this._y_weights);
        this.evaluate_filter_for_one_dimension(z, z_rounded_down, this._z_weights);
        float sum = 0.0f;
        float norm = 0.0f;
        int k = 0;
        int cz = 0;
        while (cz < 4) {
            float sum_y = 0.0f;
            float norm_y = 0.0f;
            int cy = 0;
            while (cy < 4) {
                float sum_x = 0.0f;
                float norm_x = 0.0f;
                int cx = 0;
                while (cx < 4) {
                    int index = index_base + this._index_offsets[k];
                    sum_x += (float)this._volume.get(index) * this._x_weights[cx];
                    norm_x += this._x_weights[cx];
                    ++k;
                    ++cx;
                }
                sum_y += sum_x * this._y_weights[cy];
                norm_y += norm_x * this._y_weights[cy];
                ++cy;
            }
            sum += sum_y * this._z_weights[cz];
            norm += norm_y * this._z_weights[cz];
            ++cz;
        }
        norm = 1.0f / norm;
        return Helper.clamp(sum *= norm, 0.0f, this._max_voxel_value);
    }

    @Override
    public void sample_gradient_at(float x, float y, float z, Vector3f gradient_return) {
        int x_rounded_down = (int)x - 1;
        int y_rounded_down = (int)y - 1;
        int z_rounded_down = (int)z - 1;
        int index_base = this._gradient_function.coordinates_to_index(x_rounded_down, y_rounded_down, z_rounded_down);
        this.evaluate_filter_for_one_dimension(x, x_rounded_down, this._x_weights);
        this.evaluate_filter_for_one_dimension(y, y_rounded_down, this._y_weights);
        this.evaluate_filter_for_one_dimension(z, z_rounded_down, this._z_weights);
        gradient_return.set(0.0f, 0.0f, 0.0f);
        float norm = 0.0f;
        int k = 0;
        int cz = 0;
        while (cz < 4) {
            this.sum_y_gradient.set(0.0f, 0.0f, 0.0f);
            float norm_y = 0.0f;
            int cy = 0;
            while (cy < 4) {
                this.sum_x_gradient.set(0.0f, 0.0f, 0.0f);
                float norm_x = 0.0f;
                int cx = 0;
                while (cx < 4) {
                    int index = index_base + this._index_offsets[k];
                    this.add_scaled_gradient(index, this._x_weights[cx], this.sum_x_gradient);
                    norm_x += this._x_weights[cx];
                    ++k;
                    ++cx;
                }
                this.add_scaled_vector(this.sum_y_gradient, this.sum_x_gradient, this._y_weights[cy]);
                norm_y += norm_x * this._y_weights[cy];
                ++cy;
            }
            this.add_scaled_vector(gradient_return, this.sum_y_gradient, this._z_weights[cz]);
            norm += norm_y * this._z_weights[cz];
            ++cz;
        }
        norm = 1.0f / norm;
        gradient_return.scale(norm);
    }
}

