/*
 * Decompiled with CFR 0.152.
 */
package misc.grid.gradients;

import javax.vecmath.Vector3f;
import misc.Voxel;
import misc.grid.RegularGrid3i;
import misc.grid.gradients.GradientFunction;

public abstract class AbstractGradientFunction
implements GradientFunction {
    protected final RegularGrid3i _volume;
    protected final int _number_of_voxels;

    public AbstractGradientFunction(RegularGrid3i volume) {
        this._volume = volume;
        this._number_of_voxels = volume.get_number_of_voxels();
    }

    @Override
    public void gradient_at(int x, int y, int z, Vector3f gradient_return) {
        int index = this._volume.coordinates_to_index(x, y, z);
        this.gradient_at(index, gradient_return);
    }

    @Override
    public void gradient_at(Voxel v, Vector3f gradient_return) {
        this.gradient_at(v._x, v._y, v._z, gradient_return);
    }

    @Override
    public int get_dim_x() {
        return this._volume.get_dim_x();
    }

    @Override
    public int get_dim_y() {
        return this._volume.get_dim_y();
    }

    @Override
    public int get_dim_z() {
        return this._volume.get_dim_z();
    }

    @Override
    public int get_max_voxel_value() {
        return this._volume.get_max_voxel_value();
    }

    @Override
    public int get_number_of_voxels() {
        return this._volume.get_number_of_voxels();
    }

    @Override
    public int coordinates_to_index(int x, int y, int z) {
        return this._volume.coordinates_to_index(x, y, z);
    }

    @Override
    public int get_index_offset_for_y_plus_1() {
        return this._volume.get_index_offset_for_y_plus_1();
    }

    @Override
    public int get_index_offset_for_z_plus_1() {
        return this._volume.get_index_offset_for_z_plus_1();
    }

    @Override
    public int get_img_size() {
        return this._volume.get_img_size();
    }
}

