/*
 * Decompiled with CFR 0.152.
 */
package misc.grid.gradients;

import javax.vecmath.Vector3f;
import misc.grid.RegularGrid3i;
import misc.grid.gradients.AbstractGradientFunctionImpl;

final class CentralDifferenceFunction
extends AbstractGradientFunctionImpl {
    private final float _calculation_weight;

    CentralDifferenceFunction(RegularGrid3i volume) {
        super(volume);
        this._calculation_weight = 0.5f * this._normalization;
    }

    @Override
    public int get_filter_radius() {
        return 1;
    }

    @Override
    public void gradient_at(int index, Vector3f gradient_return) {
        gradient_return.x = this._calculation_weight * (float)(this._volume.get(index + 1) - this._volume.get(index - 1));
        gradient_return.y = this._calculation_weight * (float)(this._volume.get(index + this._offset_for_y_plus_1) - this._volume.get(index - this._offset_for_y_plus_1));
        gradient_return.z = this._calculation_weight * (float)(this._volume.get(index + this._offset_for_z_plus_1) - this._volume.get(index - this._offset_for_z_plus_1));
    }
}

