/*
 * Decompiled with CFR 0.152.
 */
package misc.grid.gradients;

import misc.grid.gradients.GradientFunctionAbstractTest;
import misc.grid.gradients.GradientFunctionType;
import org.junit.Before;
import org.junit.Test;

public class CentralDifferenceFunctionTest
extends GradientFunctionAbstractTest {
    private final int _y_offset;
    private final int _z_offset;

    public CentralDifferenceFunctionTest() {
        super(3, 0.0f, GradientFunctionType.CENTRAL_DIFFERENCES);
        this._y_offset = this._volume.get_index_offset_for_y_plus_1();
        this._z_offset = this._volume.get_index_offset_for_z_plus_1();
    }

    @Before
    public void set_up() {
        int i = 0;
        while (i < this._volume.get_number_of_voxels()) {
            this._volume.set(i, i + 1);
            ++i;
        }
    }

    @Test
    public void test_center_gradient() {
        this.gradient_at(1, 1, 1);
        this.assert_result_values(1.0, this._y_offset, this._z_offset);
    }

    @Test
    public void test_border_gradients() {
        this.gradient_at(0, 0, 0);
        this.assert_result_values(1.0, 2.0, 5.0);
        this.gradient_at(2, 2, 2);
        this.assert_result_values(-13.0, -12.0, -9.0);
    }
}

